/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.IOException;
import net.rim.device.api.system.EventLogger;
import org.logicprobe.LogicMail.mail.MailClient;
import org.logicprobe.LogicMail.mail.MailConnectionHandlerListener;
import org.logicprobe.LogicMail.mail.MailConnectionLoginEvent;
import org.logicprobe.LogicMail.mail.MailConnectionManager;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.util.Queue;

public abstract class AbstractMailConnectionHandler {
    private MailClient client;
    private ConnectionThread connectionThread;
    private int state;
    private Queue requestQueue;
    private MailConnectionHandlerListener listener;
    private int retryCount;
    private boolean invalidLogin;
    private boolean shutdownInProgress;
    public static final int STATE_CLOSED = 0;
    public static final int STATE_OPENING = 1;
    public static final int STATE_OPENED = 2;
    public static final int STATE_REQUESTS = 3;
    public static final int STATE_IDLE = 4;
    public static final int STATE_CLOSING = 5;

    protected AbstractMailConnectionHandler(MailClient client) {
        this.client = client;
        this.connectionThread = new ConnectionThread();
        this.state = 0;
        this.requestQueue = new Queue();
        this.listener = null;
        this.retryCount = 0;
        this.invalidLogin = false;
        this.shutdownInProgress = false;
    }

    public void start() {
        if (!this.connectionThread.isAlive()) {
            if (this.connectionThread.isShutdown()) {
                this.connectionThread = new ConnectionThread();
            }
            this.connectionThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        if (!this.connectionThread.isAlive()) {
            return;
        }
        Queue queue = this.requestQueue;
        synchronized (queue) {
            this.shutdownInProgress = true;
        }
        if (wait) {
            Object element;
            Queue queue2 = this.requestQueue;
            synchronized (queue2) {
                element = this.requestQueue.element();
            }
            while (element != null) {
                queue2 = this.requestQueue;
                synchronized (queue2) {
                    element = this.requestQueue.element();
                }
                Thread.yield();
            }
        }
        this.setConnectionState(5);
        this.connectionThread.shutdown();
        try {
            this.connectionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        queue = this.requestQueue;
        synchronized (queue) {
            this.shutdownInProgress = false;
        }
        MailConnectionManager.getInstance().fireMailConnectionStateChanged(this.client.getConnectionConfig(), 0);
    }

    public boolean isRunning() {
        return this.connectionThread.isAlive();
    }

    public void setListener(MailConnectionHandlerListener listener) {
        this.listener = listener;
    }

    protected MailConnectionHandlerListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(int type, Object[] params) {
        Queue queue = this.requestQueue;
        synchronized (queue) {
            if (!this.shutdownInProgress) {
                this.requestQueue.add(new Object[]{new Integer(type), params});
                this.requestQueue.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClosedConnection() {
        this.showStatus(null);
        Queue queue = this.requestQueue;
        synchronized (queue) {
            if (this.requestQueue.element() != null) {
                this.setConnectionState(1);
            } else if (!this.connectionThread.isShutdown()) {
                try {
                    this.requestQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOpeningConnection() throws IOException, MailException {
        this.showStatus("Opening connection...");
        if (this.checkLogin(this.client)) {
            if (this.client.open()) {
                this.invalidLogin = false;
                this.setConnectionState(2);
                MailConnectionManager.getInstance().fireMailConnectionStateChanged(this.client.getConnectionConfig(), 1);
                return;
            }
            this.invalidLogin = true;
            return;
        }
        this.setConnectionState(5);
        Queue queue = this.requestQueue;
        synchronized (queue) {
            this.requestQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOpenedConnection() throws IOException, MailException {
        this.showStatus(null);
        this.retryCount = 0;
        Queue queue = this.requestQueue;
        synchronized (queue) {
            if (this.requestQueue.element() != null) {
                this.setConnectionState(3);
            } else {
                this.setConnectionState(4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePendingRequests() throws IOException, MailException {
        Object element;
        Queue requestQueue;
        Queue queue = requestQueue = this.getRequestQueue();
        synchronized (queue) {
            element = requestQueue.element();
        }
        while (element != null) {
            queue = requestQueue;
            synchronized (queue) {
                requestQueue.remove();
            }
            Object[] request = (Object[])element;
            int type = (Integer)request[0];
            Object[] params = (Object[])request[1];
            this.showStatus("Processing requests...");
            this.handleRequest(type, params);
            Queue queue2 = requestQueue;
            synchronized (queue2) {
                element = requestQueue.element();
            }
        }
        this.setConnectionState(4);
    }

    protected abstract void handleRequest(int var1, Object[] var2) throws IOException, MailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIdleConnection() throws IOException, MailException {
        this.showStatus(null);
        this.handleBeginIdle();
        Queue queue = this.requestQueue;
        synchronized (queue) {
            if (this.requestQueue.element() != null) {
                this.setConnectionState(3);
            } else if (this.connectionThread.isShutdown()) {
                this.setConnectionState(5);
            }
        }
    }

    protected abstract void handleBeginIdle() throws IOException, MailException;

    private void handleClosingConnection() throws IOException, MailException {
        this.showStatus("Closing connection...");
        this.handleBeforeClosing();
        try {
            this.client.close();
        }
        catch (IOException e) {
        }
        catch (MailException mailException) {
            // empty catch block
        }
        this.setConnectionState(0);
        if (!this.shutdownInProgress) {
            MailConnectionManager.getInstance().fireMailConnectionStateChanged(this.client.getConnectionConfig(), 0);
        }
    }

    protected void handleBeforeClosing() {
    }

    public synchronized int getConnectionState() {
        return this.state;
    }

    protected synchronized void setConnectionState(int state) {
        if (state >= 0 && state <= 5) {
            this.state = state;
        }
    }

    protected Queue getRequestQueue() {
        return this.requestQueue;
    }

    protected boolean getShutdownInProgress() {
        return this.shutdownInProgress;
    }

    protected void sleepConnectionThread(long time) {
        if (!this.connectionThread.isShutdown()) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void showStatus(String message) {
        MailConnectionManager.getInstance().fireMailConnectionStatus(this.client.getConnectionConfig(), message);
    }

    private void showError(String message) {
        MailConnectionManager.getInstance().fireMailConnectionError(this.client.getConnectionConfig(), message);
    }

    private boolean checkLogin(MailClient client) {
        String username = client.getUsername();
        String password = client.getPassword();
        if (this.invalidLogin || username != null && password != null && (username.trim().equals("") || password.trim().equals(""))) {
            MailConnectionLoginEvent e = new MailConnectionLoginEvent(this, client.getConnectionConfig(), username, password);
            MailConnectionManager.getInstance().fireMailConnectionLogin(e);
            if (!e.isCanceled()) {
                client.setUsername(e.getUsername());
                client.setPassword(e.getPassword());
                return true;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIOException(IOException e) {
        EventLogger.logEvent((long)7765914274915215232L, (byte[])e.toString().getBytes(), (int)2);
        int state = this.getConnectionState();
        if (state == 1 || state == 5 || this.retryCount < 2) {
            Queue queue = this.requestQueue;
            synchronized (queue) {
                this.setConnectionState(5);
                this.requestQueue.clear();
            }
        } else {
            ++this.retryCount;
            this.setConnectionState(1);
        }
        this.showError(e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMailException(MailException e) {
        EventLogger.logEvent((long)7765914274915215232L, (byte[])e.toString().getBytes(), (int)2);
        if (e.isFatal()) {
            Queue queue = this.requestQueue;
            synchronized (queue) {
                this.setConnectionState(5);
                this.requestQueue.clear();
            }
        }
        this.showError(e.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleThrowable(Throwable t) {
        EventLogger.logEvent((long)7765914274915215232L, (byte[])t.toString().getBytes(), (int)2);
        Queue queue = this.requestQueue;
        synchronized (queue) {
            this.setConnectionState(5);
            this.requestQueue.clear();
        }
        this.showError(t.getMessage());
    }

    private class ConnectionThread
    extends Thread {
        private boolean shutdown = false;
        private boolean shutdownComplete = false;

        public ConnectionThread() {
            super("ConnectionThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            Object object = this;
            synchronized (object) {
                this.shutdown = true;
            }
            object = AbstractMailConnectionHandler.this.requestQueue;
            synchronized (object) {
                AbstractMailConnectionHandler.this.requestQueue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isShutdown() {
            boolean result;
            ConnectionThread connectionThread = this;
            synchronized (connectionThread) {
                result = this.shutdown;
            }
            return result;
        }

        public void run() {
            while (!this.shutdownComplete) {
                try {
                    switch (AbstractMailConnectionHandler.this.state) {
                        case 0: {
                            AbstractMailConnectionHandler.this.handleClosedConnection();
                            if (!this.shutdown) break;
                            this.shutdownComplete = true;
                            break;
                        }
                        case 1: {
                            AbstractMailConnectionHandler.this.handleOpeningConnection();
                            break;
                        }
                        case 2: {
                            AbstractMailConnectionHandler.this.handleOpenedConnection();
                            break;
                        }
                        case 3: {
                            AbstractMailConnectionHandler.this.handlePendingRequests();
                            break;
                        }
                        case 4: {
                            AbstractMailConnectionHandler.this.handleIdleConnection();
                            break;
                        }
                        case 5: {
                            AbstractMailConnectionHandler.this.handleClosingConnection();
                        }
                    }
                }
                catch (IOException e) {
                    if (AbstractMailConnectionHandler.this.state == 5) {
                        this.shutdownComplete = true;
                        continue;
                    }
                    AbstractMailConnectionHandler.this.handleIOException(e);
                }
                catch (MailException e) {
                    if (AbstractMailConnectionHandler.this.state == 5) {
                        this.shutdownComplete = true;
                        continue;
                    }
                    AbstractMailConnectionHandler.this.handleMailException(e);
                }
                catch (Throwable t) {
                    if (AbstractMailConnectionHandler.this.state == 5) {
                        this.shutdownComplete = true;
                        continue;
                    }
                    AbstractMailConnectionHandler.this.handleThrowable(t);
                }
            }
        }
    }
}

