/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.IOException;
import net.rim.device.api.system.UnsupportedOperationException;
import org.logicprobe.LogicMail.mail.AbstractMailConnectionHandler;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailConnectionHandlerListener;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.imap.ImapClient;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.util.Queue;

public class IncomingMailConnectionHandler
extends AbstractMailConnectionHandler {
    private IncomingMailClient incomingClient;
    public static final int REQUEST_FOLDER_TREE = 10;
    public static final int REQUEST_FOLDER_STATUS = 11;
    public static final int REQUEST_FOLDER_MESSAGES_RANGE = 12;
    public static final int REQUEST_FOLDER_MESSAGES_SET = 13;
    public static final int REQUEST_FOLDER_MESSAGES_RECENT = 14;
    public static final int REQUEST_MESSAGE = 20;
    public static final int REQUEST_MESSAGE_DELETE = 21;
    public static final int REQUEST_MESSAGE_UNDELETE = 22;
    public static final int REQUEST_MESSAGE_ANSWERED = 23;
    public static final int REQUEST_MESSAGE_APPEND = 24;
    private static final int IDLE_TIMEOUT = 300000;
    private static final int IDLE_POLL_INTERVAL = 500;

    public IncomingMailConnectionHandler(IncomingMailClient client) {
        super(client);
        this.incomingClient = client;
    }

    protected void handleRequest(int type, Object[] params) throws IOException, MailException {
        switch (type) {
            case 10: {
                this.handleRequestFolderTree();
                break;
            }
            case 11: {
                this.handleRequestFolderStatus((FolderTreeItem[])params[0]);
                break;
            }
            case 12: {
                this.handleRequestFolderMessagesRange((FolderTreeItem)params[0], (Integer)params[1], (Integer)params[2]);
                break;
            }
            case 13: {
                this.handleRequestFolderMessagesSet((FolderTreeItem)params[0], (int[])params[1]);
                break;
            }
            case 14: {
                this.handleRequestFolderMessagesRecent((FolderTreeItem)params[0]);
                break;
            }
            case 20: {
                this.handleRequestMessage((FolderTreeItem)params[0], (FolderMessage)params[1]);
                break;
            }
            case 21: {
                this.handleRequestMessageDelete((FolderTreeItem)params[0], (FolderMessage)params[1]);
                break;
            }
            case 22: {
                this.handleRequestMessageUndelete((FolderTreeItem)params[0], (FolderMessage)params[1]);
                break;
            }
            case 23: {
                this.handleRequestMessageAnswered((FolderTreeItem)params[0], (FolderMessage)params[1]);
                break;
            }
            case 24: {
                this.handleRequestMessageAppend((FolderTreeItem)params[0], (String)params[1], (MessageFlags)params[2]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleBeginIdle() throws IOException, MailException {
        if (this.incomingClient.hasIdle()) {
            this.incomingClient.idleModeBegin();
            boolean endIdle = false;
            int idleTime = 0;
            while (!endIdle) {
                Queue requestQueue;
                this.sleepConnectionThread(500L);
                idleTime += 500;
                if (this.incomingClient.idleModePoll()) {
                    this.addRequest(14, new Object[]{this.incomingClient.getActiveFolder()});
                    endIdle = true;
                    continue;
                }
                if (this.getShutdownInProgress()) {
                    endIdle = true;
                    continue;
                }
                if (idleTime >= 300000) {
                    endIdle = true;
                    continue;
                }
                Queue queue = requestQueue = this.getRequestQueue();
                synchronized (queue) {
                    if (requestQueue.element() != null) {
                        endIdle = true;
                    }
                }
            }
            this.incomingClient.idleModeEnd();
            if (idleTime >= 300000) {
                if (this.incomingClient.noop()) {
                    this.addRequest(14, new Object[]{this.incomingClient.getActiveFolder()});
                } else {
                    FolderTreeItem inboxMailbox = this.incomingClient.getInboxFolder();
                    FolderTreeItem activeMailbox = this.incomingClient.getActiveFolder();
                    if (inboxMailbox != null && !inboxMailbox.getPath().equalsIgnoreCase(activeMailbox.getPath())) {
                        this.incomingClient.setActiveFolder(inboxMailbox);
                    }
                }
            }
        } else {
            Queue requestQueue;
            Queue queue = requestQueue = this.getRequestQueue();
            synchronized (queue) {
                if (requestQueue.element() != null) {
                    return;
                }
                try {
                    requestQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void handleRequestFolderTree() throws IOException, MailException {
        FolderTreeItem root = this.incomingClient.getFolderTree();
        MailConnectionHandlerListener listener = this.getListener();
        if (root != null && listener != null) {
            listener.mailConnectionRequestComplete(10, root);
        }
    }

    private void handleRequestFolderStatus(FolderTreeItem[] folders) throws IOException, MailException {
        this.incomingClient.refreshFolderStatus(folders);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(11, folders);
        }
    }

    private void handleRequestFolderMessagesRange(FolderTreeItem folder, int firstIndex, int lastIndex) throws IOException, MailException {
        this.checkActiveFolder(folder);
        FolderMessage[] messages = this.incomingClient.getFolderMessages(firstIndex, lastIndex);
        MailConnectionHandlerListener listener = this.getListener();
        if (messages != null && messages.length > 0 && listener != null) {
            listener.mailConnectionRequestComplete(12, new Object[]{folder, messages});
        }
    }

    private void handleRequestFolderMessagesSet(FolderTreeItem folder, int[] indices) throws IOException, MailException {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    private void handleRequestFolderMessagesRecent(FolderTreeItem folder) throws IOException, MailException {
        this.checkActiveFolder(folder);
        FolderMessage[] messages = this.incomingClient.getNewFolderMessages();
        MailConnectionHandlerListener listener = this.getListener();
        if (messages != null && messages.length > 0 && listener != null) {
            listener.mailConnectionRequestComplete(14, new Object[]{folder, messages});
        }
    }

    private void handleRequestMessage(FolderTreeItem folder, FolderMessage folderMessage) throws IOException, MailException {
        this.checkActiveFolder(folder);
        Message message = this.incomingClient.getMessage(folderMessage);
        MailConnectionHandlerListener listener = this.getListener();
        if (message != null && listener != null) {
            listener.mailConnectionRequestComplete(20, new Object[]{folder, folderMessage, message});
        }
    }

    private void handleRequestMessageDelete(FolderTreeItem folder, FolderMessage folderMessage) throws IOException, MailException {
        this.checkActiveFolder(folder);
        this.incomingClient.deleteMessage(folderMessage);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(21, new Object[]{folder, folderMessage});
        }
    }

    private void handleRequestMessageUndelete(FolderTreeItem folder, FolderMessage folderMessage) throws IOException, MailException {
        this.checkActiveFolder(folder);
        this.incomingClient.undeleteMessage(folderMessage);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(22, new Object[]{folder, folderMessage});
        }
    }

    private void handleRequestMessageAnswered(FolderTreeItem folder, FolderMessage folderMessage) throws IOException, MailException {
        ((ImapClient)this.incomingClient).messageAnswered(folderMessage);
        folderMessage.setAnswered(true);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(23, new Object[]{folder, folderMessage});
        }
    }

    private void handleRequestMessageAppend(FolderTreeItem folder, String rawMessage, MessageFlags initialFlags) throws IOException, MailException {
        ((ImapClient)this.incomingClient).appendMessage(folder, rawMessage, initialFlags);
        MailConnectionHandlerListener listener = this.getListener();
        if (listener != null) {
            listener.mailConnectionRequestComplete(24, new Object[]{folder, null});
        }
    }

    private void checkActiveFolder(FolderTreeItem requestFolder) throws IOException, MailException {
        if (this.incomingClient.getActiveFolder() == null || !this.incomingClient.getActiveFolder().getPath().equals(requestFolder.getPath())) {
            this.incomingClient.setActiveFolder(requestFolder);
        }
    }
}

