/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.mail.AbstractMailStore;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.MaildirFolder;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.util.MailMessageParser;
import org.logicprobe.LogicMail.util.ThreadQueue;

public class LocalMailStore
extends AbstractMailStore {
    private FolderTreeItem rootFolder;
    private ThreadQueue threadQueue = new ThreadQueue();
    private Hashtable folderMaildirMap = new Hashtable();

    public LocalMailStore() {
        this.rootFolder = new FolderTreeItem("", "", "");
        this.rootFolder.addChild(new FolderTreeItem(this.rootFolder, "Outbox", "Outbox", "/", true, false));
        this.rootFolder.addChild(new FolderTreeItem(this.rootFolder, "Drafts", "Drafts", "/", true, true));
        this.rootFolder.addChild(new FolderTreeItem(this.rootFolder, "Sent", "Sent", "/", true, true));
        this.rootFolder.addChild(new FolderTreeItem(this.rootFolder, "Trash", "Trash", "/", true, true));
    }

    public void shutdown(boolean wait) {
        this.threadQueue.shutdown(wait);
    }

    public boolean isLocal() {
        return true;
    }

    public boolean hasFolders() {
        return true;
    }

    public boolean hasFlags() {
        return true;
    }

    public boolean hasAppend() {
        return true;
    }

    public boolean hasUndelete() {
        return false;
    }

    public void requestFolderTree() {
        this.fireFolderTreeUpdated(this.rootFolder);
    }

    public void requestFolderStatus(FolderTreeItem[] folders) {
        int i;
        FolderTreeItem[] localFolders = this.rootFolder.children();
        block0: for (i = 0; i < folders.length; ++i) {
            for (int j = 0; j < localFolders.length; ++j) {
                if (!folders[i].getPath().equals(localFolders[j].getPath())) continue;
                folders[i] = localFolders[j];
                continue block0;
            }
        }
        for (i = 0; i < folders.length; ++i) {
            this.fireFolderStatusChanged(folders[i]);
        }
    }

    public void requestFolderMessagesRange(FolderTreeItem folder, int firstIndex, int lastIndex) {
    }

    public void requestFolderMessagesSet(FolderTreeItem folder, int[] indices) {
    }

    public void requestFolderMessagesRecent(FolderTreeItem folder) {
        FolderTreeItem requestFolder = this.getMatchingFolderTreeItem(folder);
        if (requestFolder != null) {
            this.threadQueue.invokeLater(new RequestFolderMessagesRecentRunnable(requestFolder));
        }
    }

    public void requestMessage(FolderTreeItem folder, FolderMessage folderMessage) {
        FolderTreeItem requestFolder = this.getMatchingFolderTreeItem(folder);
        if (requestFolder != null && folderMessage != null) {
            this.threadQueue.invokeLater(new RequestMessageRunnable(requestFolder, folderMessage));
        }
    }

    public void requestMessageDelete(FolderTreeItem folder, FolderMessage folderMessage) {
    }

    public void requestMessageUndelete(FolderTreeItem folder, FolderMessage folderMessage) {
    }

    public void requestMessageAnswered(FolderTreeItem folder, FolderMessage folderMessage) {
    }

    public void requestMessageAppend(FolderTreeItem folder, String rawMessage, MessageFlags initialFlags) {
        FolderTreeItem requestFolder = this.getMatchingFolderTreeItem(folder);
        if (requestFolder != null && rawMessage != null && rawMessage.length() > 0 && initialFlags != null) {
            this.threadQueue.invokeLater(new RequestMessageAppendRunnable(requestFolder, rawMessage, initialFlags));
        }
    }

    private FolderTreeItem getMatchingFolderTreeItem(FolderTreeItem folder) {
        FolderTreeItem[] localFolders = this.rootFolder.children();
        FolderTreeItem requestFolder = null;
        for (int i = 0; i < localFolders.length; ++i) {
            if (!localFolders[i].getPath().equals(folder.getPath())) continue;
            requestFolder = localFolders[i];
            break;
        }
        return requestFolder;
    }

    private abstract class MaildirRunnable
    implements Runnable {
        protected FolderTreeItem requestFolder;
        protected MaildirFolder maildirFolder;

        public MaildirRunnable(FolderTreeItem requestFolder) {
            this.requestFolder = requestFolder;
            if (LocalMailStore.this.folderMaildirMap.containsKey(requestFolder)) {
                this.maildirFolder = (MaildirFolder)LocalMailStore.this.folderMaildirMap.get(requestFolder);
            } else {
                String folderUrl = MailSettings.getInstance().getGlobalConfig().getLocalDataLocation();
                try {
                    FileConnection fileConnection = (FileConnection)Connector.open((String)folderUrl);
                    if (!fileConnection.exists()) {
                        fileConnection.mkdir();
                    }
                    fileConnection.close();
                }
                catch (IOException e) {
                    System.err.println("Error preparing root path: " + e.toString());
                }
                StringBuffer buf = new StringBuffer();
                buf.append(folderUrl);
                buf.append(requestFolder.getPath());
                this.maildirFolder = new MaildirFolder(buf.toString());
                LocalMailStore.this.folderMaildirMap.put(requestFolder, this.maildirFolder);
            }
        }

        public abstract /* synthetic */ void run();
    }

    private class RequestMessageAppendRunnable
    extends MaildirRunnable {
        private String rawMessage;
        private MessageFlags initialFlags;

        public RequestMessageAppendRunnable(FolderTreeItem requestFolder, String rawMessage, MessageFlags initialFlags) {
            super(requestFolder);
            this.rawMessage = rawMessage;
            this.initialFlags = initialFlags;
        }

        public void run() {
            FolderMessage folderMessage = null;
            try {
                this.maildirFolder.open();
                folderMessage = this.maildirFolder.appendMessage(this.rawMessage, this.initialFlags);
                this.maildirFolder.close();
            }
            catch (IOException e) {
                System.err.println("Unable to read folder: " + e.toString());
            }
            if (folderMessage != null) {
                LocalMailStore.this.fireFolderMessagesAvailable(this.requestFolder, new FolderMessage[]{folderMessage});
            }
        }
    }

    private class RequestMessageRunnable
    extends MaildirRunnable {
        private FolderMessage folderMessage;

        public RequestMessageRunnable(FolderTreeItem requestFolder, FolderMessage folderMessage) {
            super(requestFolder);
            this.folderMessage = folderMessage;
        }

        public void run() {
            String messageSource = null;
            Message message = null;
            try {
                this.maildirFolder.open();
                messageSource = this.maildirFolder.getMessageSource(this.folderMessage);
                this.maildirFolder.close();
                MessagePart rootPart = MailMessageParser.parseRawMessage(new ByteArrayInputStream(messageSource.getBytes()));
                message = new Message(this.folderMessage.getEnvelope(), rootPart);
            }
            catch (IOException e) {
                System.err.println("Unable to read message: " + e.toString());
            }
            if (message != null && messageSource != null) {
                LocalMailStore.this.fireMessageAvailable(this.requestFolder, this.folderMessage, message, messageSource);
            }
        }
    }

    private class RequestFolderMessagesRecentRunnable
    extends MaildirRunnable {
        public RequestFolderMessagesRecentRunnable(FolderTreeItem requestFolder) {
            super(requestFolder);
        }

        public void run() {
            FolderMessage[] folderMessages = null;
            try {
                this.maildirFolder.open();
                folderMessages = this.maildirFolder.getFolderMessages();
                this.maildirFolder.close();
            }
            catch (IOException e) {
                System.err.println("Unable to read folder: " + e.toString());
            }
            if (folderMessages != null) {
                LocalMailStore.this.fireFolderMessagesAvailable(this.requestFolder, folderMessages);
            }
        }
    }
}

