/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.imap;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.imap.ImapParser;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.StringParser;

public class ImapProtocol {
    private Connection connection;
    private String idleCommandTag;
    private int commandCount = 0;

    public ImapProtocol(Connection connection) {
        this.connection = connection;
    }

    public boolean executeLogin(String username, String password) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeLogin(\"" + username + "\", \"" + password + "\")").getBytes(), (int)5);
        }
        try {
            this.execute("LOGIN", "\"" + StringParser.addEscapedChars(username) + "\" \"" + StringParser.addEscapedChars(password) + "\"");
        }
        catch (MailException exp) {
            return false;
        }
        return true;
    }

    public void executeLogout() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapProtocol.executeLogout()".getBytes(), (int)5);
        }
        this.execute("LOGOUT", null);
    }

    public void executeClose() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapProtocol.executeClose()".getBytes(), (int)5);
        }
        this.execute("CLOSE", null);
    }

    public Hashtable executeCapability() throws IOException, MailException {
        String[] replyText;
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapProtocol.executeCapability()".getBytes(), (int)5);
        }
        if ((replyText = this.execute("CAPABILITY", null)) == null || replyText.length < 1) {
            throw new MailException("Unable to query server capabilities");
        }
        Hashtable<String, Boolean> table = new Hashtable<String, Boolean>();
        String[] tokens = StringParser.parseTokenString(replyText[0], " ");
        if (tokens.length > 2 && tokens[1].equals("CAPABILITY")) {
            for (int i = 2; i < tokens.length; ++i) {
                table.put(tokens[i], Boolean.TRUE);
            }
        }
        return table;
    }

    public NamespaceResponse executeNamespace() throws IOException, MailException {
        Vector temp;
        int i;
        int size;
        Vector nsTokens;
        String[] replyText;
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapProtocol.executeNamespace()".getBytes(), (int)5);
        }
        if ((replyText = this.execute("NAMESPACE", null)) == null || replyText.length < 1) {
            throw new MailException("Unable to query server namespaces");
        }
        Vector tokens = StringParser.nestedParenStringLexer("(" + replyText[0].substring(replyText[0].indexOf(40)) + ")");
        if (tokens == null || tokens.size() < 3) {
            return new NamespaceResponse();
        }
        NamespaceResponse response = new NamespaceResponse();
        if (tokens.elementAt(0) instanceof Vector) {
            nsTokens = (Vector)tokens.elementAt(0);
            size = nsTokens.size();
            response.personal = new Namespace[size];
            for (i = 0; i < nsTokens.size(); ++i) {
                if (!(nsTokens.elementAt(i) instanceof Vector)) continue;
                temp = (Vector)nsTokens.elementAt(i);
                response.personal[i] = new Namespace();
                if (temp.size() < 2) continue;
                if (temp.elementAt(0) instanceof String) {
                    response.personal[i].prefix = StringParser.removeEscapedChars((String)temp.elementAt(0));
                }
                if (!(temp.elementAt(1) instanceof String)) continue;
                response.personal[i].delimiter = StringParser.removeEscapedChars((String)temp.elementAt(1));
            }
        }
        if (tokens.elementAt(1) instanceof Vector) {
            nsTokens = (Vector)tokens.elementAt(1);
            size = nsTokens.size();
            response.other = new Namespace[size];
            for (i = 0; i < nsTokens.size(); ++i) {
                if (!(nsTokens.elementAt(i) instanceof Vector)) continue;
                temp = (Vector)nsTokens.elementAt(i);
                response.other[i] = new Namespace();
                if (temp.size() < 2) continue;
                if (temp.elementAt(0) instanceof String) {
                    response.other[i].prefix = StringParser.removeEscapedChars((String)temp.elementAt(0));
                }
                if (!(temp.elementAt(1) instanceof String)) continue;
                response.other[i].delimiter = StringParser.removeEscapedChars((String)temp.elementAt(1));
            }
        }
        if (tokens.elementAt(2) instanceof Vector) {
            nsTokens = (Vector)tokens.elementAt(2);
            size = nsTokens.size();
            response.shared = new Namespace[size];
            for (i = 0; i < nsTokens.size(); ++i) {
                if (!(nsTokens.elementAt(i) instanceof Vector)) continue;
                temp = (Vector)nsTokens.elementAt(i);
                response.shared[i] = new Namespace();
                if (temp.size() < 2) continue;
                if (temp.elementAt(0) instanceof String) {
                    response.shared[i].prefix = StringParser.removeEscapedChars((String)temp.elementAt(0));
                }
                if (!(temp.elementAt(1) instanceof String)) continue;
                response.shared[i].delimiter = StringParser.removeEscapedChars((String)temp.elementAt(1));
            }
        }
        return response;
    }

    public SelectResponse executeSelect(String mboxpath) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeSelect(\"" + mboxpath + "\")").getBytes(), (int)5);
        }
        String[] replyText = this.execute("SELECT", "\"" + StringParser.addEscapedChars(mboxpath) + "\"");
        SelectResponse response = new SelectResponse();
        for (int i = 0; i < replyText.length; ++i) {
            int q;
            String rowText = replyText[i];
            int p = rowText.indexOf(" EXISTS");
            if (p != -1) {
                q = p;
                p = rowText.indexOf(32);
                if (q == -1 || p == -1 || q <= p) continue;
                try {
                    response.exists = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.exists = 0;
                }
                continue;
            }
            p = rowText.indexOf(" RECENT");
            if (p != -1) {
                q = p;
                p = rowText.indexOf(32);
                if (q == -1 || p == -1 || q <= p) continue;
                try {
                    response.recent = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.recent = 0;
                }
                continue;
            }
            p = rowText.indexOf("UNSEEN ");
            if (p != -1) {
                q = rowText.indexOf(93);
                if (q == -1 || (p += 6) == -1 || q <= p) continue;
                try {
                    response.unseen = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.unseen = 0;
                }
                continue;
            }
            p = rowText.indexOf("UIDVALIDITY ");
            if (p != -1) {
                q = rowText.indexOf(93);
                if (q == -1 || (p += 11) == -1 || q <= p) continue;
                try {
                    response.uidValidity = Integer.parseInt(rowText.substring(p + 1, q));
                }
                catch (NumberFormatException e) {
                    response.uidValidity = 0;
                }
                continue;
            }
            p = rowText.indexOf("UIDNEXT ");
            if (p == -1 || (q = rowText.indexOf(93)) == -1 || (p += 7) == -1 || q <= p) continue;
            try {
                response.uidNext = Integer.parseInt(rowText.substring(p + 1, q));
                continue;
            }
            catch (NumberFormatException e) {
                response.uidNext = 0;
            }
        }
        return response;
    }

    public StatusResponse[] executeStatus(String[] mboxpaths) throws IOException, MailException {
        int i;
        if (EventLogger.getMinimumLevel() >= 5) {
            StringBuffer buf = new StringBuffer();
            buf.append("ImapProtocol.executeStatus({\r\n");
            if (mboxpaths == null) {
                buf.append("  null\r\n");
            } else {
                for (int i2 = 0; i2 < mboxpaths.length; ++i2) {
                    buf.append("  \"" + mboxpaths[i2] + "\"\r\n");
                }
            }
            buf.append("})");
            EventLogger.logEvent((long)7765914274915215232L, (byte[])buf.toString().getBytes(), (int)5);
        }
        StatusResponse[] response = new StatusResponse[mboxpaths.length];
        String[] arguments = new String[mboxpaths.length];
        for (i = 0; i < mboxpaths.length; ++i) {
            arguments[i] = "\"" + StringParser.addEscapedChars(mboxpaths[i]) + "\" (MESSAGES UNSEEN)";
        }
        String[] result = this.executeBatch("STATUS", arguments);
        if (result == null || result.length != arguments.length) {
            throw new MailException("Unable to query folder status");
        }
        for (i = 0; i < arguments.length; ++i) {
            String[] fields;
            response[i] = new StatusResponse();
            if (result[i] == null) continue;
            int p = result[i].indexOf(40);
            int q = result[i].indexOf(41);
            if (p == -1 || q == -1 || p >= q || (fields = StringParser.parseTokenString(result[i].substring(p + 1, q), " ")).length != 4) continue;
            for (int j = 0; j < fields.length; j += 2) {
                if (fields[j].equalsIgnoreCase("MESSAGES")) {
                    try {
                        response[i].exists = Integer.parseInt(fields[j + 1]);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (!fields[j].equalsIgnoreCase("UNSEEN")) continue;
                try {
                    response[i].unseen = Integer.parseInt(fields[j + 1]);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return response;
    }

    public FetchEnvelopeResponse[] executeFetchEnvelope(int firstIndex, int lastIndex) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeFetchEnvelope(" + firstIndex + ", " + lastIndex + ")").getBytes(), (int)5);
        }
        String[] rawList = this.execute("FETCH", Integer.toString(firstIndex) + ":" + Integer.toString(lastIndex) + " (FLAGS UID ENVELOPE)");
        return this.prepareFetchEnvelopeResponse(rawList);
    }

    public FetchEnvelopeResponse[] executeFetchEnvelopeUid(int uidNext) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeFetchEnvelopeUid(" + uidNext + ")").getBytes(), (int)5);
        }
        String[] rawList = this.execute("UID FETCH", Integer.toString(uidNext) + ":*" + " (FLAGS UID ENVELOPE)");
        return this.prepareFetchEnvelopeResponse(rawList);
    }

    private FetchEnvelopeResponse[] prepareFetchEnvelopeResponse(String[] rawList) throws IOException, MailException {
        StringBuffer lineBuf = new StringBuffer();
        Vector<String> rawList2 = new Vector<String>();
        for (int i = 0; i < rawList.length; ++i) {
            String line = rawList[i];
            if (line.length() > 0 && lineBuf.toString().startsWith("* ") && line.startsWith("* ")) {
                rawList2.addElement(lineBuf.toString());
                lineBuf = new StringBuffer();
            }
            lineBuf.append(line);
            if (i != rawList.length - 1 || !lineBuf.toString().startsWith("* ")) continue;
            rawList2.addElement(lineBuf.toString());
        }
        Vector<FetchEnvelopeResponse> envResponses = new Vector<FetchEnvelopeResponse>();
        int size = rawList2.size();
        for (int i = 0; i < size; ++i) {
            try {
                int midx;
                String rawText = (String)rawList2.elementAt(i);
                MessageEnvelope env = null;
                Vector parsedText = null;
                try {
                    parsedText = StringParser.nestedParenStringLexer(rawText.substring(rawText.indexOf(40)));
                }
                catch (Exception exp) {
                    parsedText = null;
                }
                FetchEnvelopeResponse envRespItem = new FetchEnvelopeResponse();
                envRespItem.flags = null;
                int parsedSize = parsedText.size();
                for (int j = 0; j < parsedSize; ++j) {
                    if (!(parsedText.elementAt(j) instanceof String)) continue;
                    if (((String)parsedText.elementAt(j)).equals("FLAGS") && parsedSize > j + 1 && parsedText.elementAt(j + 1) instanceof Vector) {
                        envRespItem.flags = ImapParser.parseMessageFlags((Vector)parsedText.elementAt(j + 1));
                        continue;
                    }
                    if (((String)parsedText.elementAt(j)).equals("UID") && parsedSize > j + 1 && parsedText.elementAt(j + 1) instanceof String) {
                        try {
                            envRespItem.uid = Integer.parseInt((String)parsedText.elementAt(j + 1));
                        }
                        catch (NumberFormatException e) {
                            envRespItem.uid = -1;
                        }
                        continue;
                    }
                    if (!((String)parsedText.elementAt(j)).equals("ENVELOPE") || parsedSize <= j + 1 || !(parsedText.elementAt(j + 1) instanceof Vector)) continue;
                    env = ImapParser.parseMessageEnvelope((Vector)parsedText.elementAt(j + 1));
                }
                if (env == null) {
                    env = ImapParser.generateDummyEnvelope();
                }
                if (envRespItem.flags == null) {
                    envRespItem.flags = new MessageFlags();
                }
                envRespItem.index = midx = Integer.parseInt(rawText.substring(rawText.indexOf(32), rawText.indexOf("FETCH") - 1).trim());
                envRespItem.envelope = env;
                envResponses.addElement(envRespItem);
                continue;
            }
            catch (Exception exp) {
                System.err.println("Parse error: " + exp);
            }
        }
        Object[] result = new FetchEnvelopeResponse[envResponses.size()];
        envResponses.copyInto(result);
        return result;
    }

    public ImapParser.MessageSection executeFetchBodystructure(int uid) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeFetchBodyStructure(" + uid + ")").getBytes(), (int)5);
        }
        String[] rawList = this.execute("UID FETCH", uid + " (BODYSTRUCTURE)");
        StringBuffer lineBuf = new StringBuffer();
        Vector<String> rawList2 = new Vector<String>();
        for (int i = 0; i < rawList.length; ++i) {
            String line = rawList[i];
            if (line.length() > 0 && lineBuf.toString().startsWith("* ") && line.startsWith("* ")) {
                rawList2.addElement(lineBuf.toString());
                lineBuf = new StringBuffer();
            }
            lineBuf.append(line);
            if (i != rawList.length - 1 || !lineBuf.toString().startsWith("* ")) continue;
            rawList2.addElement(lineBuf.toString());
        }
        ImapParser.MessageSection msgStructure = null;
        int size = rawList2.size();
        for (int i = 0; i < size; ++i) {
            try {
                msgStructure = ImapParser.parseMessageStructure((String)rawList2.elementAt(i));
                continue;
            }
            catch (Exception exp) {
                System.out.println("Parse error: " + exp);
            }
        }
        return msgStructure;
    }

    public String executeFetchBody(int uid, String address) throws IOException, MailException {
        String[] rawList;
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeFetchBody(" + uid + ", \"" + address + "\")").getBytes(), (int)5);
        }
        if ((rawList = this.execute("UID FETCH", uid + " (BODY[" + address + "])")).length <= 1) {
            return "";
        }
        int p = rawList[0].indexOf(123);
        int q = rawList[0].indexOf(125);
        int messageLength = -1;
        if (p != -1 && q != -1 && q - p > 1) {
            try {
                messageLength = Integer.parseInt(rawList[0].substring(p + 1, q));
            }
            catch (NumberFormatException e) {
                messageLength = -1;
            }
        }
        StringBuffer msgBuf = new StringBuffer();
        if (messageLength != -1) {
            for (int i = 1; i < rawList.length; ++i) {
                int rawListLength = rawList[i].length();
                if (rawListLength + 2 <= messageLength) {
                    msgBuf.append(rawList[i]);
                    messageLength -= rawListLength;
                    msgBuf.append("\r\n");
                    messageLength -= 2;
                    continue;
                }
                if (messageLength == 1 && rawListLength == 1 && rawList[i].charAt(0) == ')') continue;
                msgBuf.append(rawList[i].substring(0, messageLength));
            }
        } else {
            int lastLineIndex;
            for (lastLineIndex = rawList.length - 1; lastLineIndex > 0 && rawList[lastLineIndex].startsWith("* "); --lastLineIndex) {
            }
            for (int i = 1; i < lastLineIndex; ++i) {
                msgBuf.append(rawList[i]);
                msgBuf.append("\r\n");
            }
            String lastLine = rawList[lastLineIndex];
            msgBuf.append(lastLine.substring(0, lastLine.lastIndexOf(41)));
        }
        return msgBuf.toString();
    }

    public MessageFlags executeStore(int uid, boolean addOrRemove, String[] flags) throws IOException, MailException {
        int i;
        StringBuffer buf;
        if (EventLogger.getMinimumLevel() >= 5) {
            buf = new StringBuffer();
            for (i = 0; i < flags.length; ++i) {
                buf.append('\"');
                buf.append(flags[i]);
                buf.append('\"');
                if (i >= flags.length - 1) continue;
                buf.append(", ");
            }
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeStore(" + uid + ", " + (addOrRemove ? "add" : "remove") + ", {" + buf.toString() + "})").getBytes(), (int)5);
        }
        buf = new StringBuffer();
        buf.append(uid);
        buf.append(' ');
        buf.append(addOrRemove ? (char)'+' : '-');
        buf.append("FLAGS (");
        for (i = 0; i < flags.length; ++i) {
            buf.append(flags[i]);
            if (i >= flags.length - 1) continue;
            buf.append(' ');
        }
        buf.append(')');
        String[] rawList = this.execute("UID STORE", buf.toString());
        if (rawList.length < 1) {
            throw new MailException("Unable to set message flags");
        }
        try {
            int fetchIndex;
            int p = rawList[0].indexOf("UID");
            int q = rawList[0].lastIndexOf(41);
            if (p != -1 && q != -1 && p < q && (fetchIndex = Integer.parseInt(rawList[0].substring(p + 4, q))) != uid) {
                return null;
            }
            p = rawList[0].indexOf("FLAGS (");
            q = rawList[0].indexOf(") UID");
            if (p == -1 || q == -1) {
                return null;
            }
            String[] tokens = StringParser.parseTokenString(rawList[0].substring(p + 7, q), " ");
            Vector<String> tokenVec = new Vector<String>(tokens.length);
            for (int i2 = 0; i2 < tokens.length; ++i2) {
                tokenVec.addElement(tokens[i2]);
            }
            return ImapParser.parseMessageFlags(tokenVec);
        }
        catch (Exception e) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("Unable to parse STORE response: " + e.toString()).getBytes(), (int)2);
            return null;
        }
    }

    public void executeAppend(String mboxName, String rawMessage, MessageFlags flags) throws IOException, MailException {
        String flagsString = ImapParser.createMessageFlagsString(flags);
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeAppend(rawMessage, \"" + flagsString + "\")").getBytes(), (int)5);
        }
        this.executeContinue("APPEND", "\"" + StringParser.addEscapedChars(mboxName) + "\" (" + flagsString + ") {" + rawMessage.length() + "}", rawMessage, "Unable to append message to " + mboxName);
    }

    public Vector executeList(String refName, String mboxName) throws IOException, MailException {
        int q;
        int p;
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("ImapProtocol.executeList(\"" + refName + "\", \"" + mboxName + "\")").getBytes(), (int)5);
        }
        String[] results = this.execute("LIST", "\"" + StringParser.addEscapedChars(refName) + "\" \"" + StringParser.addEscapedChars(mboxName) + "\"");
        Vector<ListResponse> retVec = new Vector<ListResponse>(results.length);
        Vector<String> resultsVec = new Vector<String>();
        int line = 0;
        while (line < results.length) {
            p = results[line].indexOf(123);
            q = results[line].indexOf(125);
            if (line < results.length - 1 && p != -1 && q != -1 && p < q && q == results[line].length() - 1) {
                int len = Integer.parseInt(results[line].substring(p + 1, q));
                resultsVec.addElement(results[line].substring(0, p) + results[line + 1].substring(0, len));
                line += 2;
                continue;
            }
            resultsVec.addElement(results[line]);
            ++line;
        }
        int resultsSize = resultsVec.size();
        for (int i = 0; i < resultsSize; ++i) {
            String flagStr = null;
            String argStr = null;
            String temp = (String)resultsVec.elementAt(i);
            p = temp.indexOf(40);
            q = temp.indexOf(41, p + 1);
            if (p != -1 && q > p) {
                flagStr = temp.substring(p + 1, q);
            }
            if (temp.length() > q + 2) {
                argStr = temp.substring(q + 2);
            }
            ListResponse response = new ListResponse();
            response.delim = "";
            response.name = "";
            response.canSelect = flagStr.indexOf("\\Noselect") == -1;
            response.hasChildren = flagStr.indexOf("\\HasChildren") != -1;
            response.noInferiors = flagStr.indexOf("\\Noinferiors") != -1;
            response.marked = flagStr.indexOf("\\Marked") != -1;
            try {
                p = 0;
                q = 0;
                int size = argStr.length();
                if (argStr.charAt(p) == '\"') {
                    for (q = ++p + 1; q < size && argStr.charAt(q) != '\"'; ++q) {
                    }
                    response.delim = argStr.substring(p, q);
                    p = q + 2;
                } else {
                    for (q = p + 1; q < size && argStr.charAt(q) != ' '; ++q) {
                    }
                    response.delim = argStr.substring(p, q);
                    p = q + 1;
                }
                if (response.delim.equalsIgnoreCase("NIL")) {
                    response.delim = "";
                }
                if (argStr.charAt(p) == '\"') {
                    for (q = ++p + 1; q < size && argStr.charAt(q) != '\"'; ++q) {
                    }
                    response.name = argStr.substring(p, q);
                } else {
                    for (q = p + 1; q < size && argStr.charAt(q) != ' '; ++q) {
                    }
                    response.name = argStr.substring(p, q);
                }
                response.name = StringParser.removeEscapedChars(response.name);
                response.delim = StringParser.removeEscapedChars(response.delim);
                if (refName.equals(response.name + response.delim) || refName.equals(response.name)) continue;
                retVec.addElement(response);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return retVec;
    }

    public boolean executeNoop() throws IOException, MailException {
        String[] replyText;
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapProtocol.executeNoop()".getBytes(), (int)5);
        }
        if ((replyText = this.execute("NOOP", null)) == null || replyText.length < 1) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"Unable to read NOOP response".getBytes(), (int)3);
            return false;
        }
        for (int i = 0; i < replyText.length; ++i) {
            if (!replyText[i].startsWith("*") || !replyText[i].toLowerCase().endsWith("recent")) continue;
            return true;
        }
        return false;
    }

    public void executeIdle() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapProtocol.executeIdle()".getBytes(), (int)5);
        }
        this.idleCommandTag = this.executeNoReply("IDLE", null);
    }

    public void executeIdleDone() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"ImapProtocol.executeIdleDone()".getBytes(), (int)5);
        }
        this.executeUntagged("DONE", null, this.idleCommandTag);
        this.idleCommandTag = null;
    }

    public boolean executeIdlePoll() throws IOException, MailException {
        String result = this.receive();
        return result != null && result.startsWith("*") && result.toLowerCase().endsWith("recent");
    }

    protected String[] executeBatch(String command, String[] arguments) throws IOException, MailException {
        String[] result = new String[arguments.length];
        int count = 0;
        Hashtable<String, Integer> commandMap = new Hashtable<String, Integer>();
        StringBuffer commandBuf = new StringBuffer();
        for (int i = 0; i < arguments.length; ++i) {
            String tag = "A" + this.commandCount++;
            commandMap.put(tag, new Integer(i));
            commandBuf.append(tag);
            commandBuf.append(' ');
            commandBuf.append(command);
            commandBuf.append(arguments[i] == null ? "" : " " + arguments[i]);
            commandBuf.append("\r\n");
        }
        this.connection.sendRaw(commandBuf.toString());
        String tempResult = "";
        while (count < arguments.length) {
            String temp = this.connection.receive();
            String temp2 = temp.substring(temp.indexOf(" ") + 1);
            if (temp2.startsWith("BAD ") || temp2.startsWith("NO ")) {
                throw new MailException(temp);
            }
            int p = temp.indexOf(" ");
            if (p != -1 && commandMap.containsKey(temp.substring(0, p))) {
                result[((Integer)commandMap.get((Object)temp.substring((int)0, (int)p))).intValue()] = tempResult;
                tempResult = "";
                ++count;
                continue;
            }
            tempResult = temp;
        }
        return result;
    }

    protected String[] execute(String command, String arguments) throws IOException, MailException {
        Object[] result = new String[]{};
        String tag = "A" + this.commandCount++ + " ";
        this.connection.sendCommand(tag + command + (arguments == null ? "" : " " + arguments));
        String temp = this.connection.receive();
        while (!temp.startsWith(tag)) {
            Arrays.add((Object[])result, (Object)temp);
            temp = this.connection.receive();
        }
        if ((temp = temp.substring(tag.length())).startsWith("BAD ") || temp.startsWith("NO ")) {
            throw new MailException(temp);
        }
        return result;
    }

    protected String[] executeContinue(String command, String arguments, String text, String errorMsg) throws IOException, MailException {
        Object[] result = new String[]{};
        String tag = "A" + this.commandCount++ + " ";
        this.connection.sendCommand(tag + command + (arguments == null ? "" : " " + arguments));
        String temp = this.connection.receive();
        if (!temp.startsWith("+")) {
            throw new MailException(errorMsg);
        }
        this.connection.sendRaw(text);
        this.connection.sendRaw("\r\n");
        temp = this.connection.receive();
        while (!temp.startsWith(tag)) {
            Arrays.add((Object[])result, (Object)temp);
            temp = this.connection.receive();
        }
        if ((temp = temp.substring(tag.length())).startsWith("BAD ") || temp.startsWith("NO ")) {
            throw new MailException(temp);
        }
        return result;
    }

    protected String receive() throws IOException, MailException {
        String result = this.connection.available() > 0 ? this.connection.receive() : null;
        return result;
    }

    protected String executeNoReply(String command, String arguments) throws IOException, MailException {
        String tag = "A" + this.commandCount++ + " ";
        this.connection.sendCommand(tag + command + (arguments == null ? "" : " " + arguments));
        return tag;
    }

    protected String[] executeUntagged(String command, String arguments, String endTag) throws IOException, MailException {
        Object[] result = new String[]{};
        this.connection.sendCommand(command + (arguments == null ? "" : " " + arguments));
        String temp = this.connection.receive();
        while (!temp.startsWith(endTag)) {
            Arrays.add((Object[])result, (Object)temp);
            temp = this.connection.receive();
        }
        if ((temp = temp.substring(endTag.length())).startsWith("BAD ") || temp.startsWith("NO ")) {
            throw new MailException(temp);
        }
        return result;
    }

    public static class ListResponse {
        public boolean hasChildren;
        public boolean noInferiors;
        public boolean canSelect;
        public boolean marked;
        public String delim;
        public String name;
    }

    public static class FetchEnvelopeResponse {
        public int index;
        public int uid;
        public MessageFlags flags;
        public MessageEnvelope envelope;
    }

    public static class StatusResponse {
        public int exists;
        public int unseen;
    }

    public static class SelectResponse {
        public int exists;
        public int recent;
        public int unseen;
        public int uidNext;
        public int uidValidity;
    }

    public static class NamespaceResponse {
        public Namespace[] personal;
        public Namespace[] other;
        public Namespace[] shared;
    }

    public static class Namespace {
        public String prefix;
        public String delimiter;
    }

    public static class MessageFlags {
        public boolean seen;
        public boolean answered;
        public boolean flagged;
        public boolean deleted;
        public boolean draft;
        public boolean recent;
        public boolean junk;
    }
}

