/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.pop;

import java.io.IOException;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.util.Connection;

public class PopProtocol {
    private Connection connection;

    public PopProtocol(Connection connection) {
        this.connection = connection;
    }

    public void executeUser(String username) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("PopProtocol.executeUser(\"" + username + "\")").getBytes(), (int)5);
        }
        this.execute("USER " + username);
    }

    public void executePass(String password) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("PopProtocol.executePass(\"" + password + "\")").getBytes(), (int)5);
        }
        this.execute("PASS " + password);
    }

    public void executeQuit() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"PopProtocol.executeQuit()".getBytes(), (int)5);
        }
        this.execute("QUIT");
    }

    public int executeStat() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"PopProtocol.executeStat()".getBytes(), (int)5);
        }
        String result = this.execute("STAT");
        int p = result.indexOf(32);
        int q = result.indexOf(32, p + 1);
        try {
            return Integer.parseInt(result.substring(p + 1, q));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String[] executeTop(int index, int lines) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("PopProtocol.executeTop(" + index + ", " + lines + ")").getBytes(), (int)5);
        }
        return this.executeFollow("TOP " + index + " " + lines);
    }

    public String executeUidl(int index) throws IOException, MailException {
        String result;
        int p;
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("PopProtocol.executeUidl(" + index + ")").getBytes(), (int)5);
        }
        if ((p = (result = this.execute("UIDL " + index)).lastIndexOf(32)) < result.length() - 2) {
            return result.substring(p + 1);
        }
        return null;
    }

    public void executeDele(int index) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("PopProtocol.executeDele(" + index + ")").getBytes(), (int)5);
        }
        this.execute("DELE " + index);
    }

    public void executeNoop() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"PopProtocol.executeNoop()".getBytes(), (int)5);
        }
        this.execute("NOOP");
    }

    private String[] executeFollow(String command) throws IOException, MailException {
        this.execute(command);
        String buffer = this.connection.receive();
        Object[] lines = new String[]{};
        while (buffer != null && !buffer.equals(".")) {
            Arrays.add((Object[])lines, (Object)buffer);
            buffer = this.connection.receive();
        }
        return lines;
    }

    private String execute(String command) throws IOException, MailException {
        String result;
        if (command != null) {
            this.connection.sendCommand(command);
        }
        if ((result = this.connection.receive()).length() > 1 && result.charAt(0) == '-') {
            throw new MailException(result);
        }
        return result;
    }
}

