/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.smtp;

import java.io.IOException;
import java.util.Vector;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.MD5;
import org.logicprobe.LogicMail.util.StringParser;
import org.logicprobe.LogicMail.util.UtilProxy;

public class SmtpProtocol {
    private Connection connection;
    public static int AUTH_PLAIN = 1;
    public static int AUTH_LOGIN = 2;
    public static int AUTH_CRAM_MD5 = 3;
    public static int AUTH_DIGEST_MD5 = 4;
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SmtpProtocol(Connection connection) {
        this.connection = connection;
    }

    public boolean executeAuth(int mech, String username, String password) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("SmtpProtocol.executeAuth(" + mech + ", \"" + username + "\", \"" + password + "\")").getBytes(), (int)5);
        }
        UtilProxy utilProxy = UtilProxy.getInstance();
        if (mech == AUTH_PLAIN) {
            int j;
            String result = this.execute("AUTH PLAIN");
            if (!result.startsWith("334")) {
                throw new MailException(result.substring(4));
            }
            byte[] userData = username.getBytes();
            byte[] passData = password.getBytes();
            byte[] data = new byte[userData.length + passData.length + 2];
            int i = 0;
            data[i++] = 0;
            for (j = 0; j < userData.length; ++j) {
                data[i++] = userData[j];
            }
            data[i++] = 0;
            for (j = 0; j < passData.length; ++j) {
                data[i++] = passData[j];
            }
            result = this.execute(utilProxy.Base64EncodeAsString(data, 0, data.length, false, false));
            if (!result.startsWith("235")) {
                return false;
            }
        } else if (mech == AUTH_LOGIN) {
            String result = this.execute("AUTH LOGIN");
            if (!result.startsWith("334")) {
                throw new MailException(result.substring(4));
            }
            byte[] data = username.getBytes();
            result = this.execute(utilProxy.Base64EncodeAsString(data, 0, data.length, false, false));
            if (!result.startsWith("334")) {
                throw new MailException("Authentication error");
            }
            data = password.getBytes();
            result = this.execute(utilProxy.Base64EncodeAsString(data, 0, data.length, false, false));
            if (!result.startsWith("235")) {
                return false;
            }
        } else if (mech == AUTH_CRAM_MD5) {
            String result = this.execute("AUTH CRAM-MD5");
            if (!result.startsWith("334")) {
                throw new MailException(result.substring(4));
            }
            byte[] challenge = utilProxy.Base64Decode(result.substring(4));
            byte[] s = password.getBytes("US-ASCII");
            byte[] digest = SmtpProtocol.hmac_md5(s, challenge);
            StringBuffer buf = new StringBuffer();
            buf.append(username);
            buf.append(' ');
            buf.append(SmtpProtocol.byteArrayToHexString(digest));
            byte[] eval = buf.toString().getBytes("US-ASCII");
            result = this.execute(utilProxy.Base64EncodeAsString(eval, 0, eval.length, false, false));
            if (!result.startsWith("235")) {
                return false;
            }
        } else if (mech == AUTH_DIGEST_MD5) {
            String result = this.execute("AUTH DIGEST-MD5");
            if (!result.startsWith("334")) {
                throw new MailException(result.substring(4));
            }
            String challenge = new String(utilProxy.Base64Decode(result.substring(4)));
            System.err.println("-->Challenge: " + challenge);
            String[] fields = StringParser.parseTokenString(challenge, ",");
            String realm = null;
            String nonce = null;
            String qop = null;
            String algorithm = null;
            String charset = null;
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].startsWith("realm")) {
                    realm = SmtpProtocol.parseValue(fields[i]);
                    continue;
                }
                if (fields[i].startsWith("nonce")) {
                    nonce = SmtpProtocol.parseValue(fields[i]);
                    continue;
                }
                if (fields[i].startsWith("qop")) {
                    qop = SmtpProtocol.parseValue(fields[i]);
                    continue;
                }
                if (fields[i].startsWith("algorithm")) {
                    algorithm = SmtpProtocol.parseValue(fields[i]);
                    continue;
                }
                if (!fields[i].startsWith("charset")) continue;
                charset = SmtpProtocol.parseValue(fields[i]);
            }
            System.err.println("-->  Realm: " + realm);
            System.err.println("-->  Nonce: " + nonce);
            System.err.println("-->  Qop: " + qop);
            System.err.println("-->  Algorithm: " + algorithm);
            System.err.println("-->  Charset: " + charset);
            StringBuffer buf = new StringBuffer();
            MD5 md5 = new MD5();
            buf.append(username);
            buf.append(':');
            buf.append(realm);
            buf.append(':');
            buf.append(password);
            md5.update(buf.toString().getBytes(charset));
            String A1 = SmtpProtocol.byteArrayToHexString(md5.getDigest());
            System.err.println("A1: HEX(H( { " + buf.toString() + " )) = " + A1);
            buf = new StringBuffer();
            md5.reset();
            buf.append("AUTHENTICATE:");
            buf.append("smtp/");
            buf.append(this.connection.getServerName());
            md5.update(buf.toString().getBytes(charset));
            String A2 = SmtpProtocol.byteArrayToHexString(md5.getDigest());
            System.err.println("A2: HEX(H(" + buf.toString() + ")) = " + A2);
            String cnonce = "K4esOhbue3/urOGXWiEivkF9WUeZziawEHFC9nEz4BA=";
            String nc = "00000001";
            buf = new StringBuffer();
            md5.reset();
            buf.append(A1);
            buf.append(':');
            buf.append(nonce);
            buf.append(':');
            buf.append(nc);
            buf.append(':');
            buf.append(cnonce);
            buf.append(':');
            buf.append("auth");
            buf.append(':');
            buf.append(A2);
            md5.update(buf.toString().getBytes(charset));
            String resp = SmtpProtocol.byteArrayToHexString(md5.getDigest());
            System.err.println("HEX(MD5(" + buf.toString() + ")) = " + resp);
            buf = new StringBuffer();
            buf.append("charset=" + charset + ",");
            buf.append("username=\"" + username + "\",");
            buf.append("realm=\"" + realm + "\",");
            buf.append("nonce=\"" + nonce + "\",");
            buf.append("nc=" + nc + ",");
            buf.append("cnonce=\"" + cnonce + "\",");
            buf.append("digest-uri=\"smtp/" + this.connection.getServerName() + "\",");
            buf.append("response=" + resp + ",");
            buf.append("qop=auth");
            System.err.println("-->Response: " + buf.toString());
            byte[] response = buf.toString().getBytes(charset);
            result = this.execute(utilProxy.Base64EncodeAsString(response, 0, response.length, false, false));
            if (!result.startsWith("334")) {
                return false;
            }
            System.err.println("-->Result: " + new String(utilProxy.Base64Decode(result)));
            if (!result.startsWith("235")) {
                return false;
            }
        } else {
            throw new MailException("Unknown authentication mechanism");
        }
        return true;
    }

    public Vector executeExtendedHello(String domain) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("SmtpProtocol.executeExtendedHello(\"" + domain + "\")").getBytes(), (int)5);
        }
        String[] result = this.executeFollow("EHLO " + domain);
        Vector<String> items = new Vector<String>();
        for (int i = 0; i < result.length; ++i) {
            if (result[i].length() <= 4) continue;
            items.addElement(result[i].substring(4));
        }
        return items;
    }

    public boolean executeMail(String sender) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("SmtpProtocol.executeMain(\"" + sender + "\")").getBytes(), (int)5);
        }
        String result = this.execute("MAIL FROM:<" + sender + ">");
        return result.startsWith("250");
    }

    public boolean executeRecipient(String recipient) throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("SmtpProtocol.executeRecipient(\"" + recipient + "\")").getBytes(), (int)5);
        }
        String result = this.execute("RCPT TO:<" + recipient + ">");
        return result.startsWith("250");
    }

    public boolean executeData(String message) throws IOException, MailException {
        String result;
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])("SmtpProtocol.executeData(\"" + message + "\")").getBytes(), (int)5);
        }
        if (!(result = this.execute("DATA")).startsWith("354")) {
            return false;
        }
        this.connection.send(message);
        result = this.execute("\r\n.");
        return result.startsWith("250");
    }

    public boolean executeReset() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"SmtpProtocol.executeReset()".getBytes(), (int)5);
        }
        String result = this.execute("RSET");
        return result.startsWith("250");
    }

    public boolean executeQuit() throws IOException, MailException {
        if (EventLogger.getMinimumLevel() >= 5) {
            EventLogger.logEvent((long)7765914274915215232L, (byte[])"SmtpProtocol.executeQuit()".getBytes(), (int)5);
        }
        String result = this.execute("QUIT");
        return result.startsWith("221");
    }

    private String execute(String command) throws IOException, MailException {
        if (command != null) {
            this.connection.sendCommand(command);
        }
        String result = this.connection.receive();
        return result;
    }

    private String[] executeFollow(String command) throws IOException, MailException {
        this.execute(command);
        String buffer = this.connection.receive();
        Object[] lines = new String[]{};
        while (buffer != null) {
            buffer = this.connection.receive();
            Arrays.add((Object[])lines, (Object)buffer);
            if (buffer.length() < 4 || buffer.charAt(3) != ' ') continue;
            break;
        }
        return lines;
    }

    public static final String byteArrayToHexString(byte[] hash) {
        char[] buf = new char[hash.length * 2];
        int x = 0;
        for (int i = 0; i < hash.length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }

    private static byte[] hmac_md5(byte[] key, byte[] text) {
        byte[] k_ipad = new byte[64];
        byte[] k_opad = new byte[64];
        MD5 md5 = new MD5();
        if (key.length > 64) {
            md5.update(key);
            key = md5.getDigest();
        }
        System.arraycopy(key, 0, k_ipad, 0, key.length);
        System.arraycopy(key, 0, k_opad, 0, key.length);
        int i = 0;
        while (i < 64) {
            int n = i;
            k_ipad[n] = (byte)(k_ipad[n] ^ 0x36);
            int n2 = i++;
            k_opad[n2] = (byte)(k_opad[n2] ^ 0x5C);
        }
        md5.reset();
        md5.update(k_ipad);
        md5.update(text);
        byte[] digest = md5.getDigest();
        md5.reset();
        md5.update(k_opad);
        md5.update(digest);
        digest = md5.getDigest();
        return digest;
    }

    private static String parseValue(String input) {
        int p = input.indexOf("=") + 1;
        int q = input.length() - 1;
        if (q <= p) {
            return null;
        }
        if (input.charAt(p) == '\"') {
            ++p;
        }
        if (input.charAt(q) == '\"') {
            --q;
        }
        return input.substring(p, q + 1);
    }
}

