/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartVisitor;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.util.StringParser;

public class MessageForwardConverter
implements MessagePartVisitor {
    private TextPart originalTextPart;
    private MessageEnvelope envelope;

    public MessageForwardConverter(MessageEnvelope envelope) {
        this.envelope = envelope;
    }

    public MessagePart toForwardBody() {
        StringBuffer buf = new StringBuffer();
        buf.append("----Original Message----\r\n");
        buf.append("Subject: ");
        buf.append(this.envelope.subject);
        buf.append("\r\n");
        buf.append("Date: ");
        buf.append(StringParser.createDateString(this.envelope.date));
        buf.append("\r\n");
        buf.append("From: ");
        buf.append(this.makeCsvString(this.envelope.from));
        buf.append("\r\n");
        buf.append("To: ");
        buf.append(this.makeCsvString(this.envelope.to));
        buf.append("\r\n");
        if (this.envelope.cc != null && this.envelope.cc.length > 0) {
            buf.append("Cc: ");
            buf.append(this.makeCsvString(this.envelope.cc));
            buf.append("\r\n");
        }
        buf.append("\r\n");
        if (this.originalTextPart != null) {
            buf.append(this.originalTextPart.getText());
            buf.append("\r\n");
        }
        buf.append("------------------------");
        return new TextPart("plain", buf.toString());
    }

    private String makeCsvString(String[] text) {
        StringBuffer buf = new StringBuffer();
        if (text != null) {
            for (int i = 0; i < text.length; ++i) {
                buf.append(text[i]);
                if (i >= text.length - 1) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public void visitMultiPart(MultiPart part) {
    }

    public void visitTextPart(TextPart part) {
        if (this.originalTextPart == null) {
            this.originalTextPart = part;
        }
    }

    public void visitImagePart(ImagePart part) {
    }

    public void visitUnsupportedPart(UnsupportedPart part) {
    }
}

