/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import net.rim.device.api.mime.MIMEOutputStream;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessagePartVisitor;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.util.StringParser;
import org.logicprobe.LogicMail.util.UtilProxy;

public class MessageMimeConverter
implements MessagePartVisitor {
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private MIMEOutputStream mimeOutputStream = null;
    private UtilProxy utilProxy = UtilProxy.getInstance();
    private Hashtable partMimeMap = new Hashtable();

    public String toMimeString() {
        try {
            this.mimeOutputStream.flush();
            this.mimeOutputStream.close();
        }
        catch (IOException ex) {
            System.err.println("Unable to close MIMEOutputStream");
            return "";
        }
        return this.byteArrayOutputStream.toString();
    }

    public void visitMultiPart(MultiPart part) {
        if (this.mimeOutputStream == null) {
            this.mimeOutputStream = new MIMEOutputStream((OutputStream)this.byteArrayOutputStream, true, null);
            this.mimeOutputStream.setContentType(part.getMimeType() + "/" + part.getMimeSubtype());
            this.partMimeMap.put(part, this.mimeOutputStream);
        } else {
            MIMEOutputStream parentStream = (MIMEOutputStream)this.partMimeMap.get(part.getParent());
            MIMEOutputStream currentStream = parentStream.getPartOutputStream(true, null);
            this.partMimeMap.put(part, currentStream);
        }
    }

    public void visitTextPart(TextPart part) {
        MIMEOutputStream currentStream;
        String encoding;
        boolean isQP;
        boolean isBinary;
        String charset;
        String text = part.getText();
        char maxChar = '\u0000';
        for (int i = text.length() - 1; i >= 0; --i) {
            char ch = text.charAt(i);
            if (ch <= maxChar) continue;
            maxChar = ch;
        }
        if (maxChar > '\u00ff') {
            charset = "UTF-8";
            isBinary = true;
            isQP = false;
            encoding = "base64";
        } else if (maxChar > '\u007f') {
            charset = "ISO-8859-1";
            isBinary = false;
            isQP = true;
            encoding = "quoted-printable";
        } else {
            charset = "US-ASCII";
            isBinary = false;
            isQP = false;
            encoding = "7bit";
        }
        if (this.mimeOutputStream == null) {
            currentStream = this.mimeOutputStream = new MIMEOutputStream((OutputStream)this.byteArrayOutputStream, false, encoding);
        } else {
            MIMEOutputStream parentStream = (MIMEOutputStream)this.partMimeMap.get(part.getParent());
            currentStream = parentStream.getPartOutputStream(false, encoding);
        }
        this.partMimeMap.put(part, currentStream);
        currentStream.setContentType(part.getMimeType() + "/" + part.getMimeSubtype());
        currentStream.addContentTypeParameter("charset", charset.toLowerCase());
        try {
            if (!isBinary) {
                if (isQP) {
                    currentStream.write(StringParser.encodeQuotedPrintable(text).getBytes(charset));
                } else {
                    currentStream.write(text.getBytes(charset));
                }
            } else {
                byte[] data = text.getBytes(charset);
                currentStream.write(this.utilProxy.Base64Encode(data, 0, data.length, true, true));
            }
        }
        catch (IOException e) {
            System.err.println("Error encoding content");
        }
    }

    public void visitImagePart(ImagePart part) {
        MIMEOutputStream currentStream;
        if (this.mimeOutputStream == null) {
            currentStream = this.mimeOutputStream = new MIMEOutputStream((OutputStream)this.byteArrayOutputStream, false, "base64");
        } else {
            MIMEOutputStream parentStream = (MIMEOutputStream)this.partMimeMap.get(part.getParent());
            currentStream = parentStream.getPartOutputStream(false, "base64");
        }
        this.partMimeMap.put(part, currentStream);
        currentStream.setContentType(part.getMimeType() + "/" + part.getMimeSubtype());
        try {
            byte[] data = part.getImage().getData();
            currentStream.write(this.utilProxy.Base64Encode(data, 0, data.length, true, true));
        }
        catch (IOException e) {
            System.err.println("Error encoding content");
        }
    }

    public void visitUnsupportedPart(UnsupportedPart part) {
        MIMEOutputStream currentStream;
        if (this.mimeOutputStream == null) {
            currentStream = this.mimeOutputStream = new MIMEOutputStream((OutputStream)this.byteArrayOutputStream, false, "7bit");
        } else {
            MIMEOutputStream parentStream = (MIMEOutputStream)this.partMimeMap.get(part.getParent());
            currentStream = parentStream.getPartOutputStream(false, "7bit");
        }
        this.partMimeMap.put(part, currentStream);
        currentStream.setContentType("text/plain");
        try {
            currentStream.write("Unable to encode part".getBytes());
        }
        catch (IOException e) {
            System.err.println("Error encoding content");
        }
    }
}

