/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartVisitor;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.util.StringParser;

public class MessageReplyConverter
implements MessagePartVisitor {
    private TextPart originalTextPart;
    private MessageEnvelope envelope;

    public MessageReplyConverter(MessageEnvelope envelope) {
        this.envelope = envelope;
    }

    public MessagePart toReplyBody() {
        StringBuffer buf = new StringBuffer();
        buf.append("On ");
        buf.append(StringParser.createDateString(this.envelope.date));
        buf.append(", ");
        if (this.envelope.sender != null && this.envelope.sender.length > 0) {
            int p = this.envelope.sender[0].indexOf(60);
            if (p > 0) {
                buf.append(this.envelope.sender[0].substring(0, p - 1));
            } else {
                buf.append(this.envelope.sender[0]);
            }
        }
        buf.append(" wrote:\r\n");
        buf.append("> ");
        if (this.originalTextPart != null) {
            String originalText = this.originalTextPart.getText();
            int size = originalText.length();
            for (int i = 0; i < size; ++i) {
                char ch = originalText.charAt(i);
                buf.append(ch);
                if (ch != '\n' || i >= size - 1) continue;
                buf.append("> ");
            }
        }
        return new TextPart("plain", buf.toString());
    }

    public void visitMultiPart(MultiPart part) {
    }

    public void visitTextPart(TextPart part) {
        if (this.originalTextPart == null) {
            this.originalTextPart = part;
        }
    }

    public void visitImagePart(ImagePart part) {
    }

    public void visitUnsupportedPart(UnsupportedPart part) {
    }
}

