/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartVisitor;

public class MultiPart
extends MessagePart {
    private MessagePart[] parts;
    private boolean partMixed = false;
    private boolean partAlternative = false;
    private boolean partRelated = false;
    private boolean partSigned = false;

    public MultiPart(String mimeSubtype) {
        super("multipart", mimeSubtype);
        if (mimeSubtype.equalsIgnoreCase("alternative")) {
            this.partAlternative = true;
        } else if (mimeSubtype.equalsIgnoreCase("related")) {
            this.partRelated = true;
        } else if (mimeSubtype.equalsIgnoreCase("signed")) {
            this.partSigned = true;
        } else {
            this.partMixed = true;
        }
    }

    public void accept(MessagePartVisitor visitor) {
        visitor.visitMultiPart(this);
        if (this.parts != null) {
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].accept(visitor);
            }
        }
    }

    public void addPart(MessagePart part) {
        if (this.parts == null) {
            this.parts = new MessagePart[1];
            this.parts[0] = part;
        } else {
            Arrays.add((Object[])this.parts, (Object)part);
        }
        part.setParent(this);
    }

    public MessagePart[] getParts() {
        return this.parts;
    }

    public boolean isPartMixed() {
        return this.partMixed;
    }

    public boolean isPartAlternative() {
        return this.partAlternative;
    }

    public boolean isPartRelated() {
        return this.partRelated;
    }

    public boolean isPartSigned() {
        return this.partSigned;
    }
}

