/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.model;

import org.logicprobe.LogicMail.mail.AbstractMailStore;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNodeEvent;
import org.logicprobe.LogicMail.model.MessageNodeListener;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.model.NodeVisitor;
import org.logicprobe.LogicMail.util.EventListener;
import org.logicprobe.LogicMail.util.EventListenerList;

public class MessageNode
implements Node {
    private MailboxNode parent;
    private FolderMessage folderMessage;
    private Message message;
    private String messageSource;
    private EventListenerList listenerList = new EventListenerList();
    private boolean refreshInProgress;
    static /* synthetic */ Class class$org$logicprobe$LogicMail$model$MessageNodeListener;

    MessageNode(FolderMessage folderMessage) {
        this.folderMessage = folderMessage;
    }

    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    void setParent(MailboxNode parent) {
        this.parent = parent;
    }

    public MailboxNode getParent() {
        return this.parent;
    }

    public FolderMessage getFolderMessage() {
        return this.folderMessage;
    }

    void setMessage(Message message) {
        this.message = message;
        if (this.message != null) {
            this.refreshInProgress = false;
            this.folderMessage.setRecent(false);
            this.fireMessageStatusChanged(0);
        }
    }

    public Message getMessage() {
        if (this.message != null) {
            this.folderMessage.setSeen(true);
        }
        return this.message;
    }

    void setMessageSource(String messageSource) {
        this.messageSource = messageSource;
    }

    public String getMessageSource() {
        return this.messageSource;
    }

    public String toString() {
        return this.folderMessage.getEnvelope().subject;
    }

    public int getId() {
        return this.folderMessage.getIndex();
    }

    public void refreshMessage() {
        if (!this.refreshInProgress) {
            this.refreshInProgress = true;
            this.parent.getParentAccount().getMailStore().requestMessage(this.parent.getFolderTreeItem(), this.folderMessage);
        }
    }

    public void deleteMessage() {
        this.parent.getParentAccount().getMailStore().requestMessageDelete(this.parent.getFolderTreeItem(), this.folderMessage);
    }

    public void undeleteMessage() {
        AbstractMailStore mailStore = this.parent.getParentAccount().getMailStore();
        if (mailStore.hasUndelete()) {
            mailStore.requestMessageUndelete(this.parent.getFolderTreeItem(), this.folderMessage);
        }
    }

    public void addMessageNodeListener(MessageNodeListener l) {
        this.listenerList.add(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener, l);
    }

    public void removeMessageNodeListener(MessageNodeListener l) {
        this.listenerList.remove(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener, l);
    }

    public MessageNodeListener[] getMessageNodeListeners() {
        return (MessageNodeListener[])this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener);
    }

    protected void fireMessageStatusChanged(int type) {
        EventListener[] listeners = this.listenerList.getListeners(class$org$logicprobe$LogicMail$model$MessageNodeListener == null ? (class$org$logicprobe$LogicMail$model$MessageNodeListener = MessageNode.class$("org.logicprobe.LogicMail.model.MessageNodeListener")) : class$org$logicprobe$LogicMail$model$MessageNodeListener);
        MessageNodeEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new MessageNodeEvent(this, type);
            }
            ((MessageNodeListener)listeners[i]).messageStatusChanged(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

