/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Calendar;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.AutoTextEditField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.util.Arrays;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.IdentityConfig;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartFactory;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.MessageNodeEvent;
import org.logicprobe.LogicMail.model.MessageNodeListener;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.BorderedFieldManager;
import org.logicprobe.LogicMail.ui.EmailAddressBookEditField;
import org.logicprobe.LogicMail.util.EventObjectRunnable;

public class CompositionScreen
extends BaseScreen {
    public static final int COMPOSE_NORMAL = 0;
    public static final int COMPOSE_REPLY = 1;
    public static final int COMPOSE_REPLY_ALL = 2;
    public static final int COMPOSE_FORWARD = 3;
    private AccountNode accountNode;
    private AccountConfig accountConfig;
    private BorderedFieldManager recipientsFieldManager;
    private BorderedFieldManager subjectFieldManager;
    private VerticalFieldManager messageFieldManager;
    private AutoTextEditField subjectEditField;
    private AutoTextEditField messageEditField;
    private String inReplyTo;
    private boolean messageSent;
    private IdentityConfig identityConfig;
    private MessageNode replyToMessageNode;
    private MenuItem sendMenuItem = new MenuItem(BaseScreen.resources.getString(101), 200000, 10){

        public void run() {
            CompositionScreen.this.sendMessage();
        }
    };
    private MenuItem addToMenuItem = new MenuItem(BaseScreen.resources.getString(102), 200110, 10){

        public void run() {
            CompositionScreen.this.insertRecipientField(1);
        }
    };
    private MenuItem addCcMenuItem = new MenuItem(BaseScreen.resources.getString(103), 200120, 10){

        public void run() {
            CompositionScreen.this.insertRecipientField(2);
        }
    };
    private MenuItem addBccMenuItem = new MenuItem(BaseScreen.resources.getString(104), 200130, 10){

        public void run() {
            CompositionScreen.this.insertRecipientField(3);
        }
    };
    private MessageNodeListener messageNodeListener = new MessageNodeListener(){

        public void messageStatusChanged(MessageNodeEvent e) {
            CompositionScreen.this.messageNodeListener_MessageStatusChanged(e);
        }
    };

    public CompositionScreen(AccountNode accountNode) {
        this.accountNode = accountNode;
        this.accountConfig = accountNode.getAccountConfig();
        this.identityConfig = this.accountConfig.getIdentityConfig();
        this.initFields();
        this.appendSignature();
        this.messageEditField.setEditable(true);
    }

    public CompositionScreen(AccountNode accountNode, MessageNode messageNode, int composeType) {
        this.accountNode = accountNode;
        this.accountConfig = accountNode.getAccountConfig();
        this.identityConfig = this.accountConfig.getIdentityConfig();
        this.initFields();
        if (composeType == 0) {
            if (messageNode.getMessage() != null) {
                this.populateFromMessage(messageNode.getMessage());
                this.messageEditField.setEditable(true);
            } else {
                messageNode.addMessageNodeListener(this.messageNodeListener);
                messageNode.refreshMessage();
            }
        } else {
            this.replyToMessageNode = messageNode;
            Message message = this.replyToMessageNode.getMessage();
            switch (composeType) {
                case 1: {
                    message = message.toReplyMessage();
                    break;
                }
                case 2: {
                    message = message.toReplyAllMessage(this.identityConfig.getEmailAddress());
                    break;
                }
                case 3: {
                    message = message.toForwardMessage();
                }
            }
            this.populateFromMessage(message);
            this.appendSignature();
            this.messageEditField.setEditable(true);
        }
    }

    private void messageNodeListener_MessageStatusChanged(MessageNodeEvent e) {
        if (e.getType() == 0) {
            UiApplication.getUiApplication().invokeLater((Runnable)new EventObjectRunnable(e){

                public void run() {
                    MessageNode messageNode = (MessageNode)this.getEvent().getSource();
                    messageNode.removeMessageNodeListener(CompositionScreen.this.messageNodeListener);
                    CompositionScreen.this.populateFromMessage(messageNode.getMessage());
                    CompositionScreen.this.messageEditField.setEditable(true);
                }
            });
        }
    }

    private void populateFromMessage(Message message) {
        int i;
        MessagePart body = message.getBody();
        MessageEnvelope env = message.getEnvelope();
        if (body instanceof TextPart) {
            this.messageEditField.insert("\r\n");
            this.messageEditField.insert(((TextPart)body).getText());
            this.messageEditField.setCursorPosition(0);
        }
        this.subjectEditField.setText(env.subject);
        if (env.to != null) {
            for (i = 0; i < env.to.length; ++i) {
                if (env.to[i].indexOf(64) == -1) continue;
                this.insertRecipientField(1).setText(env.to[i]);
            }
        }
        if (env.cc != null) {
            for (i = 0; i < env.cc.length; ++i) {
                if (env.cc[i].indexOf(64) == -1) continue;
                this.insertRecipientField(2).setText(env.cc[i]);
            }
        }
        if (env.bcc != null) {
            for (i = 0; i < env.bcc.length; ++i) {
                if (env.bcc[i].indexOf(64) == -1) continue;
                this.insertRecipientField(3).setText(env.bcc[i]);
            }
        }
        this.inReplyTo = env.inReplyTo;
    }

    private void appendSignature() {
        String sig;
        if (this.identityConfig != null && (sig = this.identityConfig.getMsgSignature()) != null && sig.length() > 0) {
            this.messageEditField.insert("\r\n--\r\n" + sig);
            this.messageEditField.setCursorPosition(0);
        }
    }

    private void initFields() {
        this.recipientsFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_NONE);
        this.recipientsFieldManager.add((Field)new EmailAddressBookEditField(1, ""));
        this.recipientsFieldManager.add((Field)new EmailAddressBookEditField(2, ""));
        this.subjectFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_LINE);
        this.subjectEditField = new AutoTextEditField("Subject: ", "");
        this.subjectFieldManager.add((Field)this.subjectEditField);
        this.messageFieldManager = new VerticalFieldManager();
        this.messageEditField = new AutoTextEditField();
        this.messageEditField.setEditable(false);
        this.messageFieldManager.add((Field)this.messageEditField);
        this.add((Field)this.recipientsFieldManager);
        this.add((Field)this.subjectFieldManager);
        this.add((Field)this.messageFieldManager);
    }

    public boolean onClose() {
        if (!(this.messageSent || this.subjectEditField.getText().length() <= 0 && this.messageEditField.getText().length() <= 0)) {
            boolean shouldClose = false;
            MailboxNode draftMailbox = this.accountConfig.getDraftMailbox();
            if (draftMailbox != null) {
                int choice = Dialog.ask((String)BaseScreen.resources.getString(106), (Object[])new Object[]{BaseScreen.resources.getString(105), BaseScreen.resources.getString(37), BaseScreen.resources.getString(38)}, (int)0);
                if (choice == 0) {
                    Message message = this.generateMessage();
                    message.getEnvelope().date = Calendar.getInstance().getTime();
                    MessageFlags messageFlags = new MessageFlags(false, false, false, false, true, true, false);
                    draftMailbox.appendMessage(message, messageFlags);
                    shouldClose = true;
                } else if (choice == 1) {
                    shouldClose = true;
                }
            } else {
                int choice = Dialog.ask((String)BaseScreen.resources.getString(107), (Object[])new Object[]{BaseScreen.resources.getString(37), BaseScreen.resources.getString(38)}, (int)0);
                if (choice == 0) {
                    shouldClose = true;
                }
            }
            if (shouldClose) {
                this.close();
                return true;
            }
            return false;
        }
        this.close();
        return true;
    }

    protected void makeMenu(Menu menu, int instance) {
        if (((EmailAddressBookEditField)this.recipientsFieldManager.getField(0)).getText().length() > 0) {
            menu.add(this.sendMenuItem);
            menu.addSeparator();
        }
        menu.add(this.addToMenuItem);
        menu.add(this.addCcMenuItem);
        menu.add(this.addBccMenuItem);
        menu.addSeparator();
    }

    private Message generateMessage() {
        MessageEnvelope env = new MessageEnvelope();
        env.inReplyTo = this.inReplyTo;
        int size = this.recipientsFieldManager.getFieldCount();
        for (int i = 0; i < size; ++i) {
            EmailAddressBookEditField currentField = (EmailAddressBookEditField)this.recipientsFieldManager.getField(i);
            if (currentField.getAddressType() == 1 && currentField.getText().length() > 0) {
                if (env.to == null) {
                    env.to = new String[1];
                    env.to[0] = currentField.getText();
                    continue;
                }
                Arrays.add((Object[])env.to, (Object)currentField.getText());
                continue;
            }
            if (currentField.getAddressType() == 2 && currentField.getText().length() > 0) {
                if (env.cc == null) {
                    env.cc = new String[1];
                    env.cc[0] = currentField.getText();
                    continue;
                }
                Arrays.add((Object[])env.cc, (Object)currentField.getText());
                continue;
            }
            if (currentField.getAddressType() != 3 || currentField.getText().length() <= 0) continue;
            if (env.bcc == null) {
                env.bcc = new String[1];
                env.bcc[0] = currentField.getText();
                continue;
            }
            Arrays.add((Object[])env.bcc, (Object)currentField.getText());
        }
        if (this.identityConfig != null) {
            env.from = new String[1];
            String fullName = this.identityConfig.getFullName();
            env.from[0] = fullName != null && fullName.length() > 0 ? "\"" + fullName + "\"" + " <" + this.identityConfig.getEmailAddress() + ">" : this.identityConfig.getEmailAddress();
            String replyToAddress = this.identityConfig.getReplyToAddress();
            if (replyToAddress != null && replyToAddress.length() > 0) {
                env.replyTo = new String[1];
                env.replyTo[0] = replyToAddress;
            }
        } else {
            env.from = new String[1];
            env.from[0] = this.accountConfig.getServerUser() + "@" + this.accountConfig.getServerName();
        }
        env.subject = this.subjectEditField.getText();
        MessagePart bodyPart = MessagePartFactory.createMessagePart("text", "plain", "7bit", "us-ascii", this.messageEditField.getText());
        Message message = new Message(env, bodyPart);
        return message;
    }

    private void sendMessage() {
        Message message = this.generateMessage();
        if (this.replyToMessageNode != null) {
            this.accountNode.sendMessageReply(message, this.replyToMessageNode);
        } else {
            this.accountNode.sendMessage(message);
        }
        this.messageSent = true;
        this.setDirty(false);
        this.close();
    }

    private EmailAddressBookEditField insertRecipientField(int addressType) {
        EmailAddressBookEditField currentField;
        int i;
        int size = this.recipientsFieldManager.getFieldCount();
        for (i = 0; i < size; ++i) {
            currentField = (EmailAddressBookEditField)this.recipientsFieldManager.getField(i);
            if (currentField.getAddressType() != addressType || currentField.getText().length() != 0) continue;
            currentField.setFocus();
            return currentField;
        }
        if (addressType == 1) {
            for (i = 0; i < size; ++i) {
                currentField = (EmailAddressBookEditField)this.recipientsFieldManager.getField(i);
                if (currentField.getAddressType() == 1) continue;
                currentField = new EmailAddressBookEditField(1, "");
                this.recipientsFieldManager.insert((Field)currentField, i);
                currentField.setFocus();
                return currentField;
            }
        } else if (addressType == 2) {
            for (i = 0; i < size; ++i) {
                currentField = (EmailAddressBookEditField)this.recipientsFieldManager.getField(i);
                if (currentField.getAddressType() == 1 || currentField.getAddressType() == 2) {
                    continue;
                }
                currentField = new EmailAddressBookEditField(2, "");
                this.recipientsFieldManager.insert((Field)currentField, i);
                currentField.setFocus();
                return currentField;
            }
        }
        currentField = new EmailAddressBookEditField(addressType, "");
        this.recipientsFieldManager.add((Field)currentField);
        currentField.setFocus();
        return currentField;
    }

    public boolean keyChar(char key, int status, int time) {
        switch (key) {
            case '\b': {
                EmailAddressBookEditField currentField = (EmailAddressBookEditField)this.recipientsFieldManager.getFieldWithFocus();
                if (currentField == null || this.recipientsFieldManager.getFieldWithFocusIndex() == 0 || currentField.getText().length() > 0) break;
                int index = currentField.getIndex();
                this.recipientsFieldManager.delete((Field)currentField);
                this.recipientsFieldManager.getField(index - 1).setFocus();
                return true;
            }
        }
        return super.keyChar(key, status, time);
    }
}

