/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Enumeration;
import javax.microedition.pim.Contact;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import net.rim.blackberry.api.pdap.BlackBerryContactList;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.EmailAddressEditField;
import net.rim.device.api.ui.component.LabelField;
import org.logicprobe.LogicMail.util.StringParser;

public class EmailAddressPropertiesDialog
extends Dialog {
    protected static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private BasicEditField nameEditField;
    private EmailAddressEditField addressEditField;
    private ButtonField okButton;
    private String name;
    private String address;

    public EmailAddressPropertiesDialog(String name, String address) {
        super("Address Properties", null, null, 0, Bitmap.getPredefinedBitmap((int)1), 0x40000300000000L);
        this.name = name;
        this.address = address;
        this.initFields();
        this.checkAddressBook();
    }

    public EmailAddressPropertiesDialog(String recipient) {
        super("Address Properties", null, null, 0, Bitmap.getPredefinedBitmap((int)1), 0x40000300000000L);
        String[] recipientElements = StringParser.parseRecipient(recipient);
        this.name = recipientElements[0];
        this.address = recipientElements[1];
        this.initFields();
    }

    private void initFields() {
        this.nameEditField = new BasicEditField("Name: ", this.name);
        this.addressEditField = new EmailAddressEditField("Address: ", this.address);
        this.okButton = new ButtonField(resources.getString(83), 0x40000300000000L);
        this.okButton.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                EmailAddressPropertiesDialog.this.select(0);
                EmailAddressPropertiesDialog.this.close();
            }
        });
        this.add((Field)this.nameEditField);
        this.add((Field)this.addressEditField);
        this.add((Field)new LabelField((Object)"", 0x80000000000000L));
        this.add((Field)this.okButton);
    }

    private void checkAddressBook() {
        Contact contact = null;
        try {
            BlackBerryContactList list = (BlackBerryContactList)PIM.getInstance().openPIMList(1, 3);
            Enumeration e = list.items(this.address, 1);
            if (e.hasMoreElements()) {
                contact = (Contact)e.nextElement();
            }
        }
        catch (PIMException pIMException) {
            // empty catch block
        }
        if (contact != null) {
            this.add((Field)new LabelField((Object)"In Address Book"));
        } else {
            this.add((Field)new LabelField((Object)"Not found"));
        }
    }

    public void setEditable(boolean editable) {
        this.nameEditField.setEditable(editable);
        this.addressEditField.setEditable(editable);
    }

    public String getName() {
        return this.nameEditField.getText();
    }

    public String getAddress() {
        return this.addressEditField.getText();
    }

    public String getRecipient() {
        return StringParser.mergeRecipient(this.nameEditField.getText(), this.addressEditField.getText());
    }
}

