/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.system.Application;
import net.rim.device.api.system.DeviceInfo;
import net.rim.device.api.system.Display;
import net.rim.device.api.system.RadioInfo;
import net.rim.device.api.system.RadioListener;
import net.rim.device.api.system.RadioStatusListener;
import net.rim.device.api.system.SystemListener;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;

public class HeaderField
extends Field {
    private Font headerFont;
    private String title;
    private boolean showSignal;
    private boolean showBattery;
    private boolean showTitle;
    private int fieldWidth;
    private int fieldHeight;
    private int fontColor;
    private int backgroundColor;
    private int batteryBackground;
    private int signalBarColor;
    private SystemListener systemListener;
    private RadioStatusListener radioStatusListener;
    private boolean listenersActive;
    private int signalLevel;
    private int batteryLevel;

    public HeaderField(String title) {
        super(0x80000000000000L);
        this.title = title;
        this.showSignal = true;
        this.showBattery = true;
        this.showTitle = true;
        this.fontColor = -1;
        this.headerFont = Font.getDefault().derive(1);
        this.backgroundColor = 0;
        this.batteryBackground = 0x999999;
        this.signalBarColor = 255;
        this.fieldHeight = this.headerFont.getHeight();
        this.fieldWidth = Display.getWidth();
        this.signalLevel = RadioInfo.getSignalLevel();
        this.batteryLevel = DeviceInfo.getBatteryLevel();
        this.listenersActive = false;
        this.systemListener = new SystemListener(){

            public void powerOff() {
            }

            public void powerUp() {
            }

            public void batteryLow() {
                HeaderField.this.onBatteryStatusChanged();
            }

            public void batteryGood() {
                HeaderField.this.onBatteryStatusChanged();
            }

            public void batteryStatusChange(int status) {
                HeaderField.this.onBatteryStatusChanged();
            }
        };
        this.radioStatusListener = new RadioStatusListener(){

            public void signalLevel(int level) {
                HeaderField.this.onRadioStatusChanged();
            }

            public void networkStarted(int networkId, int service) {
                HeaderField.this.onRadioStatusChanged();
            }

            public void baseStationChange() {
                HeaderField.this.onRadioStatusChanged();
            }

            public void radioTurnedOff() {
                HeaderField.this.onRadioStatusChanged();
            }

            public void pdpStateChange(int apn, int state, int cause) {
                HeaderField.this.onRadioStatusChanged();
            }

            public void networkStateChange(int state) {
                HeaderField.this.onRadioStatusChanged();
            }

            public void networkScanComplete(boolean success) {
                HeaderField.this.onRadioStatusChanged();
            }

            public void mobilityManagementEvent(int eventCode, int cause) {
                HeaderField.this.onRadioStatusChanged();
            }

            public void networkServiceChange(int networkId, int service) {
                HeaderField.this.onRadioStatusChanged();
            }
        };
    }

    protected void onBatteryStatusChanged() {
        this.batteryLevel = DeviceInfo.getBatteryLevel();
        this.invalidate();
    }

    protected void onRadioStatusChanged() {
        this.signalLevel = RadioInfo.getSignalLevel();
        this.invalidate();
    }

    protected void onDisplay() {
        if (!this.listenersActive) {
            Application.getApplication().addSystemListener(this.systemListener);
            Application.getApplication().addRadioListener((RadioListener)this.radioStatusListener);
            this.listenersActive = true;
        }
        super.onExposed();
    }

    protected void onExposed() {
        if (!this.listenersActive) {
            Application.getApplication().addSystemListener(this.systemListener);
            Application.getApplication().addRadioListener((RadioListener)this.radioStatusListener);
            this.listenersActive = true;
        }
        super.onExposed();
    }

    protected void onObscured() {
        if (this.listenersActive) {
            Application.getApplication().removeSystemListener(this.systemListener);
            Application.getApplication().removeRadioListener((RadioListener)this.radioStatusListener);
            this.listenersActive = false;
        }
        super.onObscured();
    }

    protected void onUndisplay() {
        if (this.listenersActive) {
            Application.getApplication().removeSystemListener(this.systemListener);
            Application.getApplication().removeRadioListener((RadioListener)this.radioStatusListener);
            this.listenersActive = false;
        }
        super.onUndisplay();
    }

    public void removeListeners() {
        if (this.listenersActive) {
            Application.getApplication().removeSystemListener(this.systemListener);
            Application.getApplication().removeRadioListener((RadioListener)this.radioStatusListener);
            this.listenersActive = false;
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.invalidate();
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.invalidate();
    }

    public void setBatteryBackground(int batteryBackground) {
        this.batteryBackground = batteryBackground;
        this.invalidate();
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.invalidate();
    }

    public void showSignal(boolean bool) {
        this.showSignal = bool;
        this.invalidate();
    }

    public void showBattery(boolean bool) {
        this.showBattery = bool;
        this.invalidate();
    }

    public void showTitle(boolean bool) {
        this.showTitle = bool;
        this.invalidate();
    }

    protected void layout(int width, int height) {
        this.setExtent(this.getPreferredWidth(), this.getPreferredHeight());
    }

    public int getPreferredWidth() {
        return this.fieldWidth;
    }

    public int getPreferredHeight() {
        return this.fieldHeight;
    }

    protected void paint(Graphics graphics) {
        if (this.fontColor == -1) {
            this.fontColor = graphics.getColor();
        }
        graphics.setFont(this.headerFont);
        int graphicsDiff = 0;
        int preferredWidth = this.getPreferredWidth();
        int preferredHeight = this.getPreferredHeight();
        int midPoint = preferredHeight / 2;
        if (this.backgroundColor != 0) {
            graphics.setColor(this.backgroundColor);
            graphics.fillRect(0, 0, preferredWidth, preferredHeight);
        }
        if (this.showSignal) {
            graphics.pushRegion(preferredWidth - 37, midPoint - 7, 35, 14, 0, 0);
            this.drawSignalIndicator(graphics);
            graphics.popContext();
            graphicsDiff += 37;
        }
        if (this.showBattery) {
            graphics.pushRegion(preferredWidth - 48 - graphicsDiff, midPoint - 7, 44, 14, 0, 0);
            this.drawBatteryIndicator(graphics);
            graphics.popContext();
            graphicsDiff += 48;
        }
        graphics.setColor(this.fontColor);
        if (this.showTitle) {
            graphics.drawText(this.title, 1, 0, 64, preferredWidth - graphicsDiff);
        }
    }

    private void drawSignalIndicator(Graphics graphics) {
        graphics.setColor(0xA9A9A9);
        graphics.fillRect(7, 12, 4, 2);
        graphics.fillRect(13, 9, 4, 5);
        graphics.fillRect(19, 6, 4, 8);
        graphics.fillRect(25, 3, 4, 11);
        graphics.fillRect(31, 0, 4, 14);
        graphics.setColor(this.signalBarColor);
        graphics.drawLine(0, 0, 8, 0);
        graphics.drawLine(0, 0, 4, 4);
        graphics.drawLine(8, 0, 4, 4);
        graphics.drawLine(4, 4, 4, 13);
        if (this.signalLevel >= -120) {
            graphics.fillRect(7, 12, 4, 2);
        }
        if (this.signalLevel >= -101) {
            graphics.fillRect(13, 9, 4, 5);
        }
        if (this.signalLevel >= -92) {
            graphics.fillRect(19, 6, 4, 8);
        }
        if (this.signalLevel >= -86) {
            graphics.fillRect(25, 3, 4, 11);
        }
        if (this.signalLevel >= -77) {
            graphics.fillRect(31, 0, 4, 14);
        }
    }

    private void drawBatteryIndicator(Graphics graphics) {
        int backgroundColor = graphics.getBackgroundColor();
        graphics.setColor(this.batteryBackground);
        graphics.drawRect(1, 0, 40, 14);
        graphics.drawRect(2, 1, 38, 12);
        graphics.drawLine(0, 2, 0, 12);
        graphics.fillRect(41, 3, 3, 8);
        graphics.setColor(backgroundColor);
        graphics.fillRect(3, 2, 36, 10);
        if (this.batteryLevel > 75) {
            graphics.setColor(2683648);
        } else if (this.batteryLevel > 50) {
            graphics.setColor(9559040);
        } else if (this.batteryLevel > 25) {
            graphics.setColor(15723520);
        } else {
            graphics.setColor(0xFF2200);
        }
        graphics.fillRect(4, 3, 6, 8);
        graphics.fillRect(11, 3, 6, 8);
        graphics.fillRect(18, 3, 6, 8);
        graphics.fillRect(25, 3, 6, 8);
        graphics.fillRect(32, 3, 6, 8);
        graphics.setColor(backgroundColor);
        int power = (int)(0.34 * (double)this.batteryLevel);
        power = Math.max(power, 0);
        power = Math.min(power, 34);
        graphics.fillRect(38 - (34 - power), 3, 34 - power, 8);
    }
}

