/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.TreeField;
import net.rim.device.api.ui.component.TreeFieldCallback;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.AccountNodeEvent;
import org.logicprobe.LogicMail.model.AccountNodeListener;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailManagerEvent;
import org.logicprobe.LogicMail.model.MailManagerListener;
import org.logicprobe.LogicMail.model.MailRootNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MailboxNodeEvent;
import org.logicprobe.LogicMail.model.MailboxNodeListener;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.ui.AccountConfigWizard;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.CompositionScreen;
import org.logicprobe.LogicMail.ui.MailboxScreen;
import org.logicprobe.LogicMail.ui.NodeIcons;
import org.logicprobe.LogicMail.util.EventObjectRunnable;

public class MailHomeScreen
extends BaseScreen {
    private TreeField treeField;
    private MailManager mailManager;
    private MailRootNode mailRootNode;
    private Hashtable nodeIdMap;
    private MailManagerListener mailManagerListener;
    private boolean firstVisible = true;
    private AccountNodeListener accountNodeListener = new AccountNodeListener(){

        public void accountStatusChanged(AccountNodeEvent e) {
            UiApplication.getUiApplication().invokeLater((Runnable)new EventObjectRunnable(e){

                public void run() {
                    MailHomeScreen.this.accountNodeListener_AccountStatusChanged((AccountNodeEvent)this.getEvent());
                }
            });
        }
    };
    private MenuItem selectFolderItem = new MenuItem(BaseScreen.resources.getString(66), 100, 10){

        public void run() {
            MailHomeScreen.this.openSelectedItem();
        }
    };
    private MenuItem refreshStatusItem = new MenuItem(BaseScreen.resources.getString(68), 110, 10){

        public void run() {
            AccountNode accountNode = (AccountNode)((TreeNode)((MailHomeScreen)MailHomeScreen.this).treeField.getCookie((int)((MailHomeScreen)MailHomeScreen.this).treeField.getCurrentNode())).node;
            accountNode.refreshMailboxStatus();
        }
    };
    private MenuItem refreshItem = new MenuItem(BaseScreen.resources.getString(67), 111, 10){

        public void run() {
            AccountNode accountNode = (AccountNode)((TreeNode)((MailHomeScreen)MailHomeScreen.this).treeField.getCookie((int)((MailHomeScreen)MailHomeScreen.this).treeField.getCurrentNode())).node;
            accountNode.refreshMailboxes();
        }
    };
    private MenuItem compositionItem = new MenuItem(BaseScreen.resources.getString(73), 120, 10){

        public void run() {
            Node node;
            AccountNode accountNode;
            int id = MailHomeScreen.this.treeField.getCurrentNode();
            if (id != -1 && (accountNode = (node = ((TreeNode)((MailHomeScreen)MailHomeScreen.this).treeField.getCookie((int)id)).node) instanceof MailboxNode ? ((MailboxNode)node).getParentAccount() : (node instanceof AccountNode ? (AccountNode)node : null)) != null) {
                UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(accountNode));
            }
        }
    };
    private MenuItem disconnectItem = new MenuItem(BaseScreen.resources.getString(69), 200000, 9){

        public void run() {
            MailHomeScreen.this.disconnectSelectedAccount();
        }
    };
    private MailboxNodeListener mailboxNodeListener = new MailboxNodeListener(){

        public void mailboxStatusChanged(MailboxNodeEvent e) {
            if (MailHomeScreen.this.nodeIdMap.containsKey(e.getSource())) {
                MailHomeScreen.this.treeField.invalidateNode(((Integer)MailHomeScreen.this.nodeIdMap.get(e.getSource())).intValue());
            }
        }
    };

    public MailHomeScreen() {
        super(BaseScreen.resources.getString(64));
        this.initFields();
        this.nodeIdMap = new Hashtable();
        this.mailManager = MailManager.getInstance();
        this.mailRootNode = this.mailManager.getMailRootNode();
        this.mailManagerListener = new MailManagerListener(){

            public void mailConfigurationChanged(MailManagerEvent e) {
                MailHomeScreen.this.mailManager_MailConfigurationChanged(e);
            }
        };
    }

    private void initFields() {
        this.treeField = new TreeField(new TreeFieldCallback(){

            public void drawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
                MailHomeScreen.this.treeField_DrawTreeItem(treeField, graphics, node, y, width, indent);
            }
        }, 0x40000000000000L);
        this.treeField.setEmptyString(BaseScreen.resources.getString(65), 0);
        this.treeField.setDefaultExpanded(true);
        this.treeField.setIndentWidth(20);
        this.add((Field)this.treeField);
    }

    private void accountNodeListener_AccountStatusChanged(AccountNodeEvent e) {
        UiApplication.getUiApplication().invokeLater((Runnable)new EventObjectRunnable(e){

            public void run() {
                AccountNodeEvent e = (AccountNodeEvent)this.getEvent();
                if (MailHomeScreen.this.nodeIdMap.containsKey(e.getSource())) {
                    if (e.getType() == 0) {
                        MailHomeScreen.this.treeField.invalidateNode(((Integer)MailHomeScreen.this.nodeIdMap.get(e.getSource())).intValue());
                    } else if (e.getType() == 1) {
                        MailHomeScreen.this.refreshAccountFolders((AccountNode)e.getSource());
                    }
                }
            }
        });
    }

    protected void onDisplay() {
        this.populateTreeField();
        this.mailManager.addMailManagerListener(this.mailManagerListener);
        super.onDisplay();
    }

    protected void onUndisplay() {
        this.clearTreeField();
        this.mailManager.removeMailManagerListener(this.mailManagerListener);
        super.onUndisplay();
    }

    public boolean onClose() {
        this.tryShutdownApplication();
        return false;
    }

    protected void onVisibilityChange(boolean visible) {
        super.onVisibilityChange(visible);
        if (visible && this.firstVisible) {
            this.firstVisible = false;
            if (this.mailRootNode.getAccounts().length <= 1) {
                UiApplication.getUiApplication().invokeLater(new Runnable(){

                    public void run() {
                        AccountConfigWizard wizard = new AccountConfigWizard();
                        if (wizard.start()) {
                            AccountConfig newAccountConfig = wizard.getAccountConfig();
                            AccountNode[] accounts = MailHomeScreen.this.mailRootNode.getAccounts();
                            for (int i = 0; i < accounts.length; ++i) {
                                if (accounts[i].getAccountConfig() != newAccountConfig) continue;
                                if (!accounts[i].hasFolders()) break;
                                accounts[i].refreshMailboxes();
                                break;
                            }
                        }
                    }
                });
            }
        }
    }

    protected void makeMenu(Menu menu, int instance) {
        int id = this.treeField.getCurrentNode();
        if (id != -1) {
            Node node = ((TreeNode)this.treeField.getCookie((int)id)).node;
            if (node instanceof MailboxNode) {
                MailboxNode mailboxNode = (MailboxNode)node;
                menu.add(this.selectFolderItem);
                if (mailboxNode.getParentAccount().hasMailSender()) {
                    menu.add(this.compositionItem);
                }
            } else if (node instanceof AccountNode) {
                AccountNode accountNode = (AccountNode)node;
                if (accountNode.getRootMailbox() != null) {
                    menu.add(this.refreshStatusItem);
                }
                if (accountNode.hasFolders()) {
                    menu.add(this.refreshItem);
                }
                if (accountNode.hasMailSender()) {
                    menu.add(this.compositionItem);
                }
                if (accountNode.getStatus() == 2) {
                    menu.add(this.disconnectItem);
                }
            }
        }
        super.makeMenu(menu, instance);
    }

    protected boolean onClick() {
        return this.openSelectedItem();
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': {
                retval = this.openSelectedItem();
            }
        }
        return retval;
    }

    private void mailManager_MailConfigurationChanged(MailManagerEvent e) {
        this.clearTreeField();
        this.populateTreeField();
    }

    private synchronized void populateTreeField() {
        int firstNode = -1;
        AccountNode[] accounts = this.mailRootNode.getAccounts();
        for (int i = accounts.length - 1; i >= 0; --i) {
            int id = this.treeField.addChildNode(0, (Object)new TreeNode(accounts[i]));
            if (i == 0) {
                firstNode = id;
            }
            this.nodeIdMap.put(accounts[i], new Integer(id));
            MailboxNode rootMailbox = accounts[i].getRootMailbox();
            if (rootMailbox != null) {
                MailboxNode[] mailboxNodes = rootMailbox.getMailboxes();
                for (int j = mailboxNodes.length - 1; j >= 0; --j) {
                    this.populateTreeFieldMailbox(id, mailboxNodes[j]);
                }
            }
            accounts[i].addAccountNodeListener(this.accountNodeListener);
        }
        if (firstNode != -1) {
            this.treeField.setCurrentNode(firstNode);
        }
    }

    private void populateTreeFieldMailbox(int parent, MailboxNode mailboxNode) {
        int id = this.treeField.addChildNode(parent, (Object)new TreeNode(mailboxNode));
        this.nodeIdMap.put(mailboxNode, new Integer(id));
        MailboxNode[] mailboxes = mailboxNode.getMailboxes();
        for (int i = mailboxes.length - 1; i >= 0; --i) {
            this.populateTreeFieldMailbox(id, mailboxes[i]);
        }
        mailboxNode.addMailboxNodeListener(this.mailboxNodeListener);
    }

    private synchronized void clearTreeField() {
        Enumeration e = this.nodeIdMap.keys();
        while (e.hasMoreElements()) {
            Node node = (Node)e.nextElement();
            if (node instanceof AccountNode) {
                ((AccountNode)node).removeAccountNodeListener(this.accountNodeListener);
                continue;
            }
            if (!(node instanceof MailboxNode)) continue;
            ((MailboxNode)node).removeMailboxNodeListener(this.mailboxNodeListener);
        }
        this.treeField.deleteAll();
        this.nodeIdMap.clear();
    }

    private synchronized void refreshAccountFolders(AccountNode account) {
        if (this.nodeIdMap.containsKey(account)) {
            int accountId = (Integer)this.nodeIdMap.get(account);
            Vector mailboxes = new Vector();
            this.getMailboxNodes(mailboxes, accountId);
            int size = mailboxes.size();
            for (int i = 0; i < size; ++i) {
                MailboxNode mailboxNode = (MailboxNode)mailboxes.elementAt(i);
                if (!this.nodeIdMap.containsKey(mailboxNode)) continue;
                mailboxNode.removeMailboxNodeListener(this.mailboxNodeListener);
                this.nodeIdMap.remove(mailboxNode);
            }
            int nextId = this.treeField.getFirstChild(accountId);
            while (nextId != -1) {
                int id = nextId;
                nextId = this.treeField.getNextSibling(nextId);
                this.treeField.deleteSubtree(id);
            }
            MailboxNode rootMailbox = account.getRootMailbox();
            if (rootMailbox != null) {
                MailboxNode[] mailboxNodes = rootMailbox.getMailboxes();
                for (int i = mailboxNodes.length - 1; i >= 0; --i) {
                    this.populateTreeFieldMailbox(accountId, mailboxNodes[i]);
                }
            }
        }
    }

    private void getMailboxNodes(Vector result, int nodeId) {
        int id = this.treeField.getFirstChild(nodeId);
        while (id != -1) {
            TreeNode treeNode = (TreeNode)this.treeField.getCookie(id);
            if (treeNode.node instanceof MailboxNode) {
                result.addElement(treeNode.node);
            }
            this.getMailboxNodes(result, id);
            id = this.treeField.getNextSibling(id);
        }
    }

    private void treeField_DrawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
        TreeNode treeNode = (TreeNode)treeField.getCookie(node);
        int height = treeField.getRowHeight();
        Bitmap icon = NodeIcons.getIcon(treeNode.node);
        graphics.drawBitmap(indent, y + (height - icon.getHeight()) / 2, height - 2, height - 2, icon, 0, 0);
        Font origFont = graphics.getFont();
        StringBuffer buf = new StringBuffer();
        buf.append(treeNode.node.toString());
        if (treeNode.node instanceof AccountNode) {
            graphics.setFont(origFont.derive(1));
        } else if (treeNode.node instanceof MailboxNode) {
            int unseenCount;
            MailboxNode mailboxNode = (MailboxNode)treeNode.node;
            if (!mailboxNode.isSelectable()) {
                graphics.setFont(origFont.derive(2));
            }
            if ((unseenCount = mailboxNode.getUnseenMessageCount()) > 0) {
                buf.append(" (");
                buf.append(unseenCount);
                buf.append(")");
                graphics.setFont(origFont.derive(1));
            } else {
                graphics.setFont(origFont.derive(0));
            }
        }
        graphics.drawText(buf.toString(), indent + height, y, 64, width);
    }

    private boolean openSelectedItem() {
        Node node;
        int id = this.treeField.getCurrentNode();
        if (id != -1 && (node = ((TreeNode)this.treeField.getCookie((int)id)).node) instanceof MailboxNode) {
            MailboxNode mailboxNode = (MailboxNode)node;
            MailboxScreen mailboxScreen = new MailboxScreen(mailboxNode);
            UiApplication.getUiApplication().pushScreen((Screen)mailboxScreen);
            return true;
        }
        return false;
    }

    private void disconnectSelectedAccount() {
        Node node;
        int id = this.treeField.getCurrentNode();
        if (id != -1 && (node = ((TreeNode)this.treeField.getCookie((int)id)).node) instanceof AccountNode) {
            ((AccountNode)node).requestDisconnect(false);
        }
    }

    private static class TreeNode {
        public Node node;

        public TreeNode(Node node) {
            this.node = node;
        }
    }
}

