/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Calendar;
import net.rim.device.api.i18n.DateFormat;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.ui.NodeIcons;

public class MailboxMessageField
extends Field {
    private MailboxNode mailboxNode;
    private MessageNode messageNode;
    private int lineHeight;
    private int maxWidth;

    public MailboxMessageField(MailboxNode mailboxNode, MessageNode messageNode) {
        this.mailboxNode = mailboxNode;
        this.messageNode = messageNode;
    }

    public MailboxMessageField(MailboxNode mailboxNode, MessageNode messageNode, long style) {
        super(style);
        this.mailboxNode = mailboxNode;
        this.messageNode = messageNode;
    }

    public MessageNode getMessageNode() {
        return this.messageNode;
    }

    protected void layout(int width, int height) {
        this.maxWidth = width;
        this.lineHeight = this.getPreferredHeight() / 2;
        this.setExtent(width, this.getPreferredHeight());
    }

    public int getPreferredHeight() {
        return Font.getDefault().getHeight() * 2;
    }

    public void invalidate() {
        super.invalidate();
    }

    protected void onUnfocus() {
        super.invalidate();
        super.onUnfocus();
    }

    protected void paint(Graphics graphics) {
        MessageEnvelope envelope = this.messageNode.getFolderMessage().getEnvelope();
        String senderText = this.createSenderText();
        String dateString = this.createDisplayDate();
        boolean isFocus = this.isFocus();
        int width = this.getWidth();
        int originalColor = graphics.getColor();
        int dateWidth = Font.getDefault().getAdvance(dateString);
        int senderWidth = this.maxWidth - dateWidth - 20;
        graphics.setColor(0xA9A9A9);
        graphics.drawLine(0, this.lineHeight * 2 - 1, width, this.lineHeight * 2 - 1);
        graphics.setColor(originalColor);
        Bitmap messageIcon = NodeIcons.getIcon(this.messageNode);
        graphics.drawBitmap(1, this.lineHeight / 2 - messageIcon.getHeight() / 2, 20, this.lineHeight * 2, messageIcon, 0, 0);
        if (senderText != null) {
            graphics.drawText(senderText, 20, 0, 64, senderWidth);
        }
        if (envelope.subject != null) {
            if (!isFocus) {
                graphics.setColor(0x7B7B7B);
            }
            graphics.drawText(envelope.subject, 20, this.lineHeight, 64, this.maxWidth - 20);
            if (!isFocus) {
                graphics.setColor(originalColor);
            }
        }
        if (dateString != null) {
            graphics.drawText(dateString, senderWidth + 20, 0, 64, dateWidth);
        }
    }

    private String createSenderText() {
        MessageEnvelope envelope = this.messageNode.getFolderMessage().getEnvelope();
        String senderText = null;
        if (this.mailboxNode.getType() == 4) {
            if (envelope.to != null && envelope.to.length > 0) {
                senderText = envelope.to[0];
            }
        } else if (envelope.from != null && envelope.from.length > 0) {
            senderText = envelope.from[0];
        }
        if (senderText != null) {
            int p = senderText.indexOf(60);
            int q = senderText.indexOf(62);
            if (p != -1 && q != -1 && p < q && p > 0 && senderText.charAt(p - 1) == ' ') {
                senderText = senderText.substring(0, p - 1);
            }
        }
        return senderText;
    }

    private String createDisplayDate() {
        MessageEnvelope envelope = this.messageNode.getFolderMessage().getEnvelope();
        if (envelope.date == null) {
            return null;
        }
        Calendar nowCal = Calendar.getInstance();
        Calendar dispCal = Calendar.getInstance();
        dispCal.setTime(envelope.date);
        DateFormat dateFormat = nowCal.get(1) == dispCal.get(1) ? (nowCal.get(2) == dispCal.get(2) && nowCal.get(5) == dispCal.get(5) ? DateFormat.getInstance((int)6) : DateFormat.getInstance((int)56)) : DateFormat.getInstance((int)56);
        StringBuffer buffer = new StringBuffer();
        dateFormat.format(dispCal, buffer, null);
        return buffer.toString();
    }
}

