/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import net.rim.blackberry.api.browser.Browser;
import net.rim.blackberry.api.browser.BrowserSession;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.io.Base64OutputStream;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.BitmapField;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.util.DataBuffer;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartVisitor;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;

public class MessageRenderer
implements MessagePartVisitor {
    protected static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private Vector messageFields = new Vector();

    public void visitMultiPart(MultiPart part) {
    }

    public void visitTextPart(TextPart part) {
        if (part.getMimeSubtype().equalsIgnoreCase("html")) {
            ButtonField browserButtonField = new ButtonField("Open HTML in browser...", 0x300000000L);
            browserButtonField.setChangeListener((FieldChangeListener)new MessageFieldChangeListener(part){

                public void fieldChanged(Field field, int context) {
                    TextPart textPart = (TextPart)this.getPart();
                    try {
                        DataBuffer buffer = new DataBuffer();
                        buffer.write(textPart.getText().getBytes());
                        ByteArrayOutputStream output = new ByteArrayOutputStream();
                        Base64OutputStream boutput = new Base64OutputStream((OutputStream)output);
                        output.write("data:text/html;base64,".getBytes());
                        boutput.write(buffer.getArray());
                        boutput.flush();
                        boutput.close();
                        output.flush();
                        output.close();
                        BrowserSession browserSession = Browser.getDefaultSession();
                        browserSession.displayPage(output.toString());
                    }
                    catch (Throwable t) {
                        EventLogger.logEvent((long)7765914274915215232L, (byte[])("Error launching browser: " + t.toString()).getBytes(), (int)2);
                        Dialog.alert((String)"Unable to display the HTML message in the browser.");
                    }
                }
            });
            VerticalFieldManager browserButtonFieldManager = new VerticalFieldManager(0x1000000000000000L);
            browserButtonFieldManager.add((Field)new LabelField());
            browserButtonFieldManager.add((Field)browserButtonField);
            browserButtonFieldManager.add((Field)new LabelField());
            this.messageFields.addElement(browserButtonFieldManager);
        } else {
            this.messageFields.addElement(new RichTextField(part.getText()));
        }
    }

    public void visitImagePart(ImagePart part) {
        this.messageFields.addElement(new BitmapField(part.getImage().getBitmap()));
    }

    public void visitUnsupportedPart(UnsupportedPart part) {
        this.messageFields.addElement(new RichTextField(resources.getString(84) + ' ' + part.getMimeType() + '/' + part.getMimeSubtype()));
    }

    public Vector getMessageFields() {
        return this.messageFields;
    }

    private static abstract class MessageFieldChangeListener
    implements FieldChangeListener {
        private MessagePart part;

        public MessageFieldChangeListener(MessagePart part) {
            this.part = part;
        }

        protected MessagePart getPart() {
            return this.part;
        }

        public abstract /* synthetic */ void fieldChanged(Field var1, int var2);
    }
}

