/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Vector;
import net.rim.device.api.system.Application;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.NullField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.container.VerticalFieldManager;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.MessageNodeEvent;
import org.logicprobe.LogicMail.model.MessageNodeListener;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.BorderedFieldManager;
import org.logicprobe.LogicMail.ui.CompositionScreen;
import org.logicprobe.LogicMail.ui.MailboxSelectionDialog;
import org.logicprobe.LogicMail.ui.MessagePropertiesDialog;
import org.logicprobe.LogicMail.ui.MessageRenderer;
import org.logicprobe.LogicMail.ui.ThrobberField;

public class MessageScreen
extends BaseScreen {
    private BorderedFieldManager addressFieldManager;
    private BorderedFieldManager subjectFieldManager;
    private VerticalFieldManager messageFieldManager;
    private AccountConfig accountConfig;
    private MessageNode messageNode;
    private MessageEnvelope envelope;
    private boolean isSentFolder;
    private boolean messageRendered;
    private ThrobberField throbberField;
    private MessageNodeListener messageNodeListener = new MessageNodeListener(){

        public void messageStatusChanged(MessageNodeEvent e) {
            MessageScreen.this.messageNode_MessageStatusChanged(e);
        }
    };
    private MenuItem propsItem = new MenuItem(BaseScreen.resources.getString(70), 100, 10){

        public void run() {
            MessagePropertiesDialog dialog = new MessagePropertiesDialog(MessageScreen.this.messageNode);
            dialog.doModal();
        }
    };
    private MenuItem replyItem = new MenuItem(BaseScreen.resources.getString(85), 110, 10){

        public void run() {
            if (MessageScreen.this.messageNode.getMessage() != null) {
                CompositionScreen screen = new CompositionScreen(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode, 1);
                UiApplication.getUiApplication().pushModalScreen((Screen)screen);
            }
        }
    };
    private MenuItem replyAllItem = new MenuItem(BaseScreen.resources.getString(86), 115, 10){

        public void run() {
            if (MessageScreen.this.messageNode.getMessage() != null) {
                CompositionScreen screen = new CompositionScreen(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode, 2);
                UiApplication.getUiApplication().pushModalScreen((Screen)screen);
            }
        }
    };
    private MenuItem forwardItem = new MenuItem(BaseScreen.resources.getString(87), 120, 10){

        public void run() {
            if (MessageScreen.this.messageNode.getMessage() != null) {
                CompositionScreen screen = new CompositionScreen(MessageScreen.this.messageNode.getParent().getParentAccount(), MessageScreen.this.messageNode, 3);
                UiApplication.getUiApplication().pushModalScreen((Screen)screen);
            }
        }
    };
    private MenuItem copyToItem = new MenuItem(BaseScreen.resources.getString(92), 125, 10){

        public void run() {
            if (MessageScreen.this.messageNode.getMessage() != null) {
                AccountNode[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
                MailboxSelectionDialog dialog = new MailboxSelectionDialog(BaseScreen.resources.getString(94), accountNodes);
                dialog.setSelectedMailboxNode(MessageScreen.this.messageNode.getParent());
                dialog.addUnselectableNode(MessageScreen.this.messageNode.getParent());
                dialog.doModal();
                MailboxNode selectedMailbox = dialog.getSelectedMailboxNode();
                if (selectedMailbox != null && selectedMailbox != MessageScreen.this.messageNode.getParent()) {
                    selectedMailbox.appendMessage(MessageScreen.this.messageNode);
                }
            }
        }
    };
    private MenuItem moveToItem = new MenuItem(BaseScreen.resources.getString(93), 130, 10){

        public void run() {
            if (MessageScreen.this.messageNode.getMessage() != null) {
                AccountNode[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
                MailboxSelectionDialog dialog = new MailboxSelectionDialog(BaseScreen.resources.getString(95), accountNodes);
                dialog.setSelectedMailboxNode(MessageScreen.this.messageNode.getParent());
                dialog.addUnselectableNode(MessageScreen.this.messageNode.getParent());
                dialog.doModal();
                MailboxNode selectedMailbox = dialog.getSelectedMailboxNode();
                if (selectedMailbox != null && selectedMailbox != MessageScreen.this.messageNode.getParent()) {
                    selectedMailbox.appendMessage(MessageScreen.this.messageNode);
                }
            }
        }
    };
    private MenuItem compositionItem = new MenuItem(BaseScreen.resources.getString(73), 150, 10){

        public void run() {
            UiApplication.getUiApplication().pushScreen((Screen)new CompositionScreen(MessageScreen.this.messageNode.getParent().getParentAccount()));
        }
    };
    private MenuItem closeItem = new MenuItem(BaseScreen.resources.getString(3), 200000, 10){

        public void run() {
            MessageScreen.this.onClose();
        }
    };

    public MessageScreen(MessageNode messageNode) {
        super(0x100000000000L);
        this.messageNode = messageNode;
        this.accountConfig = messageNode.getParent().getParentAccount().getAccountConfig();
        this.envelope = messageNode.getFolderMessage().getEnvelope();
        int mailboxType = messageNode.getParent().getType();
        this.isSentFolder = mailboxType == 4 || mailboxType == 2;
        this.addressFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_NONE);
        this.subjectFieldManager = new BorderedFieldManager(0xA000000000000L | BorderedFieldManager.BOTTOM_BORDER_LINE);
        this.messageFieldManager = new VerticalFieldManager();
        if (this.isSentFolder) {
            if (this.envelope.to != null && this.envelope.to.length > 0) {
                this.addressFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(80) + " " + this.envelope.to[0]));
                if (this.envelope.to.length > 1) {
                    for (int i = 1; i < this.envelope.to.length; ++i) {
                        if (this.envelope.to[i] == null) continue;
                        this.addressFieldManager.add((Field)new RichTextField("    " + this.envelope.to[i]));
                    }
                }
            }
        } else if (this.envelope.from != null && this.envelope.from.length > 0) {
            this.addressFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(78) + " " + this.envelope.from[0]));
            if (this.envelope.from.length > 1) {
                for (int i = 1; i < this.envelope.from.length; ++i) {
                    if (this.envelope.from[i] == null) continue;
                    this.addressFieldManager.add((Field)new RichTextField("      " + this.envelope.from[i]));
                }
            }
        }
        if (this.envelope.subject != null) {
            this.subjectFieldManager.add((Field)new RichTextField(BaseScreen.resources.getString(76) + " " + this.envelope.subject));
        }
        this.add((Field)this.addressFieldManager);
        this.add((Field)this.subjectFieldManager);
        this.add((Field)this.messageFieldManager);
    }

    protected void onDisplay() {
        super.onDisplay();
        this.messageNode.addMessageNodeListener(this.messageNodeListener);
        if (this.messageNode.getMessage() == null) {
            this.throbberField = new ThrobberField(this.getWidth() / 4, 0x300000000L);
            this.add(this.throbberField);
            this.messageNode.refreshMessage();
        } else if (!this.messageRendered) {
            this.renderMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onUndisplay() {
        this.messageNode.removeMessageNodeListener(this.messageNodeListener);
        Object object = Application.getEventLock();
        synchronized (object) {
            if (this.throbberField != null) {
                this.delete(this.throbberField);
                this.throbberField = null;
            }
        }
        super.onUndisplay();
    }

    protected void makeMenu(Menu menu, int instance) {
        menu.add(this.propsItem);
        menu.addSeparator();
        if (this.accountConfig != null && this.accountConfig.getOutgoingConfig() != null) {
            menu.add(this.replyItem);
            if (this.accountConfig.getIdentityConfig() != null) {
                menu.add(this.replyAllItem);
            }
            menu.add(this.forwardItem);
            menu.add(this.compositionItem);
        }
        menu.add(this.copyToItem);
        menu.add(this.moveToItem);
        menu.addSeparator();
        menu.add(this.closeItem);
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': 
            case ' ': {
                if (status == 0) {
                    this.scroll(512);
                    retval = true;
                    break;
                }
                if (status != 1) break;
                this.scroll(256);
                retval = true;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageNode_MessageStatusChanged(MessageNodeEvent e) {
        if (e.getType() == 0) {
            Object object = Application.getEventLock();
            synchronized (object) {
                if (this.throbberField != null) {
                    this.delete(this.throbberField);
                    this.throbberField = null;
                }
            }
            this.renderMessage();
        }
    }

    private void renderMessage() {
        Message message = this.messageNode.getMessage();
        if (message != null) {
            Vector messageFields;
            if (message.getBody() != null) {
                MessageRenderer messageRenderer = new MessageRenderer();
                message.getBody().accept(messageRenderer);
                messageFields = messageRenderer.getMessageFields();
            } else {
                messageFields = new Vector();
                messageFields.addElement(new RichTextField(BaseScreen.resources.getString(88)));
            }
            this.drawMessageFields(messageFields);
            this.messageRendered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawMessageFields(Vector messageFields) {
        if (messageFields == null) {
            return;
        }
        Object object = Application.getEventLock();
        synchronized (object) {
            int size = messageFields.size();
            for (int i = 0; i < size; ++i) {
                if (messageFields.elementAt(i) != null) {
                    this.messageFieldManager.add((Field)messageFields.elementAt(i));
                }
                if (i == size - 1) continue;
                this.messageFieldManager.add((Field)new SeparatorField(0x40000000000000L));
            }
            this.messageFieldManager.add((Field)new NullField(0x40000000000000L));
        }
    }
}

