/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Timer;
import java.util.TimerTask;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Graphics;

public class ThrobberField
extends Field {
    private static double PI_4 = 0.7853981633974483;
    private int size;
    private int sizeHalf;
    private int sizeDiv;
    private int radius;
    private int position = 0;
    private Timer timer;
    private TimerTask timerTask;
    private int[] cx;
    private int[] cy;

    public ThrobberField(int size) {
        this.initField(size);
    }

    public ThrobberField(int size, long style) {
        super(style);
        this.initField(size);
    }

    private void initField(int size) {
        this.size = size;
        this.sizeHalf = size / 2;
        this.sizeDiv = size / 8;
        this.radius = size / 10;
        this.timer = new Timer();
        this.cx = new int[8];
        this.cy = new int[8];
        this.cx[0] = (this.sizeHalf - this.sizeDiv) / 2;
        this.cy[0] = this.sizeHalf;
        this.cx[1] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[1] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
        this.cx[2] = this.sizeHalf;
        this.cy[2] = (this.sizeHalf - this.sizeDiv) / 2;
        this.cx[3] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[3] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
        this.cx[4] = size - (this.sizeHalf - this.sizeDiv) / 2;
        this.cy[4] = this.sizeHalf;
        this.cx[5] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[5] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
        this.cx[6] = this.sizeHalf;
        this.cy[6] = size - (this.sizeHalf - this.sizeDiv) / 2;
        this.cx[7] = (int)(((double)this.sizeHalf - (double)this.sizeDiv * Math.cos(PI_4) + ((double)this.sizeHalf - (double)this.sizeHalf * Math.cos(PI_4))) / 2.0);
        this.cy[7] = (int)(((double)this.sizeHalf + (double)this.sizeDiv * Math.sin(PI_4) + ((double)this.sizeHalf + (double)this.sizeHalf * Math.sin(PI_4))) / 2.0);
    }

    protected void onDisplay() {
        super.onDisplay();
        this.timerTask = new AnimationTimerTask();
        this.timer.scheduleAtFixedRate(this.timerTask, 200L, 100L);
    }

    protected void onUndisplay() {
        this.timerTask.cancel();
        super.onUndisplay();
    }

    protected void layout(int width, int height) {
        this.setExtent(this.size, this.size);
    }

    protected void paint(Graphics graphics) {
        int color;
        int i;
        int index = 0;
        for (i = this.position; i >= 0; --i) {
            color = 31 * Math.min(6, index);
            graphics.setColor(color * 65536 + color * 256 + color);
            this.drawCircle(graphics, i);
            ++index;
        }
        for (i = 7; i > this.position; --i) {
            color = 31 * Math.min(6, index);
            graphics.setColor(color * 65536 + color * 256 + color);
            this.drawCircle(graphics, i);
            ++index;
        }
    }

    private void drawCircle(Graphics graphics, int index) {
        if (index < 0 || index > 7) {
            return;
        }
        graphics.fillArc(this.cx[index] - this.radius, this.cy[index] - this.radius, this.radius * 2, this.radius * 2, 0, 360);
    }

    public int getPreferredWidth() {
        return this.size;
    }

    public int getPreferredHeight() {
        return this.size;
    }

    private class AnimationTimerTask
    extends TimerTask {
        private AnimationTimerTask() {
        }

        public void run() {
            if (ThrobberField.this.position < 7) {
                ThrobberField.this.position++;
            } else {
                ThrobberField.this.position = 0;
            }
            ThrobberField.this.invalidate();
        }
    }
}

