/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.ButtonField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.container.HorizontalFieldManager;
import net.rim.device.api.ui.container.MainScreen;

public abstract class WizardScreen
extends MainScreen {
    protected static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private LabelField titleLabel;
    private HorizontalFieldManager statusFieldManager;
    private ButtonField cancelButton;
    private ButtonField prevButton;
    private ButtonField nextButton;
    private static final int MENU_CONTEXT = 65536;
    private static final int MENU_MAIN = 0x40000000;
    public static final int PAGE_NORMAL = 0;
    public static final int PAGE_FIRST = 1;
    public static final int PAGE_LAST = 2;
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_PREV = 1;
    public static final int RESULT_NEXT = 2;
    private String title;
    private int pageType;
    private int pageResult;
    private boolean isInputValid;
    private boolean isEnabled = true;

    public WizardScreen(String title, int pageType) {
        this.title = title;
        this.pageType = pageType;
        this.pageResult = 0;
        this.initBaseFields();
        this.initFields();
        this.nextButton.setEditable(this.isInputValid);
    }

    private void initBaseFields() {
        this.titleLabel = new LabelField((Object)this.title, 0x1000000000000040L);
        this.setTitle((Field)this.titleLabel);
        this.cancelButton = new ButtonField(resources.getString(38));
        this.cancelButton.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                WizardScreen.this.cancelButton_fieldChanged(field, context);
            }
        });
        this.prevButton = new ButtonField("< " + resources.getString(110));
        this.prevButton.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                WizardScreen.this.prevButton_fieldChanged(field, context);
            }
        });
        this.nextButton = new ButtonField(resources.getString(111) + " >");
        this.nextButton.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                WizardScreen.this.nextButton_fieldChanged(field, context);
            }
        });
        this.statusFieldManager = new HorizontalFieldManager(){

            protected void onFocus(int direction) {
                if (direction == 1) {
                    if (WizardScreen.this.isInputValid) {
                        this.getField(this.getFieldCount() - 1).setFocus();
                    } else {
                        this.getField(this.getFieldCount() - 2).setFocus();
                    }
                } else {
                    super.onFocus(direction);
                }
            }
        };
        this.statusFieldManager.add((Field)this.cancelButton);
        if (this.pageType == 0) {
            this.statusFieldManager.add((Field)this.prevButton);
            this.statusFieldManager.add((Field)this.nextButton);
        } else if (this.pageType == 1) {
            this.statusFieldManager.add((Field)this.nextButton);
        } else if (this.pageType == 2) {
            this.statusFieldManager.add((Field)this.prevButton);
            this.nextButton.setLabel(resources.getString(112));
            this.statusFieldManager.add((Field)this.nextButton);
        }
        this.setStatus((Field)this.statusFieldManager);
    }

    protected abstract void initFields();

    protected void setInputValid(boolean isInputValid) {
        this.isInputValid = isInputValid;
        this.nextButton.setEditable(isInputValid);
    }

    protected boolean isInputValid() {
        return this.isInputValid;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean onMenu(int instance) {
        if (instance == 0x40000000) {
            return super.onMenu(instance);
        }
        if (instance == 65536) {
            if (!this.onClick()) {
                return super.onMenu(instance);
            }
            return false;
        }
        return super.onMenu(instance);
    }

    protected boolean onClick() {
        return this.getFieldWithFocus() == this.statusFieldManager;
    }

    protected boolean keyChar(char c, int status, int time) {
        return super.keyChar(c, status, time);
    }

    private void cancelButton_fieldChanged(Field field, int context) {
        this.pageResult = 0;
        this.onClose();
    }

    private void prevButton_fieldChanged(Field field, int context) {
        this.pageResult = 1;
        this.onClose();
    }

    private void nextButton_fieldChanged(Field field, int context) {
        this.pageResult = 2;
        this.onClose();
    }

    public void onPageEnter() {
    }

    protected void onPageFlip() {
    }

    public boolean onClose() {
        if (this.pageResult == 0) {
            int result = Dialog.ask((int)3, (String)resources.getString(113));
            if (result == 4) {
                this.close();
                return true;
            }
            return false;
        }
        this.onPageFlip();
        this.close();
        return true;
    }

    public int getPageResult() {
        return this.pageResult;
    }

    public void gatherResults() {
    }
}

