/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.rim.device.api.system.PersistentObject;
import net.rim.device.api.system.PersistentStore;
import org.logicprobe.LogicMail.util.DataStore;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializationUtils;

public class PersistentObjectDataStore
implements DataStore {
    private long storeUid;
    private PersistentObject store;
    private Hashtable nameMap;
    private Hashtable objectMap;

    public PersistentObjectDataStore(long storeUid) {
        this.storeUid = storeUid;
        this.store = PersistentStore.getPersistentObject((long)storeUid);
        this.objectMap = new Hashtable();
        this.nameMap = new Hashtable();
    }

    public Serializable getNamedObject(String name) {
        Object value = this.nameMap.get(name);
        if (value instanceof Long) {
            value = this.objectMap.get(value);
            return (Serializable)value;
        }
        return null;
    }

    public String[] getNamedObjects() {
        String[] result = new String[this.nameMap.size()];
        Enumeration e = this.nameMap.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            result[i++] = (String)e.nextElement();
        }
        return result;
    }

    public Serializable getObject(long id) {
        return (Serializable)this.objectMap.get(new Long(id));
    }

    public void putNamedObject(String name, Serializable object) {
        this.nameMap.put(name, new Long(object.getUniqueId()));
        this.putObject(object);
    }

    public void putObject(Serializable object) {
        this.objectMap.put(new Long(object.getUniqueId()), object);
    }

    public void removeNamedObject(String name) {
        this.removeObject(this.getNamedObject(name));
        this.nameMap.remove(name);
    }

    public void removeObject(Serializable object) {
        this.objectMap.remove(new Long(object.getUniqueId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Vector<byte[]> objectData = new Vector<byte[]>();
        Enumeration e = this.objectMap.elements();
        while (e.hasMoreElements()) {
            byte[] byteArray = SerializationUtils.serializeClass((Serializable)e.nextElement());
            objectData.addElement(byteArray);
        }
        Object[] storeData = new Object[]{this.nameMap, objectData};
        PersistentObject persistentObject = this.store;
        synchronized (persistentObject) {
            this.store.setContents((Object)storeData);
            this.store.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Hashtable newNameMap = null;
        Vector newObjectMap = null;
        PersistentObject persistentObject = this.store;
        synchronized (persistentObject) {
            Object[] storeData = (Object[])this.store.getContents();
            if (storeData != null) {
                newNameMap = (Hashtable)storeData[0];
                newObjectMap = (Vector)storeData[1];
            }
        }
        if (newNameMap != null && newObjectMap != null) {
            this.nameMap = newNameMap;
            int size = newObjectMap.size();
            for (int i = 0; i < size; ++i) {
                Serializable deserializedObject = SerializationUtils.deserializeClass((byte[])newObjectMap.elementAt(i));
                if (!(deserializedObject instanceof Serializable)) continue;
                this.objectMap.put(new Long(deserializedObject.getUniqueId()), deserializedObject);
            }
        }
    }

    public void delete() {
        PersistentStore.destroyPersistentObject((long)this.storeUid);
    }
}

