/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.util.Serializable;

public final class SerializationUtils {
    private SerializationUtils() {
    }

    public static byte[] serializeClass(Serializable input) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(buffer);
        try {
            output.writeUTF(input.getClass().getName());
            input.serialize(output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toByteArray();
    }

    public static Serializable deserializeClass(byte[] data) {
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(data));
        Serializable result = null;
        try {
            String classType = input.readUTF();
            Object deserializedObject = Class.forName(classType).newInstance();
            if (deserializedObject instanceof Serializable) {
                result = (Serializable)deserializedObject;
                result.deserialize(input);
            }
        }
        catch (IOException ex) {
            result = null;
        }
        catch (ClassNotFoundException ex) {
            result = null;
        }
        catch (InstantiationException ex) {
            result = null;
        }
        catch (IllegalAccessException ex) {
            result = null;
        }
        return result;
    }
}

