/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import org.logicprobe.LogicMail.util.Queue;

public class ThreadQueue {
    private Queue runnableQueue = new Queue();
    private ThreadQueueThread threadQueueThread;
    private boolean isShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean wait) {
        this.isShutdown = true;
        Queue queue = this.runnableQueue;
        synchronized (queue) {
            this.runnableQueue.clear();
        }
        if (wait && this.threadQueueThread != null) {
            try {
                this.threadQueueThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.threadQueueThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeLater(Runnable runnable) {
        if (this.isShutdown) {
            throw new IllegalStateException("Thread queue has been shutdown");
        }
        boolean queued = false;
        Queue queue = this.runnableQueue;
        synchronized (queue) {
            if (this.threadQueueThread != null && this.threadQueueThread.isAlive()) {
                this.runnableQueue.add(runnable);
                queued = true;
            }
        }
        if (!queued) {
            if (this.threadQueueThread != null) {
                try {
                    this.threadQueueThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.threadQueueThread = null;
            }
            this.threadQueueThread = new ThreadQueueThread();
            this.runnableQueue.add(runnable);
            this.threadQueueThread.start();
        }
    }

    private class ThreadQueueThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Runnable runnable;
                Queue queue = ThreadQueue.this.runnableQueue;
                synchronized (queue) {
                    if (ThreadQueue.this.runnableQueue.element() == null) {
                        return;
                    }
                    runnable = (Runnable)ThreadQueue.this.runnableQueue.remove();
                }
                Thread.yield();
                try {
                    runnable.run();
                    continue;
                }
                catch (RuntimeException exp) {
                    System.err.println(exp.toString());
                    continue;
                }
                break;
            }
        }
    }
}

