/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializableHashtable;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class IdentityConfig
implements Serializable {
    private long uniqueId;
    private String identityName;
    private String fullName;
    private String emailAddress;
    private String replyToAddress;
    private String msgSignature;

    public IdentityConfig() {
        this.setDefaults();
    }

    public IdentityConfig(DataInputStream input) {
        try {
            this.deserialize(input);
        }
        catch (IOException ex) {
            this.setDefaults();
        }
    }

    private void setDefaults() {
        this.uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
        this.identityName = "";
        this.fullName = "";
        this.emailAddress = "";
        this.replyToAddress = "";
        this.msgSignature = "";
    }

    public String toString() {
        return this.identityName;
    }

    public String getIdentityName() {
        return this.identityName;
    }

    public void setIdentityName(String identityName) {
        this.identityName = identityName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getReplyToAddress() {
        return this.replyToAddress;
    }

    public void setReplyToAddress(String replyToAddress) {
        this.replyToAddress = replyToAddress;
    }

    public String getMsgSignature() {
        return this.msgSignature;
    }

    public void setMsgSignature(String msgSignature) {
        this.msgSignature = msgSignature;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        SerializableHashtable table = new SerializableHashtable();
        table.put("identity_identityName", this.identityName);
        table.put("identity_fullName", this.fullName);
        table.put("identity_emailAddress", this.emailAddress);
        table.put("identity_replyToAddress", this.replyToAddress);
        table.put("identity_msgSignature", this.msgSignature);
        table.serialize(output);
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.setDefaults();
        this.uniqueId = input.readLong();
        SerializableHashtable table = new SerializableHashtable();
        table.deserialize(input);
        Object value = table.get("identity_identityName");
        if (value != null && value instanceof String) {
            this.identityName = (String)value;
        }
        if ((value = table.get("identity_fullName")) != null && value instanceof String) {
            this.fullName = (String)value;
        }
        if ((value = table.get("identity_emailAddress")) != null && value instanceof String) {
            this.emailAddress = (String)value;
        }
        if ((value = table.get("identity_replyToAddress")) != null && value instanceof String) {
            this.replyToAddress = (String)value;
        }
        if ((value = table.get("identity_msgSignature")) != null && value instanceof String) {
            this.msgSignature = (String)value;
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }
}

