/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.util.Vector;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.ConnectionConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.IdentityConfig;
import org.logicprobe.LogicMail.conf.MailSettingsEvent;
import org.logicprobe.LogicMail.conf.MailSettingsListener;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.util.DataStore;
import org.logicprobe.LogicMail.util.DataStoreFactory;
import org.logicprobe.LogicMail.util.EventListener;
import org.logicprobe.LogicMail.util.EventListenerList;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializableVector;

public class MailSettings {
    private static MailSettings instance;
    private EventListenerList listenerList = new EventListenerList();
    private GlobalConfig globalConfig = new GlobalConfig();
    private Vector identityConfigs = new Vector();
    private Vector accountConfigs = new Vector();
    private Vector outgoingConfigs = new Vector();
    private DataStore configStore = DataStoreFactory.getConfigurationStore();
    private static String GLOBAL_CONFIG;
    private static String IDENTITY_CONFIGS;
    private static String ACCOUNT_CONFIGS;
    private static String OUTGOING_CONFIGS;
    static /* synthetic */ Class class$org$logicprobe$LogicMail$conf$MailSettingsListener;

    private MailSettings() {
    }

    public static synchronized MailSettings getInstance() {
        if (instance == null) {
            instance = new MailSettings();
        }
        return instance;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }

    public int getNumIdentities() {
        return this.identityConfigs.size();
    }

    public IdentityConfig getIdentityConfig(int index) {
        return (IdentityConfig)this.identityConfigs.elementAt(index);
    }

    public IdentityConfig getIdentityConfigByUniqueId(long uniqueId) {
        int size = this.getNumIdentities();
        for (int i = 0; i < size; ++i) {
            IdentityConfig tmpConfig = this.getIdentityConfig(i);
            if (tmpConfig.getUniqueId() != uniqueId) continue;
            return tmpConfig;
        }
        return null;
    }

    public void addIdentityConfig(IdentityConfig identityConfig) {
        this.identityConfigs.addElement(identityConfig);
    }

    public void removeIdentityConfig(int index) {
        this.identityConfigs.removeElementAt(index);
    }

    public int getNumAccounts() {
        return this.accountConfigs.size();
    }

    public AccountConfig getAccountConfig(int index) {
        return (AccountConfig)this.accountConfigs.elementAt(index);
    }

    public void addAccountConfig(AccountConfig accountConfig) {
        this.accountConfigs.addElement(accountConfig);
    }

    public void removeAccountConfig(int index) {
        this.accountConfigs.removeElementAt(index);
    }

    public boolean containsAccountConfig(AccountConfig accountConfig) {
        return this.accountConfigs.contains(accountConfig);
    }

    public int getNumOutgoing() {
        return this.outgoingConfigs.size();
    }

    public OutgoingConfig getOutgoingConfig(int index) {
        return (OutgoingConfig)this.outgoingConfigs.elementAt(index);
    }

    public OutgoingConfig getOutgoingConfigByUniqueId(long uniqueId) {
        int size = this.getNumOutgoing();
        for (int i = 0; i < size; ++i) {
            OutgoingConfig tmpConfig = this.getOutgoingConfig(i);
            if (tmpConfig.getUniqueId() != uniqueId) continue;
            return tmpConfig;
        }
        return null;
    }

    public void addOutgoingConfig(OutgoingConfig outgoingConfig) {
        this.outgoingConfigs.addElement(outgoingConfig);
    }

    public void removeOutgoingConfig(int index) {
        this.outgoingConfigs.removeElementAt(index);
    }

    public boolean containsOutgoingConfig(OutgoingConfig outgoingConfig) {
        return this.outgoingConfigs.contains(outgoingConfig);
    }

    public void saveSettings() {
        Serializable config;
        int i;
        SerializableVector identityConfigIds = new SerializableVector();
        SerializableVector accountConfigIds = new SerializableVector();
        SerializableVector outgoingConfigIds = new SerializableVector();
        this.configStore.putNamedObject(GLOBAL_CONFIG, this.globalConfig);
        this.configStore.putNamedObject(IDENTITY_CONFIGS, identityConfigIds);
        this.configStore.putNamedObject(ACCOUNT_CONFIGS, accountConfigIds);
        this.configStore.putNamedObject(OUTGOING_CONFIGS, outgoingConfigIds);
        int size = this.identityConfigs.size();
        for (i = 0; i < size; ++i) {
            config = (IdentityConfig)this.identityConfigs.elementAt(i);
            identityConfigIds.addElement(new Long(((IdentityConfig)config).getUniqueId()));
            this.configStore.putObject(config);
        }
        size = this.accountConfigs.size();
        for (i = 0; i < size; ++i) {
            config = (AccountConfig)this.accountConfigs.elementAt(i);
            accountConfigIds.addElement(new Long(((ConnectionConfig)config).getUniqueId()));
            this.configStore.putObject(config);
        }
        size = this.outgoingConfigs.size();
        for (i = 0; i < size; ++i) {
            config = (OutgoingConfig)this.outgoingConfigs.elementAt(i);
            outgoingConfigIds.addElement(new Long(((ConnectionConfig)config).getUniqueId()));
            this.configStore.putObject(config);
        }
        this.configStore.save();
        this.fireMailSettingsSaved();
    }

    public void loadSettings() {
        int i;
        int size;
        SerializableVector configIds;
        this.configStore.load();
        Serializable loadedObj = this.configStore.getNamedObject(GLOBAL_CONFIG);
        this.globalConfig = loadedObj instanceof GlobalConfig ? (GlobalConfig)loadedObj : new GlobalConfig();
        this.identityConfigs.removeAllElements();
        this.accountConfigs.removeAllElements();
        this.outgoingConfigs.removeAllElements();
        loadedObj = this.configStore.getNamedObject(IDENTITY_CONFIGS);
        if (loadedObj instanceof SerializableVector) {
            configIds = (SerializableVector)loadedObj;
            size = configIds.size();
            for (i = 0; i < size; ++i) {
                loadedObj = this.configStore.getObject((Long)configIds.elementAt(i));
                if (!(loadedObj instanceof IdentityConfig)) continue;
                this.identityConfigs.addElement(loadedObj);
            }
        }
        if ((loadedObj = this.configStore.getNamedObject(ACCOUNT_CONFIGS)) instanceof SerializableVector) {
            configIds = (SerializableVector)loadedObj;
            size = configIds.size();
            for (i = 0; i < size; ++i) {
                loadedObj = this.configStore.getObject((Long)configIds.elementAt(i));
                if (!(loadedObj instanceof AccountConfig)) continue;
                this.accountConfigs.addElement(loadedObj);
            }
        }
        if ((loadedObj = this.configStore.getNamedObject(OUTGOING_CONFIGS)) instanceof SerializableVector) {
            configIds = (SerializableVector)loadedObj;
            size = configIds.size();
            for (i = 0; i < size; ++i) {
                loadedObj = this.configStore.getObject((Long)configIds.elementAt(i));
                if (!(loadedObj instanceof OutgoingConfig)) continue;
                this.outgoingConfigs.addElement(loadedObj);
            }
        }
    }

    public void addMailSettingsListener(MailSettingsListener l) {
        this.listenerList.add(class$org$logicprobe$LogicMail$conf$MailSettingsListener == null ? (class$org$logicprobe$LogicMail$conf$MailSettingsListener = MailSettings.class$("org.logicprobe.LogicMail.conf.MailSettingsListener")) : class$org$logicprobe$LogicMail$conf$MailSettingsListener, l);
    }

    public void removeMailSettingsListener(MailSettingsListener l) {
        this.listenerList.remove(class$org$logicprobe$LogicMail$conf$MailSettingsListener == null ? (class$org$logicprobe$LogicMail$conf$MailSettingsListener = MailSettings.class$("org.logicprobe.LogicMail.conf.MailSettingsListener")) : class$org$logicprobe$LogicMail$conf$MailSettingsListener, l);
    }

    public MailSettingsListener[] getMailSettingsListener() {
        return (MailSettingsListener[])this.listenerList.getListeners(class$org$logicprobe$LogicMail$conf$MailSettingsListener == null ? (class$org$logicprobe$LogicMail$conf$MailSettingsListener = MailSettings.class$("org.logicprobe.LogicMail.conf.MailSettingsListener")) : class$org$logicprobe$LogicMail$conf$MailSettingsListener);
    }

    protected void fireMailSettingsSaved() {
        EventListener[] listeners = this.listenerList.getListeners(class$org$logicprobe$LogicMail$conf$MailSettingsListener == null ? (class$org$logicprobe$LogicMail$conf$MailSettingsListener = MailSettings.class$("org.logicprobe.LogicMail.conf.MailSettingsListener")) : class$org$logicprobe$LogicMail$conf$MailSettingsListener);
        MailSettingsEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new MailSettingsEvent(this);
            }
            ((MailSettingsListener)listeners[i]).mailSettingsSaved(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        GLOBAL_CONFIG = "global_config";
        IDENTITY_CONFIGS = "identity_configs";
        ACCOUNT_CONFIGS = "account_configs";
        OUTGOING_CONFIGS = "outgoing_configs";
    }
}

