/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.imap;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.ConnectionConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.ImapConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.MailSettingsEvent;
import org.logicprobe.LogicMail.conf.MailSettingsListener;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.mail.imap.ImapMessageToken;
import org.logicprobe.LogicMail.mail.imap.ImapParser;
import org.logicprobe.LogicMail.mail.imap.ImapProtocol;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageContent;
import org.logicprobe.LogicMail.message.MessageContentFactory;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartFactory;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.UnsupportedContentException;
import org.logicprobe.LogicMail.message.UnsupportedPart;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.DataStore;
import org.logicprobe.LogicMail.util.DataStoreFactory;
import org.logicprobe.LogicMail.util.Serializable;

public class ImapClient
implements IncomingMailClient {
    private ImapConfig accountConfig;
    private Connection connection;
    private ImapProtocol imapProtocol;
    private String username;
    private String password;
    private boolean openStarted;
    private boolean configChanged;
    private Hashtable capabilities;
    private String folderDelim = "";
    private ImapProtocol.Namespace nsPersonal;
    private FolderTreeItem activeMailbox = null;
    private FolderTreeItem inboxMailbox = null;
    private Hashtable seenMailboxes = new Hashtable();
    private Hashtable knownMailboxes = new Hashtable();
    private static String strINBOX = "INBOX";
    private MailSettingsListener mailSettingsListener = new MailSettingsListener(){

        public void mailSettingsSaved(MailSettingsEvent e) {
            ImapClient.this.mailSettings_MailSettingsSaved(e);
        }
    };

    public ImapClient(GlobalConfig globalConfig, ImapConfig accountConfig) {
        this.accountConfig = accountConfig;
        this.connection = new Connection(accountConfig.getServerName(), accountConfig.getServerPort(), accountConfig.getServerSSL(), accountConfig.getDeviceSide());
        this.imapProtocol = new ImapProtocol(this.connection);
        this.username = accountConfig.getServerUser();
        this.password = accountConfig.getServerPass();
        this.openStarted = false;
        this.configChanged = false;
        MailSettings.getInstance().addMailSettingsListener(this.mailSettingsListener);
    }

    private void mailSettings_MailSettingsSaved(MailSettingsEvent e) {
        if (MailSettings.getInstance().containsAccountConfig(this.accountConfig)) {
            this.username = this.accountConfig.getServerUser();
            this.password = this.accountConfig.getServerPass();
            if (!this.isConnected()) {
                this.connection = new Connection(this.accountConfig.getServerName(), this.accountConfig.getServerPort(), this.accountConfig.getServerSSL(), this.accountConfig.getDeviceSide());
                this.imapProtocol = new ImapProtocol(this.connection);
            } else {
                this.configChanged = true;
            }
        } else {
            MailSettings.getInstance().removeMailSettingsListener(this.mailSettingsListener);
        }
    }

    public boolean open() throws IOException, MailException {
        try {
            Vector resp;
            if (!this.openStarted) {
                this.connection.open();
                this.activeMailbox = null;
                this.connection.receive();
                this.capabilities = this.imapProtocol.executeCapability();
                this.openStarted = true;
            }
            if (!this.imapProtocol.executeLogin(this.username, this.password)) {
                return false;
            }
            if (this.capabilities.containsKey("NAMESPACE")) {
                ImapProtocol.NamespaceResponse nsResponse = this.imapProtocol.executeNamespace();
                if (nsResponse.personal != null && nsResponse.personal.length > 0 && nsResponse.personal[0] != null && nsResponse.personal[0].delimiter != null && nsResponse.personal[0].prefix != null) {
                    this.nsPersonal = nsResponse.personal[0];
                    this.folderDelim = this.nsPersonal.delimiter;
                }
            }
            if (this.nsPersonal == null && (resp = this.imapProtocol.executeList("", "")).size() > 0) {
                this.folderDelim = ((ImapProtocol.ListResponse)resp.elementAt((int)0)).delim;
            }
            this.openStarted = false;
        }
        catch (MailException exp) {
            this.close();
            String msg = exp.getMessage();
            if (msg.startsWith("NO")) {
                msg = msg.substring(msg.indexOf(32) + 1);
            }
            throw new MailException(msg);
        }
        return true;
    }

    public void close() throws IOException, MailException {
        if (this.connection.isConnected()) {
            try {
                this.imapProtocol.executeLogout();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.activeMailbox = null;
        this.connection.close();
        if (this.configChanged) {
            this.connection = new Connection(this.accountConfig.getServerName(), this.accountConfig.getServerPort(), this.accountConfig.getServerSSL(), this.accountConfig.getDeviceSide());
            this.imapProtocol = new ImapProtocol(this.connection);
            this.configChanged = false;
        }
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public AccountConfig getAcctConfig() {
        return this.accountConfig;
    }

    public ConnectionConfig getConnectionConfig() {
        return this.getAcctConfig();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean hasFolders() {
        return true;
    }

    public boolean hasUndelete() {
        return true;
    }

    public boolean hasIdle() {
        return true;
    }

    public FolderTreeItem getFolderTree() throws IOException, MailException {
        FolderTreeItem rootItem = new FolderTreeItem("", "", this.folderDelim);
        boolean childrenExtension = this.capabilities.containsKey("CHILDREN");
        String folderPrefix = this.accountConfig.getFolderPrefix();
        if (folderPrefix != null && folderPrefix.length() > 0) {
            FolderTreeItem fakeRootItem = new FolderTreeItem("", folderPrefix, this.folderDelim);
            this.getFolderTreeImpl(fakeRootItem, 0, childrenExtension);
            try {
                this.imapProtocol.executeStatus(new String[]{strINBOX});
                FolderTreeItem inboxItem = new FolderTreeItem(rootItem, strINBOX, strINBOX, this.folderDelim, true, true);
                rootItem.addChild(inboxItem);
            }
            catch (MailException exp) {
                // empty catch block
            }
            if (fakeRootItem.hasChildren()) {
                FolderTreeItem[] children = fakeRootItem.children();
                for (int i = 0; i < children.length; ++i) {
                    if (children[i].getName().trim().length() <= 0) continue;
                    rootItem.addChild(children[i]);
                }
            }
        } else {
            this.getFolderTreeImpl(rootItem, 0, childrenExtension);
        }
        FolderTreeItem inbox = this.findInboxFolder(rootItem);
        if (inbox != null) {
            this.setInboxFolder(inbox);
        }
        return rootItem;
    }

    private void getFolderTreeImpl(FolderTreeItem baseFolder, int depth, boolean childrenExtension) throws IOException, MailException {
        Vector respList = depth == 0 ? this.imapProtocol.executeList(baseFolder.getPath(), "%") : this.imapProtocol.executeList(baseFolder.getPath() + baseFolder.getDelim(), "%");
        int size = respList.size();
        for (int i = 0; i < size; ++i) {
            ImapProtocol.ListResponse resp = (ImapProtocol.ListResponse)respList.elementAt(i);
            FolderTreeItem childItem = this.getFolderItem(baseFolder, resp.name, resp.canSelect);
            baseFolder.addChild(childItem);
            if (resp.hasChildren || !resp.noInferiors && !childrenExtension) {
                if (depth + 1 >= this.accountConfig.getMaxFolderDepth()) continue;
                this.getFolderTreeImpl(childItem, depth + 1, childrenExtension);
                continue;
            }
            if (depth != 0 || this.nsPersonal == null || !(resp.name + this.nsPersonal.delimiter).equals(this.nsPersonal.prefix) || this.accountConfig.getMaxFolderDepth() <= 1) continue;
            this.getFolderTreeImpl(childItem, depth + 1, childrenExtension);
        }
    }

    public void refreshFolderStatus(FolderTreeItem[] folders) throws IOException, MailException {
        int i;
        Vector<String> mboxPaths = new Vector<String>();
        Hashtable<String, FolderTreeItem> mboxMap = new Hashtable<String, FolderTreeItem>();
        for (i = 0; i < folders.length; ++i) {
            FolderTreeItem item = folders[i];
            if (!item.isSelectable()) continue;
            mboxPaths.addElement(item.getPath());
            mboxMap.put(item.getPath(), item);
        }
        Object[] mboxPathsArray = new String[mboxPaths.size()];
        mboxPaths.copyInto(mboxPathsArray);
        ImapProtocol.StatusResponse[] response = this.imapProtocol.executeStatus((String[])mboxPathsArray);
        for (i = 0; i < mboxPathsArray.length; ++i) {
            FolderTreeItem item = (FolderTreeItem)mboxMap.get(mboxPathsArray[i]);
            item.setMsgCount(response[i].exists);
            item.setUnseenCount(response[i].unseen);
        }
    }

    private FolderTreeItem findInboxFolder(FolderTreeItem mailbox) {
        if (mailbox.getName().equals(strINBOX)) {
            return mailbox;
        }
        if (mailbox.hasChildren()) {
            FolderTreeItem[] children = mailbox.children();
            for (int i = 0; i < children.length; ++i) {
                FolderTreeItem result = this.findInboxFolder(children[i]);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public FolderTreeItem getInboxFolder() {
        DataStore dataStore;
        Serializable loadedObject;
        if (this.inboxMailbox == null && (loadedObject = (dataStore = DataStoreFactory.getConnectionCacheStore()).getNamedObject(Long.toString(this.accountConfig.getUniqueId()) + "_INBOX")) instanceof FolderTreeItem) {
            this.inboxMailbox = (FolderTreeItem)loadedObject;
        }
        return this.inboxMailbox;
    }

    private void setInboxFolder(FolderTreeItem mailbox) {
        if (this.inboxMailbox != mailbox) {
            mailbox = new FolderTreeItem(mailbox);
            DataStore dataStore = DataStoreFactory.getConnectionCacheStore();
            dataStore.putNamedObject(Long.toString(this.accountConfig.getUniqueId()) + "_INBOX", mailbox);
            dataStore.save();
            this.inboxMailbox = mailbox;
        }
    }

    public FolderTreeItem getActiveFolder() {
        return this.activeMailbox;
    }

    public void setActiveFolder(FolderTreeItem mailbox) throws IOException, MailException {
        if (this.activeMailbox != null && this.activeMailbox.getPath().equals(mailbox.getPath())) {
            return;
        }
        ImapProtocol.SelectResponse response = this.imapProtocol.executeSelect(mailbox.getPath());
        this.activeMailbox = mailbox;
        this.activeMailbox.setMsgCount(response.exists);
        this.knownMailboxes.put(this.activeMailbox, response);
    }

    public void setActiveFolder(MessageToken messageToken) throws IOException, MailException {
        ImapMessageToken imapMessageToken = (ImapMessageToken)messageToken;
        String folderPath = imapMessageToken.getFolderPath();
        if (this.activeMailbox != null && this.activeMailbox.getPath().equals(imapMessageToken.getFolderPath())) {
            return;
        }
        ImapProtocol.SelectResponse response = this.imapProtocol.executeSelect(folderPath);
        FolderTreeItem mailbox = null;
        Enumeration e = this.knownMailboxes.keys();
        while (e.hasMoreElements()) {
            FolderTreeItem currentMailbox = (FolderTreeItem)e.nextElement();
            if (!currentMailbox.getPath().equals(folderPath)) continue;
            mailbox = currentMailbox;
            break;
        }
        if (mailbox == null) {
            int p = folderPath.lastIndexOf(this.folderDelim.charAt(0));
            mailbox = p != -1 && p < folderPath.length() - 1 ? new FolderTreeItem(folderPath.substring(p + 1), folderPath, this.folderDelim) : new FolderTreeItem("", folderPath, this.folderDelim);
        }
        this.activeMailbox = mailbox;
        this.activeMailbox.setMsgCount(response.exists);
        this.knownMailboxes.put(this.activeMailbox, response);
    }

    public FolderMessage[] getFolderMessages(int firstIndex, int lastIndex) throws IOException, MailException {
        if (this.activeMailbox == null) {
            throw new MailException("Mailbox not selected");
        }
        if (firstIndex > lastIndex) {
            return new FolderMessage[0];
        }
        ImapProtocol.FetchEnvelopeResponse[] response = this.imapProtocol.executeFetchEnvelope(firstIndex, lastIndex);
        return this.prepareFolderMessages(response);
    }

    public FolderMessage[] getNewFolderMessages() throws IOException, MailException {
        FolderMessage[] result;
        if (this.activeMailbox == null) {
            throw new MailException("Mailbox not selected");
        }
        if (!this.seenMailboxes.containsKey(this.activeMailbox)) {
            int count = MailSettings.getInstance().getGlobalConfig().getRetMsgCount();
            int msgCount = this.activeMailbox.getMsgCount();
            int firstIndex = Math.max(1, msgCount - count);
            result = this.getFolderMessages(firstIndex, this.activeMailbox.getMsgCount());
            this.seenMailboxes.put(this.activeMailbox, new Object());
        } else {
            int uidNext = ((ImapProtocol.SelectResponse)this.knownMailboxes.get((Object)this.activeMailbox)).uidNext;
            ImapProtocol.FetchEnvelopeResponse[] response = this.imapProtocol.executeFetchEnvelopeUid(uidNext);
            result = this.prepareFolderMessages(response);
            if (result.length > 0) {
                ((ImapProtocol.SelectResponse)this.knownMailboxes.get((Object)this.activeMailbox)).uidNext = uidNext = result[result.length - 1].getUid() + 1;
            }
        }
        return result;
    }

    private FolderMessage[] prepareFolderMessages(ImapProtocol.FetchEnvelopeResponse[] response) {
        FolderMessage[] folderMessages = new FolderMessage[response.length];
        for (int i = 0; i < response.length; ++i) {
            folderMessages[i] = new FolderMessage(new ImapMessageToken(this.activeMailbox.getPath(), response[i].uid), response[i].envelope, response[i].index, response[i].uid);
            folderMessages[i].setSeen(response[i].flags.seen);
            folderMessages[i].setAnswered(response[i].flags.answered);
            folderMessages[i].setDeleted(response[i].flags.deleted);
            folderMessages[i].setRecent(response[i].flags.recent);
            folderMessages[i].setFlagged(response[i].flags.flagged);
            folderMessages[i].setDraft(response[i].flags.draft);
            folderMessages[i].setJunk(response[i].flags.junk);
            folderMessages[i].setStructure(this.createMessagePartTree(response[i].structure));
        }
        return folderMessages;
    }

    public Message getMessage(MessageToken messageToken) throws IOException, MailException {
        ImapMessageToken imapMessageToken = (ImapMessageToken)messageToken;
        if (!imapMessageToken.getFolderPath().equalsIgnoreCase(this.activeMailbox.getPath())) {
            throw new MailException("Invalid mailbox for message");
        }
        ImapParser.MessageSection structure = this.getMessageStructure(imapMessageToken.getMessageUid());
        Hashtable contentMap = new Hashtable();
        MessagePart rootPart = this.getMessagePart(contentMap, imapMessageToken.getMessageUid(), structure, this.accountConfig.getMaxMessageSize());
        Message msg = new Message(rootPart);
        Enumeration e = contentMap.keys();
        while (e.hasMoreElements()) {
            MessagePart part = (MessagePart)e.nextElement();
            msg.putContent(part, (MessageContent)contentMap.get(part));
        }
        return msg;
    }

    public MessageContent getMessagePart(MessageToken messageToken, MessagePart messagePart) {
        return null;
    }

    private MessagePart getMessagePart(Hashtable contentMap, int uid, ImapParser.MessageSection structure, int maxSize) throws IOException, MailException {
        MessagePart part;
        if (MessagePartFactory.isMessagePartSupported(structure.type, structure.subtype)) {
            String data;
            if (structure.type.equalsIgnoreCase("multipart")) {
                data = null;
            } else if (structure.size < maxSize) {
                data = this.getMessageBody(uid, structure.address);
                maxSize -= structure.size;
            } else {
                return null;
            }
            part = MessagePartFactory.createMessagePart(structure.type, structure.subtype, structure.encoding, structure.charset, structure.size, structure.address);
            try {
                contentMap.put(part, MessageContentFactory.createContent(part, structure.encoding, structure.charset, data));
            }
            catch (UnsupportedContentException e) {
                System.err.println("UnsupportedContentException: " + e.getMessage());
            }
        } else {
            part = structure.address.equals("1") ? new UnsupportedPart(structure.type, structure.subtype) : null;
        }
        if (part instanceof MultiPart && structure.subsections != null && structure.subsections.length > 0) {
            for (int i = 0; i < structure.subsections.length; ++i) {
                MessagePart subPart = this.getMessagePart(contentMap, uid, structure.subsections[i], maxSize);
                if (subPart == null) continue;
                ((MultiPart)part).addPart(subPart);
            }
        }
        return part;
    }

    private MessagePart createMessagePartTree(ImapParser.MessageSection structure) {
        if (structure == null) {
            return null;
        }
        MessagePart part = MessagePartFactory.createMessagePart(structure.type, structure.subtype, structure.encoding, structure.charset, structure.size, structure.address);
        if (part instanceof MultiPart && structure.subsections != null && structure.subsections.length > 0) {
            MultiPart multiPart = (MultiPart)part;
            for (int i = 0; i < structure.subsections.length; ++i) {
                MessagePart subPart = this.createMessagePartTree(structure.subsections[i]);
                if (subPart == null) continue;
                multiPart.addPart(subPart);
            }
        }
        return part;
    }

    private ImapParser.MessageSection getMessageStructure(int uid) throws IOException, MailException {
        if (this.activeMailbox.equals("")) {
            throw new MailException("Mailbox not selected");
        }
        return this.imapProtocol.executeFetchBodystructure(uid);
    }

    private FolderTreeItem getFolderItem(FolderTreeItem parent, String folderPath, boolean canSelect) throws IOException, MailException {
        int pos = 0;
        int i = 0;
        while ((i = folderPath.indexOf(this.folderDelim, i)) != -1) {
            if (i == -1) continue;
            pos = i + 1;
            ++i;
        }
        String decodedName = ImapParser.parseFolderName(folderPath.substring(pos));
        FolderTreeItem item = new FolderTreeItem(parent, decodedName, folderPath, this.folderDelim, canSelect, canSelect);
        item.setMsgCount(0);
        return item;
    }

    private String getMessageBody(int uid, String address) throws IOException, MailException {
        if (this.activeMailbox.equals("")) {
            throw new MailException("Mailbox not selected");
        }
        return this.imapProtocol.executeFetchBody(uid, address);
    }

    public void deleteMessage(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
        ImapMessageToken imapMessageToken = (ImapMessageToken)messageToken;
        if (!imapMessageToken.getFolderPath().equalsIgnoreCase(this.activeMailbox.getPath())) {
            throw new MailException("Invalid mailbox for message");
        }
        ImapProtocol.MessageFlags updatedFlags = this.imapProtocol.executeStore(imapMessageToken.getMessageUid(), true, new String[]{"\\Deleted"});
        ImapClient.refreshMessageFlags(updatedFlags, messageFlags);
    }

    public void undeleteMessage(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
        ImapMessageToken imapMessageToken = (ImapMessageToken)messageToken;
        if (!imapMessageToken.getFolderPath().equalsIgnoreCase(this.activeMailbox.getPath())) {
            throw new MailException("Invalid mailbox for message");
        }
        ImapProtocol.MessageFlags updatedFlags = this.imapProtocol.executeStore(imapMessageToken.getMessageUid(), false, new String[]{"\\Deleted"});
        ImapClient.refreshMessageFlags(updatedFlags, messageFlags);
    }

    public void messageAnswered(MessageToken messageToken, MessageFlags messageFlags) throws IOException, MailException {
        ImapMessageToken imapMessageToken = (ImapMessageToken)messageToken;
        if (!imapMessageToken.getFolderPath().equalsIgnoreCase(this.activeMailbox.getPath())) {
            throw new MailException("Invalid mailbox for message");
        }
        ImapProtocol.MessageFlags updatedFlags = this.imapProtocol.executeStore(imapMessageToken.getMessageUid(), true, new String[]{"\\Answered"});
        ImapClient.refreshMessageFlags(updatedFlags, messageFlags);
    }

    private static void refreshMessageFlags(ImapProtocol.MessageFlags updatedFlags, MessageFlags messageFlags) {
        if (updatedFlags != null) {
            messageFlags.setAnswered(updatedFlags.answered);
            messageFlags.setDeleted(updatedFlags.deleted);
            messageFlags.setDraft(updatedFlags.draft);
            messageFlags.setFlagged(updatedFlags.draft);
            messageFlags.setRecent(updatedFlags.recent);
            messageFlags.setSeen(updatedFlags.seen);
        }
    }

    public void appendMessage(FolderTreeItem folder, String rawMessage, MessageFlags initialFlags) throws IOException, MailException {
        ImapProtocol.MessageFlags flags = new ImapProtocol.MessageFlags();
        flags.seen = initialFlags.isSeen();
        flags.answered = initialFlags.isAnswered();
        flags.flagged = initialFlags.isFlagged();
        flags.deleted = initialFlags.isDeleted();
        flags.draft = initialFlags.isDraft();
        flags.recent = initialFlags.isRecent();
        flags.junk = initialFlags.isJunk();
        this.imapProtocol.executeAppend(folder.getPath(), rawMessage, flags);
    }

    public boolean noop() throws IOException, MailException {
        boolean result = this.imapProtocol.executeNoop();
        return result;
    }

    public void idleModeBegin() throws IOException, MailException {
        this.imapProtocol.executeIdle();
    }

    public void idleModeEnd() throws IOException, MailException {
        this.imapProtocol.executeIdleDone();
    }

    public boolean idleModePoll() throws IOException, MailException {
        return this.imapProtocol.executeIdlePoll();
    }
}

