/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.imap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class ImapMessageToken
implements MessageToken {
    private long uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
    private int hashCode = -1;
    private String folderPath;
    private int messageUid;

    public ImapMessageToken() {
    }

    ImapMessageToken(String folderPath, int messageUid) {
        this();
        this.folderPath = folderPath;
        this.messageUid = messageUid;
    }

    public boolean containedWithin(FolderTreeItem folderTreeItem) {
        return this.folderPath != null && this.folderPath.equals(folderTreeItem.getPath());
    }

    String getFolderPath() {
        return this.folderPath;
    }

    int getMessageUid() {
        return this.messageUid;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        output.writeUTF(this.folderPath);
        output.writeInt(this.messageUid);
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.uniqueId = input.readLong();
        this.folderPath = input.readUTF();
        this.messageUid = input.readInt();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImapMessageToken) {
            ImapMessageToken rhs = (ImapMessageToken)obj;
            return this.folderPath.equals(rhs.folderPath) && this.messageUid == rhs.messageUid;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int hash = 7;
            hash = 31 * hash + (this.folderPath == null ? 0 : this.folderPath.hashCode());
            this.hashCode = hash = 31 * hash + this.messageUid;
        }
        return this.hashCode;
    }
}

