/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.util.Vector;
import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartVisitor;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;

public class MessagePartTransformer {
    public static MessagePart[] getDisplayableParts(MessagePart rootPart) {
        DisplayablePartVisitor visitor = new DisplayablePartVisitor();
        rootPart.accept(visitor);
        Vector parts = visitor.getDisplayableParts();
        Object[] result = new MessagePart[parts.size()];
        parts.copyInto(result);
        return result;
    }

    public static MessagePart[] getAttachmentParts(MessagePart rootPart) {
        AttachmentPartVisitor visitor = new AttachmentPartVisitor();
        rootPart.accept(visitor);
        Vector parts = visitor.getAttachmentParts();
        Object[] result = new MessagePart[parts.size()];
        parts.copyInto(result);
        return result;
    }

    private static class AttachmentPartVisitor
    implements MessagePartVisitor {
        private Vector attachmentParts = new Vector();

        private AttachmentPartVisitor() {
        }

        public Vector getAttachmentParts() {
            return this.attachmentParts;
        }

        public void visitTextPart(TextPart part) {
            String subtype = part.getMimeSubtype();
            if (!subtype.equalsIgnoreCase("plain") && !subtype.equalsIgnoreCase("html")) {
                this.attachmentParts.addElement(part);
            }
        }

        public void visitImagePart(ImagePart part) {
            this.attachmentParts.addElement(part);
        }

        public void visitUnsupportedPart(UnsupportedPart part) {
        }

        public void visitMultiPart(MultiPart part) {
        }
    }

    private static class DisplayablePartVisitor
    implements MessagePartVisitor {
        private Vector displayableParts = new Vector();

        private DisplayablePartVisitor() {
        }

        public Vector getDisplayableParts() {
            return this.displayableParts;
        }

        public void visitTextPart(TextPart part) {
            this.displayableParts.addElement(part);
        }

        public void visitImagePart(ImagePart part) {
            this.displayableParts.addElement(part);
        }

        public void visitUnsupportedPart(UnsupportedPart part) {
        }

        public void visitMultiPart(MultiPart part) {
        }
    }
}

