/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.model;

import java.util.Vector;
import org.logicprobe.LogicMail.mail.MailFactory;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.Node;
import org.logicprobe.LogicMail.model.NodeVisitor;

public class MailRootNode
implements Node {
    private Vector accounts = new Vector();
    private AccountNode[] accountsArray;
    private AccountNode localAccountNode = new AccountNode(MailFactory.createLocalMailStore());

    public MailRootNode() {
        this.accounts.addElement(this.localAccountNode);
    }

    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountNode[] getAccounts() {
        Vector vector = this.accounts;
        synchronized (vector) {
            if (this.accountsArray == null) {
                int size = this.accounts.size();
                this.accountsArray = new AccountNode[size];
                for (int i = 0; i < size; ++i) {
                    this.accountsArray[i] = (AccountNode)this.accounts.elementAt(i);
                }
            }
        }
        return this.accountsArray;
    }

    public AccountNode getLocalAccount() {
        return this.localAccountNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAccount(AccountNode account) {
        Vector vector = this.accounts;
        synchronized (vector) {
            if (!this.accounts.contains(account)) {
                this.accounts.addElement(account);
                this.accountsArray = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAccount(AccountNode account) {
        Vector vector = this.accounts;
        synchronized (vector) {
            if (this.accounts.contains(account)) {
                this.accounts.removeElement(account);
                this.accountsArray = null;
            }
        }
    }
}

