/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.system.Display;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.Manager;

public class BorderedFieldManager
extends Manager {
    private static int borderWidth = 4;
    public static long BOTTOM_BORDER_NORMAL = 0L;
    public static long BOTTOM_BORDER_NONE = 32L;
    public static long BOTTOM_BORDER_LINE = 64L;
    private boolean bottomBorderNone;
    private boolean bottomBorderLine;

    public BorderedFieldManager() {
        super(0xA000000000000L | BOTTOM_BORDER_NORMAL);
        long style = this.getStyle();
        this.bottomBorderNone = (style & BOTTOM_BORDER_NONE) == BOTTOM_BORDER_NONE;
        this.bottomBorderLine = (style & BOTTOM_BORDER_LINE) == BOTTOM_BORDER_LINE;
    }

    public BorderedFieldManager(long style) {
        super(style);
        this.bottomBorderNone = (style & BOTTOM_BORDER_NONE) == BOTTOM_BORDER_NONE;
        this.bottomBorderLine = (style & BOTTOM_BORDER_LINE) == BOTTOM_BORDER_LINE;
    }

    protected void paint(Graphics graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        int foregroundColor = graphics.getColor();
        int backgroundColor = graphics.getBackgroundColor();
        graphics.setColor(0xD3D3D3);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(backgroundColor);
        graphics.fillRoundRect(borderWidth, borderWidth, width - borderWidth * 2, height - (this.bottomBorderNone ? borderWidth : borderWidth * 2), 10, 10);
        graphics.setColor(0xA9A9A9);
        graphics.drawRoundRect(borderWidth, borderWidth, width - borderWidth * 2, height - (this.bottomBorderNone ? borderWidth : borderWidth * 2), 10, 10);
        if (this.bottomBorderLine) {
            graphics.drawLine(0, height - 1, width - 1, height - 1);
        }
        graphics.setColor(foregroundColor);
        super.paint(graphics);
    }

    protected void sublayout(int maxWidth, int maxHeight) {
        int count = this.getFieldCount();
        int y = borderWidth;
        for (int i = 0; i < count; ++i) {
            Field field = this.getField(i);
            this.setPositionChild(field, 8, y += 2);
            this.layoutChild(field, maxWidth - borderWidth * 2 - 6, this.getPreferredHeightOfChild(field));
            y += field.getHeight();
        }
        this.setExtent(maxWidth, this.getPreferredHeight());
    }

    public int getPreferredWidth() {
        return Display.getWidth();
    }

    public int getPreferredHeight() {
        int sum = this.bottomBorderNone ? borderWidth : borderWidth * 2;
        int count = this.getFieldCount();
        for (int i = 0; i < count; ++i) {
            sum += 2;
            sum += this.getField(i).getHeight();
        }
        return sum += 2;
    }
}

