/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Hashtable;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.TreeField;
import net.rim.device.api.ui.component.TreeFieldCallback;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.IdentityConfig;
import org.logicprobe.LogicMail.conf.ImapConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.conf.PopConfig;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.ui.AccountConfigWizard;
import org.logicprobe.LogicMail.ui.AcctCfgScreen;
import org.logicprobe.LogicMail.ui.BaseCfgScreen;
import org.logicprobe.LogicMail.ui.GlobalConfigScreen;
import org.logicprobe.LogicMail.ui.IdentityConfigScreen;
import org.logicprobe.LogicMail.ui.OutgoingConfigScreen;

public class ConfigScreen
extends BaseCfgScreen {
    private MailSettings mailSettings;
    private TreeField configTreeField;
    private int globalId;
    private int identitiesId;
    private int accountsId;
    private int outgoingId;
    private Hashtable identityIndexMap;
    private Hashtable accountIndexMap;
    private Hashtable outgoingIndexMap;
    private boolean configurationChanged;
    private MenuItem selectItem = new MenuItem(BaseCfgScreen.resources.getString(12), 100, 10){

        public void run() {
            ConfigScreen.this.openSelectedNode();
        }
    };
    private MenuItem newAccountWizardItem = new MenuItem(BaseCfgScreen.resources.getString(109), 110, 10){

        public void run() {
            ConfigScreen.this.newAccountWizard();
        }
    };
    private MenuItem addIdentityItem = new MenuItem(BaseCfgScreen.resources.getString(13), 120, 10){

        public void run() {
            ConfigScreen.this.addIdentity();
        }
    };
    private MenuItem deleteIdentityItem = new MenuItem(BaseCfgScreen.resources.getString(14), 130, 10){

        public void run() {
            ConfigScreen.this.deleteSelectedIdentity();
        }
    };
    private MenuItem addAccountItem = new MenuItem(BaseCfgScreen.resources.getString(15), 120, 10){

        public void run() {
            ConfigScreen.this.addAccount();
        }
    };
    private MenuItem deleteAccountItem = new MenuItem(BaseCfgScreen.resources.getString(16), 130, 10){

        public void run() {
            ConfigScreen.this.deleteSelectedAccount();
        }
    };
    private MenuItem addOutgoingItem = new MenuItem(BaseCfgScreen.resources.getString(17), 120, 10){

        public void run() {
            ConfigScreen.this.addOutgoingServer();
        }
    };
    private MenuItem deleteOutgoingItem = new MenuItem(BaseCfgScreen.resources.getString(18), 130, 10){

        public void run() {
            ConfigScreen.this.deleteSelectedOutgoingServer();
        }
    };

    public ConfigScreen() {
        super("LogicMail - " + BaseCfgScreen.resources.getString(20));
        this.mailSettings = MailSettings.getInstance();
        this.identityIndexMap = new Hashtable();
        this.accountIndexMap = new Hashtable();
        this.outgoingIndexMap = new Hashtable();
        this.initFields();
        this.buildAccountsList();
    }

    private void initFields() {
        this.configTreeField = new TreeField(new TreeFieldCallback(){

            public void drawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
                ConfigScreen.this.configTreeFieldDrawTreeItem(treeField, graphics, node, y, width, indent);
            }
        }, 0x40000000000000L);
        this.configTreeField.setDefaultExpanded(true);
        this.configTreeField.setIndentWidth(20);
        this.globalId = this.configTreeField.addChildNode(0, (Object)BaseCfgScreen.resources.getString(8));
        this.identitiesId = this.configTreeField.addSiblingNode(this.globalId, (Object)BaseCfgScreen.resources.getString(9));
        this.accountsId = this.configTreeField.addSiblingNode(this.identitiesId, (Object)BaseCfgScreen.resources.getString(10));
        this.outgoingId = this.configTreeField.addSiblingNode(this.accountsId, (Object)BaseCfgScreen.resources.getString(11));
        this.add((Field)this.configTreeField);
    }

    protected void onDisplay() {
        this.configurationChanged = false;
        super.onDisplay();
    }

    protected void onUndisplay() {
        if (this.configurationChanged) {
            this.configurationChanged = false;
        }
        super.onUndisplay();
    }

    public void configTreeFieldDrawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
        Object cookie = treeField.getCookie(node);
        graphics.drawText(cookie.toString(), indent, y, 64, width);
    }

    protected void makeMenu(Menu menu, int instance) {
        int id = this.configTreeField.getCurrentNode();
        if (id != this.identitiesId && id != this.accountsId && id != this.outgoingId) {
            menu.add(this.selectItem);
        }
        if (id == this.identitiesId) {
            menu.add(this.addIdentityItem);
        } else if (this.configTreeField.getCookie(id) instanceof IdentityConfig) {
            menu.add(this.addIdentityItem);
            menu.add(this.deleteIdentityItem);
        } else if (id == this.accountsId) {
            menu.add(this.newAccountWizardItem);
            menu.add(this.addAccountItem);
        } else if (this.configTreeField.getCookie(id) instanceof AccountConfig) {
            menu.add(this.newAccountWizardItem);
            menu.add(this.addAccountItem);
            menu.add(this.deleteAccountItem);
        } else if (id == this.outgoingId) {
            menu.add(this.addOutgoingItem);
        } else if (this.configTreeField.getCookie(id) instanceof OutgoingConfig) {
            menu.add(this.addOutgoingItem);
            menu.add(this.deleteOutgoingItem);
        }
        super.makeMenu(menu, instance);
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case ' ': {
                this.toggleSelectedNode();
                retval = true;
                break;
            }
            case '\n': {
                this.openSelectedNode();
                retval = true;
            }
        }
        return retval;
    }

    protected boolean onClick() {
        return this.openSelectedNode();
    }

    private void toggleSelectedNode() {
        int curNode = this.configTreeField.getCurrentNode();
        if (curNode == -1) {
            return;
        }
        if (this.configTreeField.getFirstChild(curNode) == -1) {
            return;
        }
        this.configTreeField.setExpanded(curNode, !this.configTreeField.getExpanded(curNode));
    }

    private boolean openSelectedNode() {
        boolean result = false;
        int curNode = this.configTreeField.getCurrentNode();
        if (curNode == this.globalId) {
            UiApplication.getUiApplication().pushScreen((Screen)new GlobalConfigScreen());
            result = true;
        } else {
            int parentNode = this.configTreeField.getParent(curNode);
            if (parentNode == this.identitiesId) {
                IdentityConfig identityConfig = (IdentityConfig)this.configTreeField.getCookie(curNode);
                IdentityConfigScreen identityConfigScreen = new IdentityConfigScreen(identityConfig);
                UiApplication.getUiApplication().pushModalScreen((Screen)identityConfigScreen);
                if (identityConfigScreen.configSaved()) {
                    this.mailSettings.saveSettings();
                    this.configurationChanged = true;
                }
                result = true;
            } else if (parentNode == this.accountsId) {
                AccountConfig acctConfig = (AccountConfig)this.configTreeField.getCookie(curNode);
                AcctCfgScreen acctCfgScreen = new AcctCfgScreen(acctConfig);
                UiApplication.getUiApplication().pushModalScreen((Screen)acctCfgScreen);
                if (acctCfgScreen.acctSaved()) {
                    this.mailSettings.saveSettings();
                    this.configurationChanged = true;
                }
                result = true;
            } else if (parentNode == this.outgoingId) {
                OutgoingConfig outgoingConfig = (OutgoingConfig)this.configTreeField.getCookie(curNode);
                OutgoingConfigScreen outgoingConfigScreen = new OutgoingConfigScreen(outgoingConfig);
                UiApplication.getUiApplication().pushModalScreen((Screen)outgoingConfigScreen);
                if (outgoingConfigScreen.acctSaved()) {
                    this.mailSettings.saveSettings();
                    this.configurationChanged = true;
                }
                result = true;
            }
        }
        if (result) {
            this.buildAccountsList();
        }
        return result;
    }

    private void buildAccountsList() {
        int id;
        int numIdentities = this.mailSettings.getNumIdentities();
        this.identityIndexMap.clear();
        int numAccounts = this.mailSettings.getNumAccounts();
        this.accountIndexMap.clear();
        int numOutgoing = this.mailSettings.getNumOutgoing();
        this.outgoingIndexMap.clear();
        while ((id = this.configTreeField.getFirstChild(this.identitiesId)) != -1) {
            this.configTreeField.deleteSubtree(id);
        }
        while ((id = this.configTreeField.getFirstChild(this.accountsId)) != -1) {
            this.configTreeField.deleteSubtree(id);
        }
        while ((id = this.configTreeField.getFirstChild(this.outgoingId)) != -1) {
            this.configTreeField.deleteSubtree(id);
        }
        for (int i = numIdentities - 1; i >= 0; --i) {
            IdentityConfig identityConfig = this.mailSettings.getIdentityConfig(i);
            this.configTreeField.addChildNode(this.identitiesId, (Object)identityConfig);
            this.identityIndexMap.put(identityConfig, new Integer(i));
        }
        for (int i = numAccounts - 1; i >= 0; --i) {
            AccountConfig acctConfig = this.mailSettings.getAccountConfig(i);
            this.configTreeField.addChildNode(this.accountsId, (Object)acctConfig);
            this.accountIndexMap.put(acctConfig, new Integer(i));
        }
        for (int i = numOutgoing - 1; i >= 0; --i) {
            OutgoingConfig outgoingConfig = this.mailSettings.getOutgoingConfig(i);
            this.configTreeField.addChildNode(this.outgoingId, (Object)outgoingConfig);
            this.outgoingIndexMap.put(outgoingConfig, new Integer(i));
        }
    }

    private void newAccountWizard() {
        AccountConfigWizard wizard = new AccountConfigWizard();
        if (wizard.start()) {
            AccountConfig newAccountConfig = wizard.getAccountConfig();
            AccountNode[] accounts = MailManager.getInstance().getMailRootNode().getAccounts();
            for (int i = 0; i < accounts.length; ++i) {
                if (accounts[i].getAccountConfig() != newAccountConfig) continue;
                if (!accounts[i].hasFolders()) break;
                accounts[i].refreshMailboxes();
                break;
            }
        }
    }

    private void addIdentity() {
        IdentityConfig identityConfig = new IdentityConfig();
        IdentityConfigScreen identityConfigScreen = new IdentityConfigScreen(identityConfig);
        UiApplication.getUiApplication().pushModalScreen((Screen)identityConfigScreen);
        if (identityConfigScreen.configSaved()) {
            this.mailSettings.addIdentityConfig(identityConfig);
            this.mailSettings.saveSettings();
            this.configurationChanged = true;
            this.buildAccountsList();
        }
    }

    private void deleteSelectedIdentity() {
        IdentityConfig identityConfig = (IdentityConfig)this.configTreeField.getCookie(this.configTreeField.getCurrentNode());
        int index = (Integer)this.identityIndexMap.get(identityConfig);
        int response = Dialog.ask((int)2);
        if (response == 3) {
            this.mailSettings.removeIdentityConfig(index);
            this.mailSettings.saveSettings();
            this.configurationChanged = true;
            this.configTreeField.deleteSubtree(this.configTreeField.getCurrentNode());
            this.identityIndexMap.remove(identityConfig);
            this.buildAccountsList();
        }
    }

    private void addAccount() {
        int response = Dialog.ask((String)BaseCfgScreen.resources.getString(19), (Object[])new String[]{"IMAP", "POP"}, (int)0);
        if (response != -1) {
            AccountConfig acctConfig = response == 0 ? new ImapConfig() : new PopConfig();
            AcctCfgScreen acctCfgScreen = new AcctCfgScreen(acctConfig);
            UiApplication.getUiApplication().pushModalScreen((Screen)acctCfgScreen);
            if (acctCfgScreen.acctSaved()) {
                this.mailSettings.addAccountConfig(acctConfig);
                this.mailSettings.saveSettings();
                this.configurationChanged = true;
                this.buildAccountsList();
            }
        }
    }

    private void deleteSelectedAccount() {
        AccountConfig acctConfig = (AccountConfig)this.configTreeField.getCookie(this.configTreeField.getCurrentNode());
        int index = (Integer)this.accountIndexMap.get(acctConfig);
        int response = Dialog.ask((int)2);
        if (response == 3) {
            this.mailSettings.removeAccountConfig(index);
            this.mailSettings.saveSettings();
            this.configurationChanged = true;
            this.configTreeField.deleteSubtree(this.configTreeField.getCurrentNode());
            this.accountIndexMap.remove(acctConfig);
            this.buildAccountsList();
        }
    }

    private void addOutgoingServer() {
        OutgoingConfig outgoingConfig = new OutgoingConfig();
        OutgoingConfigScreen outgoingConfigScreen = new OutgoingConfigScreen(outgoingConfig);
        UiApplication.getUiApplication().pushModalScreen((Screen)outgoingConfigScreen);
        if (outgoingConfigScreen.acctSaved()) {
            this.mailSettings.addOutgoingConfig(outgoingConfig);
            this.mailSettings.saveSettings();
            this.configurationChanged = true;
            this.buildAccountsList();
        }
    }

    private void deleteSelectedOutgoingServer() {
        OutgoingConfig outgoingConfig = (OutgoingConfig)this.configTreeField.getCookie(this.configTreeField.getCurrentNode());
        int index = (Integer)this.outgoingIndexMap.get(outgoingConfig);
        int response = Dialog.ask((int)2);
        if (response == 3) {
            this.mailSettings.removeOutgoingConfig(index);
            this.mailSettings.saveSettings();
            this.configurationChanged = true;
            this.configTreeField.deleteSubtree(this.configTreeField.getCurrentNode());
            this.outgoingIndexMap.remove(outgoingConfig);
            this.buildAccountsList();
        }
    }
}

