/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.FileSystemRegistry;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.text.TextFilter;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.ui.BaseCfgScreen;

public class GlobalConfigScreen
extends BaseCfgScreen
implements FieldChangeListener {
    private MailSettings mailSettings = MailSettings.getInstance();
    private GlobalConfig existingConfig = this.mailSettings.getGlobalConfig();
    private String localHostname = this.existingConfig.getLocalHostname();
    private String[] fileSystemRoots;
    private int selectedFileSystemRootIndex;
    private static String LOCAL_FILE_BASE = "LogicMail/";
    private RichTextField globalSettingsLabel;
    private BasicEditField messageCountEditField;
    private ObjectChoiceField displayOrderChoiceField;
    private CheckboxField hideDeletedMessagesCheckboxField;
    private ObjectChoiceField wifiModeChoiceField;
    private ObjectChoiceField localDataLocationChoiceLabel;
    private CheckboxField connectionDebuggingCheckboxField;
    private CheckboxField overrideHostnameCheckboxField;
    private BasicEditField localHostnameEditField;

    public GlobalConfigScreen() {
        super("LogicMail - " + BaseCfgScreen.resources.getString(39));
        Vector<String> resultsVector = new Vector<String>();
        String selectedFileSystemRoot = this.existingConfig.getLocalDataLocation();
        int i = 0;
        this.selectedFileSystemRootIndex = 0;
        Enumeration e = FileSystemRegistry.listRoots();
        while (e.hasMoreElements()) {
            String root = (String)e.nextElement();
            if (selectedFileSystemRoot.endsWith(root + LOCAL_FILE_BASE)) {
                this.selectedFileSystemRootIndex = i;
            }
            resultsVector.addElement(root);
            ++i;
        }
        this.fileSystemRoots = new String[resultsVector.size()];
        resultsVector.copyInto(this.fileSystemRoots);
        this.initFields();
    }

    private void initFields() {
        this.globalSettingsLabel = new RichTextField(BaseCfgScreen.resources.getString(40), 0x80000000000000L);
        this.messageCountEditField = new BasicEditField("  " + BaseCfgScreen.resources.getString(41) + ' ', Integer.toString(this.existingConfig.getRetMsgCount()));
        this.messageCountEditField.setFilter(TextFilter.get((int)1));
        Object[] orderTypes = new String[]{BaseCfgScreen.resources.getString(43), BaseCfgScreen.resources.getString(44)};
        this.displayOrderChoiceField = this.existingConfig.getDispOrder() ? new ObjectChoiceField("  " + BaseCfgScreen.resources.getString(42) + ' ', orderTypes, 0) : new ObjectChoiceField("  " + BaseCfgScreen.resources.getString(42) + ' ', orderTypes, 1);
        this.hideDeletedMessagesCheckboxField = new CheckboxField(BaseCfgScreen.resources.getString(45), this.existingConfig.getHideDeletedMsg());
        Object[] wifiModes = new String[]{BaseCfgScreen.resources.getString(46), BaseCfgScreen.resources.getString(47), BaseCfgScreen.resources.getString(48)};
        this.wifiModeChoiceField = new ObjectChoiceField("  " + BaseCfgScreen.resources.getString(49) + ' ', wifiModes, this.existingConfig.getWifiMode());
        this.localDataLocationChoiceLabel = new ObjectChoiceField(BaseCfgScreen.resources.getString(96) + ' ', (Object[])this.fileSystemRoots, this.selectedFileSystemRootIndex);
        boolean overrideHostname = this.localHostname.length() > 0;
        this.overrideHostnameCheckboxField = new CheckboxField(BaseCfgScreen.resources.getString(89), overrideHostname);
        this.overrideHostnameCheckboxField.setChangeListener((FieldChangeListener)this);
        if (overrideHostname) {
            this.localHostnameEditField = new BasicEditField("  " + BaseCfgScreen.resources.getString(90) + ' ', this.localHostname);
        } else {
            String hostname = System.getProperty("microedition.hostname");
            this.localHostnameEditField = new BasicEditField("  " + BaseCfgScreen.resources.getString(90) + ' ', hostname != null ? hostname : "localhost");
            this.localHostnameEditField.setEditable(false);
        }
        this.connectionDebuggingCheckboxField = new CheckboxField(BaseCfgScreen.resources.getString(55), this.existingConfig.getConnDebug());
        this.add((Field)this.globalSettingsLabel);
        this.add((Field)this.messageCountEditField);
        this.add((Field)this.displayOrderChoiceField);
        this.add((Field)this.hideDeletedMessagesCheckboxField);
        this.add((Field)this.wifiModeChoiceField);
        this.add((Field)this.localDataLocationChoiceLabel);
        this.add((Field)this.overrideHostnameCheckboxField);
        this.add((Field)this.localHostnameEditField);
        this.add((Field)this.connectionDebuggingCheckboxField);
    }

    public void fieldChanged(Field field, int context) {
        if (field == this.overrideHostnameCheckboxField) {
            if (this.overrideHostnameCheckboxField.getChecked()) {
                this.localHostnameEditField.setText(this.localHostname);
                this.localHostnameEditField.setEditable(true);
            } else {
                String hostname = System.getProperty("microedition.hostname");
                this.localHostnameEditField.setText(hostname != null ? hostname : "localhost");
                this.localHostnameEditField.setEditable(false);
            }
        }
    }

    public void save() {
        GlobalConfig config = this.mailSettings.getGlobalConfig();
        try {
            config.setRetMsgCount(Integer.parseInt(this.messageCountEditField.getText()));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.displayOrderChoiceField.getSelectedIndex() == 0) {
            config.setDispOrder(true);
        } else {
            config.setDispOrder(false);
        }
        config.setHideDeletedMsg(this.hideDeletedMessagesCheckboxField.getChecked());
        config.setWifiMode(this.wifiModeChoiceField.getSelectedIndex());
        String url = "file:///" + this.fileSystemRoots[this.localDataLocationChoiceLabel.getSelectedIndex()] + LOCAL_FILE_BASE;
        config.setLocalDataLocation(url);
        if (this.overrideHostnameCheckboxField.getChecked()) {
            config.setLocalHostname(this.localHostnameEditField.getText().trim());
        } else {
            config.setLocalHostname("");
        }
        config.setConnDebug(this.connectionDebuggingCheckboxField.getChecked());
        this.mailSettings.saveSettings();
    }
}

