/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Hashtable;
import java.util.Vector;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.util.Comparator;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MailboxNodeEvent;
import org.logicprobe.LogicMail.model.MailboxNodeListener;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.model.MessageNodeEvent;
import org.logicprobe.LogicMail.model.MessageNodeListener;
import org.logicprobe.LogicMail.ui.BaseScreen;
import org.logicprobe.LogicMail.ui.MailboxMessageField;
import org.logicprobe.LogicMail.ui.MessagePropertiesScreen;
import org.logicprobe.LogicMail.ui.NavigationController;
import org.logicprobe.LogicMail.util.EventObjectRunnable;

public class MailboxScreen
extends BaseScreen {
    private MailboxNode mailboxNode;
    private Vector knownMessages;
    private Hashtable messageFieldMap;
    private boolean firstDisplay = true;
    private MailSettings mailSettings;
    private VerticalFieldManager messageFieldManager;
    private MailboxNodeListener mailboxNodeListener = new MailboxNodeListener(){

        public void mailboxStatusChanged(MailboxNodeEvent e) {
            UiApplication.getUiApplication().invokeLater((Runnable)new EventObjectRunnable(e){

                public void run() {
                    MailboxScreen.this.mailboxNode_MailboxStatusChanged((MailboxNodeEvent)this.getEvent());
                }
            });
        }
    };
    private MessageNodeListener messageNodeListener = new MessageNodeListener(){

        public void messageStatusChanged(MessageNodeEvent e) {
            UiApplication.getUiApplication().invokeLater((Runnable)new EventObjectRunnable(e){

                public void run() {
                    MailboxScreen.this.messageNode_MessageStatusChanged((MessageNodeEvent)this.getEvent());
                }
            });
        }
    };
    private MenuItem selectItem = new MenuItem(BaseScreen.resources, 66, 100, 10){

        public void run() {
            MailboxScreen.this.openSelectedMessage();
        }
    };
    private MenuItem propertiesItem = new MenuItem(BaseScreen.resources, 70, 105, 10){

        public void run() {
            MailboxScreen.this.openSelectedMessageProperties();
        }
    };
    private MenuItem compositionItem = new MenuItem(BaseScreen.resources, 73, 120, 10){

        public void run() {
            MailboxScreen.this.getNavigationController().displayComposition(MailboxScreen.this.mailboxNode.getParentAccount());
        }
    };
    private MenuItem deleteItem = new MenuItem(BaseScreen.resources, 71, 130, 10){

        public void run() {
            MailboxScreen.this.deleteSelectedMessage();
        }
    };
    private MenuItem undeleteItem = new MenuItem(BaseScreen.resources, 72, 135, 10){

        public void run() {
            MailboxScreen.this.undeleteSelectedMessage();
        }
    };

    public MailboxScreen(NavigationController navigationController, MailboxNode mailboxNode) {
        super(navigationController, mailboxNode.toString());
        this.mailboxNode = mailboxNode;
        this.knownMessages = new Vector();
        this.messageFieldMap = new Hashtable();
        this.mailSettings = MailSettings.getInstance();
        this.initFields();
    }

    public MailboxNode getMailboxNode() {
        return this.mailboxNode;
    }

    protected void onDisplay() {
        int i;
        super.onDisplay();
        this.mailboxNode.addMailboxNodeListener(this.mailboxNodeListener);
        if (this.firstDisplay) {
            MessageNode[] initialMessages = this.mailboxNode.getMessages();
            for (i = 0; i < initialMessages.length; ++i) {
                this.knownMessages.addElement(initialMessages[i]);
                if (!this.isMessageDisplayable(initialMessages[i])) continue;
                this.insertDisplayableMessage(initialMessages[i]);
            }
            this.mailboxNode.refreshMessages();
            this.firstDisplay = false;
        }
        int size = this.knownMessages.size();
        for (i = 0; i < size; ++i) {
            ((MessageNode)this.knownMessages.elementAt(i)).addMessageNodeListener(this.messageNodeListener);
        }
    }

    protected void onUndisplay() {
        this.mailboxNode.removeMailboxNodeListener(this.mailboxNodeListener);
        int size = this.knownMessages.size();
        for (int i = 0; i < size; ++i) {
            ((MessageNode)this.knownMessages.elementAt(i)).removeMessageNodeListener(this.messageNodeListener);
        }
        super.onUndisplay();
    }

    private void initFields() {
        this.messageFieldManager = new VerticalFieldManager(0x3000000000000000L);
        this.add((Field)this.messageFieldManager);
    }

    protected boolean onSavePrompt() {
        return true;
    }

    protected void makeMenu(Menu menu, int instance) {
        Field fieldWithFocus = this.messageFieldManager.getFieldWithFocus();
        if (fieldWithFocus instanceof MailboxMessageField) {
            menu.add(this.selectItem);
            menu.add(this.propertiesItem);
        }
        if (this.mailboxNode.getParentAccount().hasMailSender()) {
            menu.add(this.compositionItem);
        }
        if (fieldWithFocus instanceof MailboxMessageField) {
            MessageNode messageNode = ((MailboxMessageField)fieldWithFocus).getMessageNode();
            if ((messageNode.getFlags() & 8) != 0) {
                if (this.mailboxNode.getParentAccount().hasUndelete()) {
                    menu.add(this.undeleteItem);
                }
            } else {
                menu.add(this.deleteItem);
            }
        }
        super.makeMenu(menu, instance);
    }

    private void mailboxNode_MailboxStatusChanged(MailboxNodeEvent e) {
        if (e.getType() == 1) {
            MessageNode[] messageNodes = e.getAffectedMessages();
            for (int i = 0; i < messageNodes.length; ++i) {
                this.knownMessages.addElement(messageNodes[i]);
                if (this.isMessageDisplayable(messageNodes[i])) {
                    this.insertDisplayableMessage(messageNodes[i]);
                }
                if (!this.isDisplayed()) continue;
                messageNodes[i].addMessageNodeListener(this.messageNodeListener);
            }
        }
    }

    private boolean isMessageDisplayable(MessageNode messageNode) {
        return (messageNode.getFlags() & 8) == 0 || !this.mailSettings.getGlobalConfig().getHideDeletedMsg();
    }

    private void insertDisplayableMessage(MessageNode messageNode) {
        int selectedIndex = this.messageFieldManager.getFieldWithFocusIndex();
        if (this.messageFieldManager.getFieldCount() > 0) {
            MessageNode lastMessage;
            Comparator comparator = MessageNode.getComparator();
            int index = this.messageFieldManager.getFieldCount();
            if (this.mailSettings.getGlobalConfig().getDispOrder()) {
                lastMessage = this.getLastDisplayedMessage(index - 1);
                while (lastMessage != null && index > 0 && comparator.compare((Object)lastMessage, (Object)messageNode) >= 0) {
                    if (--index <= 0) continue;
                    lastMessage = this.getLastDisplayedMessage(index - 1);
                }
            } else {
                lastMessage = this.getLastDisplayedMessage(index - 1);
                while (lastMessage != null && index > 0 && comparator.compare((Object)lastMessage, (Object)messageNode) <= 0) {
                    if (--index <= 0) continue;
                    lastMessage = this.getLastDisplayedMessage(index - 1);
                }
            }
            MailboxMessageField mailboxMessageField = new MailboxMessageField(this.mailboxNode, messageNode, 0x1040000000000000L);
            this.messageFieldMap.put(messageNode, mailboxMessageField);
            this.messageFieldManager.insert((Field)mailboxMessageField, index);
            if (selectedIndex != -1) {
                this.messageFieldManager.getField(selectedIndex).setFocus();
            }
        } else {
            MailboxMessageField mailboxMessageField = new MailboxMessageField(this.mailboxNode, messageNode, 0x1040000000000000L);
            this.messageFieldMap.put(messageNode, mailboxMessageField);
            this.messageFieldManager.insert((Field)mailboxMessageField, 0);
            if (selectedIndex != -1) {
                this.messageFieldManager.getField(selectedIndex).setFocus();
            }
        }
    }

    private MessageNode getLastDisplayedMessage(int index) {
        while (index >= 0) {
            if (this.messageFieldManager.getField(index) instanceof MailboxMessageField) {
                return ((MailboxMessageField)this.messageFieldManager.getField(index)).getMessageNode();
            }
            --index;
        }
        return null;
    }

    private void messageNode_MessageStatusChanged(MessageNodeEvent e) {
        if (e.getType() == 2) {
            MessageNode messageNode = (MessageNode)e.getSource();
            boolean currentlyDisplayed = this.messageFieldMap.containsKey(messageNode);
            boolean displayable = this.isMessageDisplayable(messageNode);
            if (currentlyDisplayed && !displayable) {
                MailboxMessageField mailboxMessageField = (MailboxMessageField)((Object)this.messageFieldMap.get(messageNode));
                this.messageFieldManager.delete((Field)mailboxMessageField);
                this.messageFieldMap.remove(messageNode);
            } else if (!currentlyDisplayed && displayable) {
                this.insertDisplayableMessage(messageNode);
            } else if (currentlyDisplayed) {
                MailboxMessageField mailboxMessageField = (MailboxMessageField)((Object)this.messageFieldMap.get(messageNode));
                mailboxMessageField.invalidate();
            }
        }
    }

    private MessageNode getSelectedMessage() {
        Field fieldWithFocus = this.messageFieldManager.getFieldWithFocus();
        if (fieldWithFocus instanceof MailboxMessageField) {
            return ((MailboxMessageField)fieldWithFocus).getMessageNode();
        }
        return null;
    }

    private boolean openSelectedMessage() {
        MessageNode messageNode = this.getSelectedMessage();
        if (messageNode != null) {
            if (this.mailboxNode.getType() == 3) {
                this.openDraftMessage(messageNode);
            } else {
                this.getNavigationController().displayMessage(messageNode);
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean openDraftMessage(MessageNode messageNode) {
        Object account;
        Vector<AccountNode> matchingAccounts = new Vector<AccountNode>();
        AccountNode[] accounts = MailManager.getInstance().getMailRootNode().getAccounts();
        for (int i = 0; i < accounts.length; ++i) {
            AccountConfig accountConfig = accounts[i].getAccountConfig();
            if (accountConfig == null || accountConfig.getDraftMailbox() != this.mailboxNode) continue;
            matchingAccounts.addElement(accounts[i]);
        }
        int size = matchingAccounts.size();
        if (size > 1) {
            Object[] choices = new AccountNode[size];
            matchingAccounts.copyInto(choices);
            int result = Dialog.ask((String)BaseScreen.resources.getString(108), (Object[])choices, (int)0);
            if (result == -1) return false;
            account = choices[result];
        } else {
            account = (AccountNode)matchingAccounts.elementAt(0);
        }
        this.getNavigationController().displayComposition((AccountNode)account, messageNode);
        return true;
    }

    private void openSelectedMessageProperties() {
        MessageNode messageNode = this.getSelectedMessage();
        if (messageNode != null) {
            MessagePropertiesScreen propertiesScreen = new MessagePropertiesScreen(messageNode);
            UiApplication.getUiApplication().pushModalScreen((Screen)propertiesScreen);
        }
    }

    private boolean deleteSelectedMessage() {
        MessageNode messageNode = this.getSelectedMessage();
        if (messageNode != null) {
            if (Dialog.ask((int)3, (String)BaseScreen.resources.getString(74)) == 4) {
                messageNode.deleteMessage();
            }
            return true;
        }
        return false;
    }

    private void undeleteSelectedMessage() {
        MessageNode messageNode = this.getSelectedMessage();
        if (messageNode != null) {
            messageNode.undeleteMessage();
        }
    }

    protected boolean onClick() {
        return this.openSelectedMessage();
    }

    public boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': {
                retval = this.openSelectedMessage();
                break;
            }
            case '\b': {
                retval = this.deleteSelectedMessage();
            }
        }
        return retval;
    }
}

