/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.Manager;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.TreeField;
import net.rim.device.api.ui.component.TreeFieldCallback;
import net.rim.device.api.ui.container.MainScreen;
import net.rim.device.api.ui.container.VerticalFieldManager;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.model.Address;
import org.logicprobe.LogicMail.model.MessageNode;

public class MessagePropertiesScreen
extends MainScreen {
    protected static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private MessageNode messageNode;
    private ObjectChoiceField sectionChoiceField;
    private VerticalFieldManager generalPageManager;
    private VerticalFieldManager structurePageManager;
    private TreeField structureTreeField;
    private MenuItem closeItem = new MenuItem(resources, 3, 200000, 10){

        public void run() {
            MessagePropertiesScreen.this.onClose();
        }
    };

    public MessagePropertiesScreen(MessageNode messageNode) {
        super(0x1100000000000L);
        this.messageNode = messageNode;
        this.initFields();
    }

    private void initFields() {
        this.sectionChoiceField = new ObjectChoiceField(resources.getString(75) + ':', new Object[]{resources.getString(143), resources.getString(144)});
        this.sectionChoiceField.setSelectedIndex(0);
        this.sectionChoiceField.setChangeListener(new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                MessagePropertiesScreen.this.sectionChoiceField_FieldChanged(field, context);
            }
        });
        this.initGeneralFields();
        this.initStructureFields();
        this.setTitle((Field)this.sectionChoiceField);
        this.add((Field)this.generalPageManager);
    }

    private void initGeneralFields() {
        this.generalPageManager = new VerticalFieldManager();
        this.generalPageManager.add((Field)new LabelField((Object)(resources.getString(76) + ' ' + this.messageNode.getSubject()), 0x40000000000000L));
        this.generalPageManager.add((Field)new LabelField((Object)(resources.getString(77) + ' ' + this.messageNode.getDate()), 0x40000000000000L));
        MessagePropertiesScreen.initFieldAddress((Manager)this.generalPageManager, resources.getString(78), this.messageNode.getFrom());
        MessagePropertiesScreen.initFieldAddress((Manager)this.generalPageManager, resources.getString(79), this.messageNode.getReplyTo());
        MessagePropertiesScreen.initFieldAddress((Manager)this.generalPageManager, resources.getString(80), this.messageNode.getTo());
        MessagePropertiesScreen.initFieldAddress((Manager)this.generalPageManager, resources.getString(81), this.messageNode.getCc());
    }

    private static void initFieldAddress(Manager manager, String prefix, Address[] addresses) {
        if (addresses != null) {
            if (addresses.length == 1) {
                manager.add((Field)new LabelField((Object)(prefix + ' ' + addresses[0]), 0x40000000000000L));
            } else if (addresses.length > 1) {
                manager.add((Field)new LabelField((Object)prefix));
                for (int i = 0; i < addresses.length; ++i) {
                    manager.add((Field)new LabelField((Object)("  " + addresses[i]), 0x40000000000000L));
                }
            }
        }
    }

    private void initStructureFields() {
        this.structurePageManager = new VerticalFieldManager();
        this.structureTreeField = new TreeField(new TreeFieldCallback(){

            public void drawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
                MessagePropertiesScreen.this.structureTreeField_DrawTreeItem(treeField, graphics, node, y, width, indent);
            }
        }, 0x40000000000000L);
        this.structureTreeField.setEmptyString("", 0);
        this.structureTreeField.setDefaultExpanded(true);
        this.structureTreeField.setIndentWidth(20);
        MessagePart rootPart = this.messageNode.getMessageStructure();
        if (rootPart != null) {
            this.populateStructureTreeField(0, rootPart);
        }
        this.structurePageManager.add((Field)this.structureTreeField);
    }

    private void populateStructureTreeField(int id, MessagePart part) {
        int newId = this.structureTreeField.addChildNode(id, (Object)part);
        if (part instanceof MultiPart) {
            MultiPart multiPart = (MultiPart)part;
            MessagePart[] children = multiPart.getParts();
            for (int i = children.length - 1; i >= 0; --i) {
                this.populateStructureTreeField(newId, children[i]);
            }
        }
    }

    protected void makeMenu(Menu menu, int instance) {
        menu.add(this.closeItem);
    }

    protected boolean onSavePrompt() {
        return true;
    }

    private void sectionChoiceField_FieldChanged(Field field, int context) {
        switch (this.sectionChoiceField.getSelectedIndex()) {
            case 0: {
                this.deleteAll();
                this.add((Field)this.generalPageManager);
                break;
            }
            case 1: {
                this.deleteAll();
                this.add((Field)this.structurePageManager);
            }
        }
    }

    private void structureTreeField_DrawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
        StringBuffer buf = new StringBuffer();
        MessagePart part = (MessagePart)this.structureTreeField.getCookie(node);
        buf.append(part.getMimeType());
        buf.append('/');
        buf.append(part.getMimeSubtype());
        int partSize = part.getSize();
        if (partSize > 0) {
            buf.append(" (");
            if (partSize < 1024) {
                buf.append(partSize);
                buf.append('B');
            } else {
                buf.append(partSize /= 1024);
                buf.append("kB");
            }
            buf.append(')');
        }
        graphics.drawText(buf.toString(), indent, y, 64, width);
    }
}

