/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailRootNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.ui.AccountConfigWizard;
import org.logicprobe.LogicMail.ui.CompositionScreen;
import org.logicprobe.LogicMail.ui.MailHomePresenter;
import org.logicprobe.LogicMail.ui.MailHomeScreen;
import org.logicprobe.LogicMail.ui.MailboxScreen;
import org.logicprobe.LogicMail.ui.MessageScreen;

public class NavigationController {
    private MailRootNode mailRootNode;
    private UiApplication uiApplication;
    private MailHomeScreen mailHomeView;
    private MailHomePresenter mailHomePresenter;

    public NavigationController(UiApplication uiApplication) {
        this.uiApplication = uiApplication;
        this.mailRootNode = MailManager.getInstance().getMailRootNode();
    }

    public synchronized void displayMailHome() {
        if (this.mailHomePresenter == null) {
            this.mailHomeView = new MailHomeScreen();
            this.mailHomePresenter = new MailHomePresenter(this, this.mailRootNode, this.mailHomeView);
            this.mailHomePresenter.initialize();
        }
        this.uiApplication.pushScreen((Screen)this.mailHomeView);
    }

    public synchronized void displayAccountConfigurationWizard() {
        UiApplication.getUiApplication().invokeLater(new Runnable(){

            public void run() {
                AccountConfigWizard wizard = new AccountConfigWizard();
                if (wizard.start()) {
                    AccountConfig newAccountConfig = wizard.getAccountConfig();
                    AccountNode[] accounts = NavigationController.this.mailRootNode.getAccounts();
                    for (int i = 0; i < accounts.length; ++i) {
                        if (accounts[i].getAccountConfig() != newAccountConfig) continue;
                        if (!accounts[i].hasFolders()) break;
                        accounts[i].refreshMailboxes();
                        break;
                    }
                }
            }
        });
    }

    public synchronized void displayMailbox(MailboxNode mailboxNode) {
        MailboxScreen screen = new MailboxScreen(this, mailboxNode);
        this.uiApplication.pushScreen((Screen)screen);
    }

    public synchronized void displayMessage(MessageNode messageNode) {
        MessageScreen screen = new MessageScreen(this, messageNode);
        this.uiApplication.pushScreen((Screen)screen);
    }

    public synchronized void displayComposition(AccountNode accountNode) {
        CompositionScreen screen = new CompositionScreen(this, accountNode);
        this.uiApplication.pushScreen((Screen)screen);
    }

    public synchronized void displayComposition(AccountNode accountNode, MessageNode messageNode) {
        CompositionScreen screen = new CompositionScreen(this, accountNode, messageNode, 0);
        this.uiApplication.pushScreen((Screen)screen);
    }

    public synchronized void displayCompositionReply(AccountNode accountNode, MessageNode messageNode, boolean replyAll) {
        CompositionScreen screen = new CompositionScreen(this, accountNode, messageNode, replyAll ? 2 : 1);
        this.uiApplication.pushScreen((Screen)screen);
    }

    public synchronized void displayCompositionForward(AccountNode accountNode, MessageNode messageNode) {
        CompositionScreen screen = new CompositionScreen(this, accountNode, messageNode, 3);
        this.uiApplication.pushScreen((Screen)screen);
    }
}

