/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.util;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import org.logicprobe.LogicMail.util.DataStore;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializableHashtable;
import org.logicprobe.LogicMail.util.SerializationUtils;

public class RmsDataStore
implements DataStore {
    private String storeName;
    private SerializableHashtable nameMap;
    private Hashtable objectMap;

    public RmsDataStore(String storeName) {
        this.storeName = storeName;
        this.objectMap = new Hashtable();
        this.nameMap = new SerializableHashtable();
    }

    public Serializable getNamedObject(String name) {
        Object value = this.nameMap.get(name);
        if (value instanceof Long) {
            value = this.objectMap.get(value);
            return (Serializable)value;
        }
        return null;
    }

    public String[] getNamedObjects() {
        String[] result = new String[this.nameMap.size()];
        Enumeration e = this.nameMap.keys();
        int i = 0;
        while (e.hasMoreElements()) {
            result[i++] = (String)e.nextElement();
        }
        return result;
    }

    public Serializable getObject(long id) {
        return (Serializable)this.objectMap.get(new Long(id));
    }

    public void putNamedObject(String name, Serializable object) {
        this.nameMap.put(name, new Long(object.getUniqueId()));
        this.putObject(object);
    }

    public void putObject(Serializable object) {
        this.objectMap.put(new Long(object.getUniqueId()), object);
    }

    public void removeNamedObject(String name) {
        this.removeObject(this.getNamedObject(name));
        this.nameMap.remove(name);
    }

    public void removeObject(Serializable object) {
        this.objectMap.remove(new Long(object.getUniqueId()));
    }

    public void save() {
        try {
            RecordStore.deleteRecordStore((String)this.storeName);
        }
        catch (RecordStoreException exp) {
            // empty catch block
        }
        try {
            RecordStore store = RecordStore.openRecordStore((String)this.storeName, (boolean)true);
            byte[] byteArray = SerializationUtils.serializeClass(this.nameMap);
            store.addRecord(byteArray, 0, byteArray.length);
            Enumeration e = this.objectMap.elements();
            while (e.hasMoreElements()) {
                byteArray = SerializationUtils.serializeClass((Serializable)e.nextElement());
                store.addRecord(byteArray, 0, byteArray.length);
            }
            store.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void load() {
        try {
            RecordStore store = RecordStore.openRecordStore((String)this.storeName, (boolean)false);
            int records = store.getNumRecords();
            if (records >= 1) {
                Serializable deserializedObject = SerializationUtils.deserializeClass(store.getRecord(1));
                if (!(deserializedObject instanceof SerializableHashtable)) {
                    return;
                }
                this.nameMap = (SerializableHashtable)deserializedObject;
                this.objectMap.clear();
                if (records > 1) {
                    for (int i = 2; i <= records; ++i) {
                        deserializedObject = SerializationUtils.deserializeClass(store.getRecord(i));
                        if (!(deserializedObject instanceof Serializable)) continue;
                        this.objectMap.put(new Long(deserializedObject.getUniqueId()), deserializedObject);
                    }
                }
            }
            store.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    public void delete() {
        try {
            RecordStore.deleteRecordStore((String)this.storeName);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }
}

