/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail;

import java.util.Calendar;
import java.util.Hashtable;
import net.rim.blackberry.api.homescreen.HomeScreen;
import net.rim.device.api.notification.NotificationsManager;
import net.rim.device.api.system.ApplicationManager;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.system.EventLogger;
import net.rim.device.api.system.RuntimeStore;
import net.rim.device.api.ui.UiApplication;
import org.logicprobe.LogicMail.AppInfo;
import org.logicprobe.LogicMail.LogicMailEventSource;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.ui.NavigationController;
import org.logicprobe.LogicMail.ui.NotificationHandler;

public class LogicMail
extends UiApplication {
    NavigationController navigationController;

    public LogicMail(String[] args) {
        boolean autoStart = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf("autostartup") == -1) continue;
            autoStart = true;
        }
        AppInfo.initialize(args);
        if (autoStart) {
            this.doAutoStart();
        } else {
            MailSettings.getInstance().loadSettings();
            if (EventLogger.getMinimumLevel() >= 4) {
                StringBuffer buf = new StringBuffer();
                buf.append("Application startup\r\n");
                buf.append("Date: ");
                buf.append(Calendar.getInstance().getTime().toString());
                buf.append("\r\n");
                buf.append("Name: ");
                buf.append(AppInfo.getName());
                buf.append("\r\n");
                buf.append("Version: ");
                buf.append(AppInfo.getVersion());
                buf.append("\r\n");
                buf.append("Platform: ");
                buf.append(AppInfo.getPlatformVersion());
                buf.append("\r\n");
                EventLogger.logEvent((long)7765914274915215232L, (byte[])buf.toString().getBytes(), (int)4);
            }
            NotificationHandler.getInstance().setEnabled(true);
            this.navigationController = new NavigationController(this);
            this.navigationController.displayMailHome();
        }
    }

    public void run() {
        this.enterEventDispatcher();
    }

    private void doAutoStart() {
        this.invokeLater(new Runnable(){

            public void run() {
                ApplicationManager myApp = ApplicationManager.getApplicationManager();
                boolean keepGoing = true;
                while (keepGoing) {
                    if (myApp.inStartup()) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception ex) {}
                        continue;
                    }
                    HomeScreen.updateIcon((Bitmap)AppInfo.getIcon(), (int)0);
                    HomeScreen.setRolloverIcon((Bitmap)AppInfo.getRolloverIcon(), (int)0);
                    MailSettings mailSettings = MailSettings.getInstance();
                    mailSettings.loadSettings();
                    int numAccounts = mailSettings.getNumAccounts();
                    Hashtable<Long, LogicMailEventSource> eventSourceMap = new Hashtable<Long, LogicMailEventSource>(numAccounts);
                    for (int i = 0; i < numAccounts; ++i) {
                        AccountConfig accountConfig = mailSettings.getAccountConfig(i);
                        LogicMailEventSource eventSource = new LogicMailEventSource(accountConfig.getAcctName(), accountConfig.getUniqueId());
                        NotificationsManager.registerSource((long)eventSource.getEventSourceId(), (Object)eventSource, (int)3);
                        eventSourceMap.put(new Long(accountConfig.getUniqueId()), eventSource);
                    }
                    RuntimeStore.getRuntimeStore().put(7765914274915215232L, eventSourceMap);
                    keepGoing = false;
                }
                System.exit(0);
            }
        });
    }
}

