/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.io.DataInputStream;
import org.logicprobe.LogicMail.conf.ConnectionConfig;
import org.logicprobe.LogicMail.conf.IdentityConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailRootNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.util.SerializableHashtable;

public abstract class AccountConfig
extends ConnectionConfig {
    private String serverUser;
    private String serverPass;
    private IdentityConfig identityConfig;
    private long identityConfigId;
    private OutgoingConfig outgoingConfig;
    private long outgoingConfigId;
    private MailboxNode sentMailbox;
    private long sentMailboxId;
    private MailboxNode draftMailbox;
    private long draftMailboxId;

    public AccountConfig() {
    }

    public AccountConfig(DataInputStream input) {
        super(input);
    }

    protected void setDefaults() {
        super.setDefaults();
        this.serverUser = "";
        this.serverPass = "";
        this.setServerPort(110);
        this.identityConfig = null;
        this.identityConfigId = -1L;
        this.outgoingConfig = null;
        this.outgoingConfigId = -1L;
        this.sentMailbox = null;
        this.sentMailboxId = -1L;
        this.draftMailbox = null;
        this.draftMailboxId = -1L;
    }

    public String toString() {
        return this.getAcctName();
    }

    public String getServerUser() {
        return this.serverUser;
    }

    public void setServerUser(String serverUser) {
        this.serverUser = serverUser;
    }

    public String getServerPass() {
        return this.serverPass;
    }

    public void setServerPass(String serverPass) {
        this.serverPass = serverPass;
    }

    public IdentityConfig getIdentityConfig() {
        if (this.identityConfig == null && this.identityConfigId != -1L) {
            this.identityConfig = MailSettings.getInstance().getIdentityConfigByUniqueId(this.identityConfigId);
        }
        return this.identityConfig;
    }

    public void setIdentityConfig(IdentityConfig identityConfig) {
        if (identityConfig == null) {
            this.identityConfig = null;
            this.identityConfigId = -1L;
        } else {
            this.identityConfig = identityConfig;
            this.identityConfigId = identityConfig.getUniqueId();
        }
    }

    public OutgoingConfig getOutgoingConfig() {
        if (this.outgoingConfig == null && this.outgoingConfigId != -1L) {
            this.outgoingConfig = MailSettings.getInstance().getOutgoingConfigByUniqueId(this.outgoingConfigId);
        }
        return this.outgoingConfig;
    }

    public void setOutgoingConfig(OutgoingConfig outgoingConfig) {
        if (outgoingConfig == null) {
            this.outgoingConfig = null;
            this.outgoingConfigId = -1L;
        } else {
            this.outgoingConfig = outgoingConfig;
            this.outgoingConfigId = outgoingConfig.getUniqueId();
        }
    }

    public MailboxNode getSentMailbox() {
        if (this.sentMailbox == null && this.sentMailboxId != -1L) {
            MailRootNode rootNode = MailManager.getInstance().getMailRootNode();
            AccountNode[] accounts = rootNode.getAccounts();
            for (int i = 0; i < accounts.length; ++i) {
                this.sentMailbox = AccountConfig.findMailboxNode(accounts[i].getRootMailbox(), this.sentMailboxId);
                if (this.sentMailbox != null) break;
            }
        }
        return this.sentMailbox;
    }

    public void setSentMailbox(MailboxNode sentMailbox) {
        if (sentMailbox == null) {
            this.sentMailbox = null;
            this.sentMailboxId = -1L;
        } else {
            this.sentMailbox = sentMailbox;
            this.sentMailboxId = sentMailbox.getUniqueId();
        }
    }

    public MailboxNode getDraftMailbox() {
        if (this.draftMailbox == null && this.draftMailboxId != -1L) {
            MailRootNode rootNode = MailManager.getInstance().getMailRootNode();
            AccountNode[] accounts = rootNode.getAccounts();
            for (int i = 0; i < accounts.length; ++i) {
                this.draftMailbox = AccountConfig.findMailboxNode(accounts[i].getRootMailbox(), this.draftMailboxId);
                if (this.draftMailbox != null) break;
            }
        }
        return this.draftMailbox;
    }

    public void setDraftMailbox(MailboxNode draftMailbox) {
        if (draftMailbox == null) {
            this.draftMailbox = null;
            this.draftMailboxId = -1L;
        } else {
            this.draftMailbox = draftMailbox;
            this.draftMailboxId = draftMailbox.getUniqueId();
        }
    }

    private static MailboxNode findMailboxNode(MailboxNode currentNode, long id) {
        if (currentNode.getUniqueId() == id) {
            return currentNode;
        }
        MailboxNode[] nodes = currentNode.getMailboxes();
        for (int i = 0; i < nodes.length; ++i) {
            MailboxNode result = AccountConfig.findMailboxNode(nodes[i], id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void writeConfigItems(SerializableHashtable table) {
        super.writeConfigItems(table);
        table.put("account_serverUser", this.serverUser);
        table.put("account_serverPass", this.serverPass);
        table.put("account_identityConfigId", new Long(this.identityConfigId));
        table.put("account_outgoingConfigId", new Long(this.outgoingConfigId));
        table.put("account_sentMailboxId", new Long(this.sentMailboxId));
        table.put("account_draftMailboxId", new Long(this.draftMailboxId));
    }

    public void readConfigItems(SerializableHashtable table) {
        super.readConfigItems(table);
        Object value = table.get("account_serverUser");
        if (value != null && value instanceof String) {
            this.serverUser = (String)value;
        }
        if ((value = table.get("account_serverPass")) != null && value instanceof String) {
            this.serverPass = (String)value;
        }
        this.identityConfigId = (value = table.get("account_identityConfigId")) != null && value instanceof Long ? (Long)value : -1L;
        this.identityConfig = null;
        value = table.get("account_outgoingConfigId");
        this.outgoingConfigId = value != null && value instanceof Long ? (Long)value : -1L;
        this.outgoingConfig = null;
        value = table.get("account_sentMailboxId");
        this.sentMailboxId = value != null && value instanceof Long ? (Long)value : -1L;
        value = table.get("account_draftMailboxId");
        this.draftMailboxId = value != null && value instanceof Long ? (Long)value : -1L;
    }
}

