/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.conf;

import java.io.DataInputStream;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.util.SerializableHashtable;

public class ImapConfig
extends AccountConfig {
    private String folderPrefix;
    private int maxMessageSize;
    private int maxFolderDepth;

    public ImapConfig() {
    }

    public ImapConfig(DataInputStream input) {
        super(input);
    }

    protected void setDefaults() {
        super.setDefaults();
        this.setServerPort(143);
        this.maxMessageSize = 32768;
        this.maxFolderDepth = 4;
        this.folderPrefix = null;
    }

    public String toString() {
        String text = this.getAcctName().concat(" (IMAP)");
        return text;
    }

    public String getFolderPrefix() {
        return this.folderPrefix;
    }

    public void setFolderPrefix(String folderPrefix) {
        this.folderPrefix = folderPrefix;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public int getMaxFolderDepth() {
        return this.maxFolderDepth;
    }

    public void setMaxFolderDepth(int maxFolderDepth) {
        this.maxFolderDepth = maxFolderDepth;
    }

    public void writeConfigItems(SerializableHashtable table) {
        super.writeConfigItems(table);
        if (this.folderPrefix != null) {
            table.put("account_imap_folderPrefix", this.folderPrefix);
        } else {
            table.put("account_imap_folderPrefix", "");
        }
        table.put("account_imap_maxMessageSize", new Integer(this.maxMessageSize));
        table.put("account_imap_maxFolderDepth", new Integer(this.maxFolderDepth));
    }

    public void readConfigItems(SerializableHashtable table) {
        super.readConfigItems(table);
        Object value = table.get("account_imap_folderPrefix");
        if (value != null && value instanceof String) {
            this.folderPrefix = (String)value;
            if (this.folderPrefix.length() == 0) {
                this.folderPrefix = null;
            }
        }
        if ((value = table.get("account_imap_maxMessageSize")) != null && value instanceof Integer) {
            this.maxMessageSize = (Integer)value;
        }
        if ((value = table.get("account_imap_maxFolderDepth")) != null && value instanceof Integer) {
            this.maxFolderDepth = (Integer)value;
        }
    }
}

