/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class LocalMessageToken
implements MessageToken {
    private long uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
    private int hashCode = -1;
    private String folderPath;
    private String messageUid;

    public LocalMessageToken() {
    }

    LocalMessageToken(String folderPath, String messageUid) {
        this();
        this.folderPath = folderPath;
        this.messageUid = messageUid;
    }

    public boolean containedWithin(FolderTreeItem folderTreeItem) {
        return this.folderPath != null && this.folderPath.equals(folderTreeItem.getPath());
    }

    String getFolderPath() {
        return this.folderPath;
    }

    String getMessageUid() {
        return this.messageUid;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        output.writeUTF(this.folderPath);
        output.writeUTF(this.messageUid);
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.uniqueId = input.readLong();
        this.folderPath = input.readUTF();
        this.messageUid = input.readUTF();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalMessageToken) {
            LocalMessageToken rhs = (LocalMessageToken)obj;
            return this.folderPath.equals(rhs.folderPath) && this.messageUid.equals(rhs.messageUid);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            int hash = 7;
            hash = 31 * hash + (this.folderPath == null ? 0 : this.folderPath.hashCode());
            this.hashCode = hash = 31 * hash + (this.messageUid == null ? 0 : this.messageUid.hashCode());
        }
        return this.hashCode;
    }
}

