/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import java.util.Hashtable;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.mail.AbstractMailSender;
import org.logicprobe.LogicMail.mail.AbstractMailStore;
import org.logicprobe.LogicMail.mail.LocalMailStore;
import org.logicprobe.LogicMail.mail.NetworkMailSender;
import org.logicprobe.LogicMail.mail.NetworkMailStore;

public class MailFactory {
    private static LocalMailStore localMailStore;
    private static Hashtable mailStoreTable;
    private static Hashtable mailSenderTable;

    private MailFactory() {
    }

    public static AbstractMailStore createLocalMailStore() {
        if (localMailStore == null) {
            localMailStore = new LocalMailStore();
        }
        return localMailStore;
    }

    public static AbstractMailStore createMailStore(AccountConfig accountConfig) {
        AbstractMailStore mailStore = (AbstractMailStore)mailStoreTable.get(accountConfig);
        if (mailStore == null) {
            mailStore = new NetworkMailStore(accountConfig);
            mailStoreTable.put(accountConfig, mailStore);
        }
        return mailStore;
    }

    public static void clearMailStore(AccountConfig accountConfig) {
        mailStoreTable.remove(accountConfig);
    }

    public static AbstractMailSender createMailSender(OutgoingConfig outgoingConfig) {
        AbstractMailSender mailSender = (AbstractMailSender)mailSenderTable.get(outgoingConfig);
        if (mailSender == null) {
            mailSender = new NetworkMailSender(outgoingConfig);
            mailSenderTable.put(outgoingConfig, mailSender);
        }
        return mailSender;
    }

    public static void clearMailSender(OutgoingConfig outgoingConfig) {
        mailSenderTable.remove(outgoingConfig);
    }

    static {
        mailStoreTable = new Hashtable();
        mailSenderTable = new Hashtable();
    }
}

