/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail;

import net.rim.device.api.system.UnsupportedOperationException;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.mail.AbstractMailStore;
import org.logicprobe.LogicMail.mail.FolderTreeItem;
import org.logicprobe.LogicMail.mail.IncomingMailClient;
import org.logicprobe.LogicMail.mail.IncomingMailConnectionHandler;
import org.logicprobe.LogicMail.mail.MailClientFactory;
import org.logicprobe.LogicMail.mail.MailConnectionHandlerListener;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.mail.imap.ImapClient;
import org.logicprobe.LogicMail.message.FolderMessage;
import org.logicprobe.LogicMail.message.MessageContent;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MessagePart;

public class NetworkMailStore
extends AbstractMailStore {
    private IncomingMailClient client;
    private IncomingMailConnectionHandler connectionHandler;
    private AccountConfig accountConfig;

    public NetworkMailStore(AccountConfig accountConfig) {
        this.client = MailClientFactory.createMailClient(accountConfig);
        this.accountConfig = accountConfig;
        this.connectionHandler = new IncomingMailConnectionHandler(this.client);
        this.connectionHandler.setListener(new MailConnectionHandlerListener(){

            public void mailConnectionRequestComplete(int type, Object result) {
                NetworkMailStore.this.connectionHandler_mailConnectionRequestComplete(type, result);
            }
        });
        this.connectionHandler.start();
    }

    public AccountConfig getAccountConfig() {
        return this.accountConfig;
    }

    public void shutdown(boolean wait) {
        this.connectionHandler.shutdown(wait);
    }

    public void restart() {
        if (!this.connectionHandler.isRunning()) {
            this.connectionHandler.start();
        }
    }

    public boolean isLocal() {
        return false;
    }

    public boolean hasFolders() {
        return this.client.hasFolders();
    }

    public boolean hasMessageParts() {
        return this.client instanceof ImapClient;
    }

    public boolean hasFlags() {
        return this.client instanceof ImapClient;
    }

    public boolean hasAppend() {
        return this.client instanceof ImapClient;
    }

    public boolean hasUndelete() {
        return this.client.hasUndelete();
    }

    public boolean isConnected() {
        return this.client.isConnected();
    }

    public void requestFolderTree() {
        this.connectionHandler.addRequest(10, new Object[0]);
    }

    public void requestFolderStatus(FolderTreeItem[] folders) {
        this.connectionHandler.addRequest(11, new Object[]{folders});
    }

    public void requestFolderMessagesRange(FolderTreeItem folder, int firstIndex, int lastIndex) {
        this.connectionHandler.addRequest(12, new Object[]{folder, new Integer(firstIndex), new Integer(lastIndex)});
    }

    public void requestFolderMessagesSet(FolderTreeItem folder, int[] indices) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void requestFolderMessagesRecent(FolderTreeItem folder) {
        this.connectionHandler.addRequest(14, new Object[]{folder});
    }

    public void requestMessage(MessageToken messageToken) {
        this.connectionHandler.addRequest(20, new Object[]{messageToken});
    }

    public void requestMessagePart(MessageToken messageToken, MessagePart messagePart) {
        this.connectionHandler.addRequest(21, new Object[]{messageToken, messagePart});
    }

    public void requestMessageDelete(MessageToken messageToken, MessageFlags messageFlags) {
        this.connectionHandler.addRequest(22, new Object[]{messageToken, messageFlags});
    }

    public void requestMessageUndelete(MessageToken messageToken, MessageFlags messageFlags) {
        if (!this.client.hasUndelete()) {
            throw new UnsupportedOperationException();
        }
        this.connectionHandler.addRequest(23, new Object[]{messageToken, messageFlags});
    }

    public void requestMessageAnswered(MessageToken messageToken, MessageFlags messageFlags) {
        if (!this.hasFlags()) {
            throw new UnsupportedOperationException();
        }
        this.connectionHandler.addRequest(24, new Object[]{messageToken, messageFlags});
    }

    public void requestMessageAppend(FolderTreeItem folder, String rawMessage, MessageFlags initialFlags) {
        if (!this.hasAppend()) {
            throw new UnsupportedOperationException();
        }
        this.connectionHandler.addRequest(25, new Object[]{folder, rawMessage, initialFlags});
    }

    private void connectionHandler_mailConnectionRequestComplete(int type, Object result) {
        switch (type) {
            case 10: {
                this.fireFolderTreeUpdated((FolderTreeItem)result);
                break;
            }
            case 11: {
                FolderTreeItem[] folders = (FolderTreeItem[])result;
                for (int i = 0; i < folders.length; ++i) {
                    this.fireFolderStatusChanged(folders[i]);
                }
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                Object[] results = (Object[])result;
                this.fireFolderMessagesAvailable((FolderTreeItem)results[0], (FolderMessage[])results[1]);
                break;
            }
            case 20: {
                Object[] results = (Object[])result;
                this.fireMessageAvailable((MessageToken)results[0], (MessagePart)results[1], (MessageContent[])results[2], null);
                break;
            }
            case 21: {
                Object[] results = (Object[])result;
                this.fireMessagePartAvailable((MessageToken)results[0], (MessageContent[])results[1]);
                break;
            }
            case 22: {
                Object[] results = (Object[])result;
                this.fireMessageDeleted((MessageToken)results[0], (MessageFlags)results[1]);
                break;
            }
            case 23: {
                Object[] results = (Object[])result;
                this.fireMessageUndeleted((MessageToken)results[0], (MessageFlags)results[1]);
                break;
            }
            case 24: {
                Object[] results = (Object[])result;
                this.fireMessageFlagsChanged((MessageToken)results[0], (MessageFlags)results[1]);
                break;
            }
            case 25: {
                Object[] results = (Object[])result;
                this.fireFolderMessagesAvailable((FolderTreeItem)results[0], (FolderMessage[])results[1]);
            }
        }
    }
}

