/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.mail.smtp;

import java.io.IOException;
import java.util.Calendar;
import org.logicprobe.LogicMail.conf.ConnectionConfig;
import org.logicprobe.LogicMail.conf.GlobalConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.MailSettingsEvent;
import org.logicprobe.LogicMail.conf.MailSettingsListener;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.mail.MailException;
import org.logicprobe.LogicMail.mail.OutgoingMailClient;
import org.logicprobe.LogicMail.mail.smtp.SmtpProtocol;
import org.logicprobe.LogicMail.message.Message;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageMimeConverter;
import org.logicprobe.LogicMail.util.Connection;
import org.logicprobe.LogicMail.util.MailMessageParser;

public class SmtpClient
implements OutgoingMailClient {
    private GlobalConfig globalConfig;
    private OutgoingConfig outgoingConfig;
    private Connection connection;
    private SmtpProtocol smtpProtocol;
    private boolean isFresh;
    private boolean openStarted;
    private String username;
    private String password;
    private boolean configChanged;
    private MailSettingsListener mailSettingsListener = new MailSettingsListener(){

        public void mailSettingsSaved(MailSettingsEvent e) {
            SmtpClient.this.mailSettings_MailSettingsSaved(e);
        }
    };

    public SmtpClient(GlobalConfig globalConfig, OutgoingConfig outgoingConfig) {
        this.globalConfig = globalConfig;
        this.outgoingConfig = outgoingConfig;
        this.connection = new Connection(outgoingConfig.getServerName(), outgoingConfig.getServerPort(), outgoingConfig.getServerSSL(), outgoingConfig.getDeviceSide());
        this.smtpProtocol = new SmtpProtocol(this.connection);
        if (outgoingConfig.getUseAuth() > 0) {
            this.username = outgoingConfig.getServerUser();
            this.password = outgoingConfig.getServerPass();
        } else {
            this.username = null;
            this.password = null;
        }
        this.openStarted = false;
        this.configChanged = false;
        MailSettings.getInstance().addMailSettingsListener(this.mailSettingsListener);
    }

    private void mailSettings_MailSettingsSaved(MailSettingsEvent e) {
        if (MailSettings.getInstance().containsOutgoingConfig(this.outgoingConfig)) {
            this.username = this.outgoingConfig.getServerUser();
            this.password = this.outgoingConfig.getServerPass();
            if (!this.isConnected()) {
                this.connection = new Connection(this.outgoingConfig.getServerName(), this.outgoingConfig.getServerPort(), this.outgoingConfig.getServerSSL(), this.outgoingConfig.getDeviceSide());
                this.smtpProtocol = new SmtpProtocol(this.connection);
            } else {
                this.configChanged = true;
            }
        } else {
            MailSettings.getInstance().removeMailSettingsListener(this.mailSettingsListener);
        }
    }

    public boolean open() throws IOException, MailException {
        boolean result;
        if (!this.openStarted) {
            this.connection.open();
            this.connection.receive();
            String hostname = this.globalConfig.getLocalHostname();
            if (hostname.length() == 0 && (hostname = System.getProperty("microedition.hostname")) == null) {
                hostname = this.connection.getLocalAddress();
            }
            this.smtpProtocol.executeExtendedHello(hostname);
            this.openStarted = true;
        }
        if (this.outgoingConfig.getUseAuth() > 0 && !(result = this.smtpProtocol.executeAuth(this.outgoingConfig.getUseAuth(), this.username, this.password))) {
            return false;
        }
        this.isFresh = true;
        this.openStarted = false;
        return true;
    }

    public void close() throws IOException, MailException {
        try {
            this.smtpProtocol.executeQuit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection.close();
        if (this.configChanged) {
            this.connection = new Connection(this.outgoingConfig.getServerName(), this.outgoingConfig.getServerPort(), this.outgoingConfig.getServerSSL(), this.outgoingConfig.getDeviceSide());
            this.smtpProtocol = new SmtpProtocol(this.connection);
            this.configChanged = false;
        }
    }

    public ConnectionConfig getConnectionConfig() {
        return this.outgoingConfig;
    }

    public boolean isConnected() {
        return this.connection.isConnected();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String sendMessage(MessageEnvelope envelope, Message message) throws IOException, MailException {
        String rawMessage;
        int i;
        if (!this.isFresh) {
            this.smtpProtocol.executeReset();
        }
        this.isFresh = false;
        MessageMimeConverter messageMime = new MessageMimeConverter(message);
        String mimeStr = messageMime.toMimeString();
        StringBuffer buffer = new StringBuffer();
        envelope.date = Calendar.getInstance().getTime();
        buffer.append(MailMessageParser.generateMessageHeaders(envelope, true));
        buffer.append(mimeStr);
        if (!this.smtpProtocol.executeMail(SmtpClient.stripEmail(envelope.from[0]))) {
            throw new MailException("Error with sender");
        }
        for (i = 0; i < envelope.to.length; ++i) {
            if (this.smtpProtocol.executeRecipient(SmtpClient.stripEmail(envelope.to[i]))) continue;
            throw new MailException("Error with recipient");
        }
        if (envelope.cc != null) {
            for (i = 0; i < envelope.cc.length; ++i) {
                if (this.smtpProtocol.executeRecipient(SmtpClient.stripEmail(envelope.cc[i]))) continue;
                throw new MailException("Error with recipient");
            }
        }
        if (envelope.bcc != null) {
            for (i = 0; i < envelope.bcc.length; ++i) {
                if (this.smtpProtocol.executeRecipient(SmtpClient.stripEmail(envelope.bcc[i]))) continue;
                throw new MailException("Error with recipient");
            }
        }
        if (!this.smtpProtocol.executeData(rawMessage = buffer.toString())) {
            throw new MailException("Error sending message");
        }
        return rawMessage;
    }

    private static String stripEmail(String input) {
        int p = input.indexOf(60);
        int q = input.indexOf(62);
        if (p == -1 || q == -1 || q <= p) {
            return input;
        }
        return input.substring(p + 1, q);
    }
}

