/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.mail.MessageToken;
import org.logicprobe.LogicMail.message.MessageEnvelope;
import org.logicprobe.LogicMail.message.MessageFlags;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.util.Serializable;
import org.logicprobe.LogicMail.util.SerializationUtils;
import org.logicprobe.LogicMail.util.UniqueIdGenerator;

public class FolderMessage
implements Serializable {
    private long uniqueId = UniqueIdGenerator.getInstance().getUniqueId();
    private MessageToken messageToken;
    private MessageEnvelope envelope = new MessageEnvelope();
    private int index;
    private int uid;
    private MessageFlags messageFlags = new MessageFlags();
    private MessagePart structure;

    public FolderMessage() {
    }

    public FolderMessage(MessageToken messageToken, MessageEnvelope envelope, int index, int uid) {
        this();
        this.messageToken = messageToken;
        this.envelope = envelope;
        this.index = index;
        this.uid = uid;
    }

    public MessageToken getMessageToken() {
        return this.messageToken;
    }

    public MessageEnvelope getEnvelope() {
        return this.envelope;
    }

    public int getIndex() {
        return this.index;
    }

    public int getUid() {
        return this.uid;
    }

    public MessageFlags getFlags() {
        return this.messageFlags;
    }

    public boolean isSeen() {
        return this.messageFlags.isSeen();
    }

    public void setSeen(boolean seen) {
        this.messageFlags.setSeen(seen);
    }

    public boolean isAnswered() {
        return this.messageFlags.isAnswered();
    }

    public void setAnswered(boolean answered) {
        this.messageFlags.setAnswered(answered);
    }

    public boolean isFlagged() {
        return this.messageFlags.isFlagged();
    }

    public void setFlagged(boolean flagged) {
        this.messageFlags.setFlagged(flagged);
    }

    public boolean isDeleted() {
        return this.messageFlags.isDeleted();
    }

    public void setDeleted(boolean deleted) {
        this.messageFlags.setDeleted(deleted);
    }

    public boolean isDraft() {
        return this.messageFlags.isDraft();
    }

    public void setDraft(boolean draft) {
        this.messageFlags.setDraft(draft);
    }

    public boolean isRecent() {
        return this.messageFlags.isRecent();
    }

    public void setRecent(boolean recent) {
        this.messageFlags.setRecent(recent);
    }

    public boolean isJunk() {
        return this.messageFlags.isJunk();
    }

    public void setJunk(boolean junk) {
        this.messageFlags.setJunk(junk);
    }

    public MessagePart getStructure() {
        return this.structure;
    }

    public void setStructure(MessagePart structure) {
        this.structure = structure;
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void serialize(DataOutputStream output) throws IOException {
        output.writeLong(this.uniqueId);
        SerializationUtils.serializeClass(this.messageToken, output);
        output.writeInt(this.index);
        output.writeInt(this.uid);
        this.envelope.serialize(output);
        output.writeBoolean(this.messageFlags.isSeen());
        output.writeBoolean(this.messageFlags.isAnswered());
        output.writeBoolean(this.messageFlags.isFlagged());
        output.writeBoolean(this.messageFlags.isDeleted());
        output.writeBoolean(this.messageFlags.isDraft());
        output.writeBoolean(this.messageFlags.isRecent());
        output.writeBoolean(this.messageFlags.isJunk());
        if (this.structure == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            SerializationUtils.serializeClass(this.structure, output);
        }
    }

    public void deserialize(DataInputStream input) throws IOException {
        this.uniqueId = input.readLong();
        this.messageToken = (MessageToken)SerializationUtils.deserializeClass(input);
        this.index = input.readInt();
        this.uid = input.readInt();
        this.envelope.deserialize(input);
        this.messageFlags.setSeen(input.readBoolean());
        this.messageFlags.setAnswered(input.readBoolean());
        this.messageFlags.setFlagged(input.readBoolean());
        this.messageFlags.setDeleted(input.readBoolean());
        this.messageFlags.setDraft(input.readBoolean());
        this.messageFlags.setRecent(input.readBoolean());
        this.messageFlags.setJunk(input.readBoolean());
        boolean hasStructure = input.readBoolean();
        if (hasStructure) {
            this.structure = (MessagePart)SerializationUtils.deserializeClass(input);
        }
    }
}

