/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import org.logicprobe.LogicMail.message.ImagePart;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MultiPart;
import org.logicprobe.LogicMail.message.TextPart;
import org.logicprobe.LogicMail.message.UnsupportedPart;

public class MessagePartFactory {
    public static MessagePart createMessagePart(String mimeType, String mimeSubtype, String encoding, String param, int size, String tag) {
        MessagePart part = mimeType.equalsIgnoreCase("multipart") ? new MultiPart(mimeSubtype, tag) : (mimeType.equalsIgnoreCase("text") ? new TextPart(mimeSubtype, encoding, param, size, tag) : (mimeType.equalsIgnoreCase("image") ? new ImagePart(mimeSubtype, encoding, size, tag) : new UnsupportedPart(mimeType, mimeSubtype, tag)));
        return part;
    }

    public static MessagePart createMessagePart(String mimeType, String mimeSubtype, String encoding, String param, int size) {
        return MessagePartFactory.createMessagePart(mimeType, mimeSubtype, encoding, param, size, "");
    }

    public static boolean isMessagePartSupported(String mimeType, String mimeSubtype) {
        if (mimeType.equalsIgnoreCase("multipart")) {
            return MessagePartFactory.isMultiPartSupported(mimeSubtype);
        }
        if (mimeType.equalsIgnoreCase("text")) {
            return MessagePartFactory.isTextPartSupported(mimeSubtype);
        }
        if (mimeType.equalsIgnoreCase("image")) {
            return MessagePartFactory.isImagePartSupported(mimeSubtype);
        }
        return false;
    }

    private static boolean isMultiPartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("mixed") || mimeSubtype.equalsIgnoreCase("related") || mimeSubtype.equalsIgnoreCase("alternative") || mimeSubtype.equalsIgnoreCase("signed");
    }

    private static boolean isTextPartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("plain") || mimeSubtype.equalsIgnoreCase("html");
    }

    private static boolean isImagePartSupported(String mimeSubtype) {
        return mimeSubtype.equalsIgnoreCase("gif") || mimeSubtype.equalsIgnoreCase("png") || mimeSubtype.equalsIgnoreCase("vnd.wap.wbmp") || mimeSubtype.equalsIgnoreCase("jpeg") || mimeSubtype.equalsIgnoreCase("jpg") || mimeSubtype.equalsIgnoreCase("pjpeg") || mimeSubtype.equalsIgnoreCase("bmp") || mimeSubtype.equalsIgnoreCase("tif");
    }
}

