/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.message.MessagePartVisitor;

public class TextPart
extends MessagePart {
    private String encoding;
    private String charset;

    public TextPart(String mimeSubtype, String encoding, String charset, int size, String tag) {
        super("text", mimeSubtype, size, tag);
        this.encoding = encoding;
        this.charset = charset;
    }

    public TextPart(String mimeSubtype, String encoding, String charset, int size) {
        this(mimeSubtype, encoding, charset, size, "");
    }

    public TextPart() {
        this("", "", "", -1, "");
    }

    public void accept(MessagePartVisitor visitor) {
        visitor.visitTextPart(this);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void serialize(DataOutputStream output) throws IOException {
        super.serialize(output);
        output.writeUTF(this.encoding);
        output.writeUTF(this.charset);
    }

    public void deserialize(DataInputStream input) throws IOException {
        super.deserialize(input);
        this.encoding = input.readUTF();
        this.charset = input.readUTF();
    }
}

