/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Vector;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.FieldChangeListener;
import net.rim.device.api.ui.Manager;
import net.rim.device.api.ui.component.BasicEditField;
import net.rim.device.api.ui.component.CheckboxField;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.ObjectChoiceField;
import net.rim.device.api.ui.component.PasswordEditField;
import net.rim.device.api.ui.component.RichTextField;
import net.rim.device.api.ui.component.SeparatorField;
import net.rim.device.api.ui.container.VerticalFieldManager;
import net.rim.device.api.ui.text.TextFilter;
import org.logicprobe.LogicMail.conf.AccountConfig;
import org.logicprobe.LogicMail.conf.IdentityConfig;
import org.logicprobe.LogicMail.conf.ImapConfig;
import org.logicprobe.LogicMail.conf.MailSettings;
import org.logicprobe.LogicMail.conf.OutgoingConfig;
import org.logicprobe.LogicMail.conf.PopConfig;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.ui.BaseCfgScreen;
import org.logicprobe.LogicMail.ui.MailboxSelectionDialog;

public class AcctCfgScreen
extends BaseCfgScreen {
    private BasicEditField acctNameField;
    private LabelField accountTypeLabel;
    private ObjectChoiceField pageField;
    private VerticalFieldManager contentFieldManager;
    private BasicEditField serverNameField;
    private CheckboxField serverSslField;
    private BasicEditField serverPortField;
    private BasicEditField serverUserField;
    private PasswordEditField serverPassField;
    private CheckboxField useMdsField;
    private ObjectChoiceField identityField;
    private ObjectChoiceField outgoingServerField;
    private LabelField sentFolderChoiceLabel;
    private LabelField sentFolderChoiceButtonLabel;
    private LabelField draftFolderChoiceLabel;
    private LabelField draftFolderChoiceButtonLabel;
    private BasicEditField imapFolderPrefixField;
    private BasicEditField imapMaxMessageSizeEditField;
    private BasicEditField imapMaxFolderDepthEditField;
    private BasicEditField popMaxLinesEditField;
    private Manager[] pageFieldManagers;
    private boolean acctSaved;
    private boolean createDefaultIdentity;
    private AccountConfig acctConfig;
    private IdentityConfig[] identityConfigs;
    private OutgoingConfig[] outgoingConfigs;
    private MailboxNode selectedSentFolder;
    private MailboxNode selectedDraftFolder;
    private FieldChangeListener fieldChangeListener;

    public AcctCfgScreen(AccountConfig acctConfig) {
        super("LogicMail - " + BaseCfgScreen.resources.getString(21));
        OutgoingConfig selectedOutgoingConfig;
        this.acctConfig = acctConfig;
        this.acctSaved = false;
        MailSettings mailSettings = MailSettings.getInstance();
        int numIdentities = mailSettings.getNumIdentities();
        if (numIdentities > 0) {
            this.identityConfigs = new IdentityConfig[numIdentities];
            for (int i = 0; i < numIdentities; ++i) {
                this.identityConfigs[i] = mailSettings.getIdentityConfig(i);
            }
            this.createDefaultIdentity = false;
        } else {
            this.identityConfigs = new IdentityConfig[1];
            this.identityConfigs[0] = new IdentityConfig();
            this.identityConfigs[0].setIdentityName("Default");
            this.createDefaultIdentity = true;
            this.setDirty(true);
        }
        int numOutgoing = mailSettings.getNumOutgoing();
        this.outgoingConfigs = new OutgoingConfig[numOutgoing + 1];
        this.outgoingConfigs[0] = new NullOutgoingConfig();
        for (int i = 0; i < numOutgoing; ++i) {
            this.outgoingConfigs[i + 1] = mailSettings.getOutgoingConfig(i);
        }
        this.fieldChangeListener = new FieldChangeListener(){

            public void fieldChanged(Field field, int context) {
                AcctCfgScreen.this.AcctCfgScreen_fieldChanged(field, context);
            }
        };
        this.initFields();
        IdentityConfig selectedIdentityConfig = acctConfig.getIdentityConfig();
        if (selectedIdentityConfig != null) {
            this.identityField.setSelectedIndex((Object)selectedIdentityConfig);
        }
        if ((selectedOutgoingConfig = acctConfig.getOutgoingConfig()) != null) {
            this.outgoingServerField.setSelectedIndex((Object)selectedOutgoingConfig);
        }
    }

    private void initFields() {
        this.acctNameField = new BasicEditField(BaseCfgScreen.resources.getString(22) + ' ', this.acctConfig.getAcctName());
        String accountType = BaseCfgScreen.resources.getString(31);
        if (this.acctConfig instanceof ImapConfig) {
            accountType = accountType + " IMAP";
        } else if (this.acctConfig instanceof PopConfig) {
            accountType = accountType + " POP";
        }
        this.accountTypeLabel = new LabelField((Object)accountType, 0x80000000000000L);
        this.pageField = new ObjectChoiceField(BaseCfgScreen.resources.getString(97), (Object[])new String[]{BaseCfgScreen.resources.getString(98), BaseCfgScreen.resources.getString(99), BaseCfgScreen.resources.getString(100)});
        this.pageField.setChangeListener(this.fieldChangeListener);
        this.pageFieldManagers = new Manager[3];
        this.pageFieldManagers[0] = this.initFieldsBasic();
        this.pageFieldManagers[1] = this.initFieldsFolder();
        this.pageFieldManagers[2] = this.initFieldsAdvanced();
        this.contentFieldManager = new VerticalFieldManager();
        this.contentFieldManager.add((Field)this.pageFieldManagers[0]);
        this.add((Field)this.acctNameField);
        this.add((Field)this.accountTypeLabel);
        this.add((Field)this.pageField);
        this.add((Field)new SeparatorField());
        this.add((Field)this.contentFieldManager);
        this.add((Field)new LabelField());
    }

    private Manager initFieldsBasic() {
        VerticalFieldManager manager = new VerticalFieldManager();
        this.serverNameField = new BasicEditField(BaseCfgScreen.resources.getString(23) + ' ', this.acctConfig.getServerName());
        this.serverSslField = new CheckboxField("SSL", this.acctConfig.getServerSSL());
        this.serverSslField.setChangeListener(this.fieldChangeListener);
        this.serverPortField = new BasicEditField(BaseCfgScreen.resources.getString(24) + ' ', Integer.toString(this.acctConfig.getServerPort()));
        this.serverPortField.setFilter(TextFilter.get((int)1));
        this.serverUserField = new BasicEditField(BaseCfgScreen.resources.getString(25) + ' ', this.acctConfig.getServerUser());
        this.serverPassField = new PasswordEditField(BaseCfgScreen.resources.getString(26) + ' ', this.acctConfig.getServerPass());
        this.useMdsField = new CheckboxField(BaseCfgScreen.resources.getString(27), !this.acctConfig.getDeviceSide());
        this.identityField = new ObjectChoiceField(BaseCfgScreen.resources.getString(29) + ' ', (Object[])this.identityConfigs, 0);
        this.outgoingServerField = new ObjectChoiceField(BaseCfgScreen.resources.getString(30) + ' ', (Object[])this.outgoingConfigs, 0);
        manager.add((Field)new RichTextField(BaseCfgScreen.resources.getString(32), 0x80000000000000L));
        manager.add((Field)this.serverNameField);
        manager.add((Field)this.serverSslField);
        manager.add((Field)this.serverPortField);
        manager.add((Field)this.serverUserField);
        manager.add((Field)this.serverPassField);
        manager.add((Field)this.useMdsField);
        manager.add((Field)new LabelField());
        manager.add((Field)this.identityField);
        manager.add((Field)this.outgoingServerField);
        return manager;
    }

    private Manager initFieldsFolder() {
        VerticalFieldManager manager = new VerticalFieldManager();
        this.selectedSentFolder = this.acctConfig.getSentMailbox();
        this.selectedDraftFolder = this.acctConfig.getDraftMailbox();
        this.sentFolderChoiceLabel = new LabelField((Object)(BaseCfgScreen.resources.getString(33) + ' '));
        this.sentFolderChoiceButtonLabel = new LabelField((Object)this.createSelectedMailboxString(this.selectedSentFolder), 18014407099416641L);
        this.draftFolderChoiceLabel = new LabelField((Object)(BaseCfgScreen.resources.getString(91) + ' '));
        this.draftFolderChoiceButtonLabel = new LabelField((Object)this.createSelectedMailboxString(this.selectedDraftFolder), 18014407099416641L);
        manager.add((Field)this.sentFolderChoiceLabel);
        manager.add((Field)this.sentFolderChoiceButtonLabel);
        manager.add((Field)this.draftFolderChoiceLabel);
        manager.add((Field)this.draftFolderChoiceButtonLabel);
        return manager;
    }

    private Manager initFieldsAdvanced() {
        VerticalFieldManager manager = new VerticalFieldManager();
        if (this.acctConfig instanceof ImapConfig) {
            ImapConfig imapConfig = (ImapConfig)this.acctConfig;
            this.imapFolderPrefixField = new BasicEditField(BaseCfgScreen.resources.getString(34) + ' ', imapConfig.getFolderPrefix());
            this.imapMaxMessageSizeEditField = new BasicEditField(BaseCfgScreen.resources.getString(52) + ' ', Integer.toString(imapConfig.getMaxMessageSize() / 1024));
            this.imapMaxMessageSizeEditField.setFilter(TextFilter.get((int)1));
            this.imapMaxFolderDepthEditField = new BasicEditField(BaseCfgScreen.resources.getString(53) + ' ', Integer.toString(imapConfig.getMaxFolderDepth()));
            this.imapMaxFolderDepthEditField.setFilter(TextFilter.get((int)1));
            manager.add((Field)this.imapFolderPrefixField);
            manager.add((Field)this.imapMaxMessageSizeEditField);
            manager.add((Field)this.imapMaxFolderDepthEditField);
        } else if (this.acctConfig instanceof PopConfig) {
            PopConfig popConfig = (PopConfig)this.acctConfig;
            this.popMaxLinesEditField = new BasicEditField(BaseCfgScreen.resources.getString(54) + ' ', Integer.toString(popConfig.getMaxMessageLines()));
            this.popMaxLinesEditField.setFilter(TextFilter.get((int)1));
            manager.add((Field)this.popMaxLinesEditField);
        }
        return manager;
    }

    public void AcctCfgScreen_fieldChanged(Field field, int context) {
        if (field == this.serverSslField) {
            if (this.acctConfig instanceof PopConfig) {
                if (this.serverSslField.getChecked()) {
                    this.serverPortField.setText("995");
                } else {
                    this.serverPortField.setText("110");
                }
            } else if (this.acctConfig instanceof ImapConfig) {
                if (this.serverSslField.getChecked()) {
                    this.serverPortField.setText("993");
                } else {
                    this.serverPortField.setText("143");
                }
            }
        } else if (field == this.pageField) {
            int index = this.pageField.getSelectedIndex();
            if (this.contentFieldManager.getField(0) != this.pageFieldManagers[index]) {
                this.contentFieldManager.deleteAll();
                this.contentFieldManager.add((Field)this.pageFieldManagers[index]);
            }
        }
    }

    protected boolean trackwheelUnclick(int status, int time) {
        if (this.getFieldWithFocus() == this.contentFieldManager && this.contentFieldManager.getField(0) == this.pageFieldManagers[1]) {
            if (this.pageFieldManagers[1].getFieldWithFocus() == this.sentFolderChoiceButtonLabel) {
                this.showFolderSelection(this.sentFolderChoiceButtonLabel);
                return true;
            }
            if (this.pageFieldManagers[1].getFieldWithFocus() == this.draftFolderChoiceButtonLabel) {
                this.showFolderSelection(this.draftFolderChoiceButtonLabel);
                return true;
            }
            return super.trackwheelUnclick(status, time);
        }
        return super.trackwheelUnclick(status, time);
    }

    private void showFolderSelection(LabelField choiceButtonLabel) {
        String titleText;
        if (choiceButtonLabel == this.sentFolderChoiceButtonLabel) {
            titleText = BaseCfgScreen.resources.getString(33);
        } else if (choiceButtonLabel == this.draftFolderChoiceButtonLabel) {
            titleText = BaseCfgScreen.resources.getString(91);
        } else {
            return;
        }
        Object[] accountNodes = MailManager.getInstance().getMailRootNode().getAccounts();
        Vector<Object> accountNodeVector = new Vector<Object>();
        for (int i = 0; i < accountNodes.length; ++i) {
            if (accountNodes[i].getStatus() != 0 && ((AccountNode)accountNodes[i]).getAccountConfig() != this.acctConfig) continue;
            accountNodeVector.addElement(accountNodes[i]);
        }
        accountNodes = new AccountNode[accountNodeVector.size()];
        accountNodeVector.copyInto(accountNodes);
        MailboxSelectionDialog dialog = new MailboxSelectionDialog(titleText, (AccountNode[])accountNodes);
        if (choiceButtonLabel == this.sentFolderChoiceButtonLabel) {
            dialog.setSelectedMailboxNode(this.selectedSentFolder);
        } else if (choiceButtonLabel == this.draftFolderChoiceButtonLabel) {
            dialog.setSelectedMailboxNode(this.selectedDraftFolder);
        }
        dialog.doModal();
        MailboxNode selectedNode = dialog.getSelectedMailboxNode();
        if (selectedNode != null) {
            choiceButtonLabel.setText((Object)this.createSelectedMailboxString(selectedNode));
            if (choiceButtonLabel == this.sentFolderChoiceButtonLabel) {
                if (this.selectedSentFolder != selectedNode) {
                    this.selectedSentFolder = selectedNode;
                    this.setDirty(true);
                }
            } else if (choiceButtonLabel == this.draftFolderChoiceButtonLabel && this.selectedDraftFolder != selectedNode) {
                this.selectedDraftFolder = selectedNode;
                this.setDirty(true);
            }
        }
    }

    private String createSelectedMailboxString(MailboxNode mailboxNode) {
        StringBuffer buf = new StringBuffer();
        if (mailboxNode != null) {
            buf.append(mailboxNode.getParentAccount().toString());
            buf.append(": ");
            buf.append(mailboxNode.toString());
        } else {
            buf.append("<NONE>");
        }
        return buf.toString();
    }

    protected boolean onSavePrompt() {
        if (this.acctNameField.getText().length() > 0 && this.serverNameField.getText().length() > 0 && this.serverPortField.getText().length() > 0) {
            return super.onSavePrompt();
        }
        int result = Dialog.ask((String)BaseCfgScreen.resources.getString(36), (Object[])new String[]{BaseCfgScreen.resources.getString(37), BaseCfgScreen.resources.getString(38)}, (int)0);
        return result == 0;
    }

    public void save() {
        this.acctConfig.setAcctName(this.acctNameField.getText());
        this.acctConfig.setServerName(this.serverNameField.getText());
        this.acctConfig.setServerSSL(this.serverSslField.getChecked());
        this.acctConfig.setServerPort(Integer.parseInt(this.serverPortField.getText()));
        this.acctConfig.setServerUser(this.serverUserField.getText());
        this.acctConfig.setServerPass(this.serverPassField.getText());
        this.acctConfig.setDeviceSide(!this.useMdsField.getChecked());
        IdentityConfig selectedIdentityConfig = (IdentityConfig)this.identityField.getChoice(this.identityField.getSelectedIndex());
        if (this.createDefaultIdentity) {
            String userName = this.serverUserField.getText();
            if (userName.length() == 0) {
                userName = "user";
            }
            selectedIdentityConfig.setEmailAddress(userName + "@" + this.serverNameField.getText());
            MailSettings.getInstance().addIdentityConfig(selectedIdentityConfig);
            this.createDefaultIdentity = false;
        }
        this.acctConfig.setIdentityConfig(selectedIdentityConfig);
        OutgoingConfig selectedOutgoingConfig = (OutgoingConfig)this.outgoingServerField.getChoice(this.outgoingServerField.getSelectedIndex());
        if (selectedOutgoingConfig.getUniqueId() == -1L) {
            this.acctConfig.setOutgoingConfig(null);
        } else {
            this.acctConfig.setOutgoingConfig(selectedOutgoingConfig);
        }
        this.acctConfig.setSentMailbox(this.selectedSentFolder);
        this.acctConfig.setDraftMailbox(this.selectedDraftFolder);
        if (this.acctConfig instanceof ImapConfig) {
            ImapConfig imapConfig = (ImapConfig)this.acctConfig;
            String folderPrefix = this.imapFolderPrefixField.getText().trim();
            if (folderPrefix.length() == 0) {
                imapConfig.setFolderPrefix(null);
            } else {
                imapConfig.setFolderPrefix(folderPrefix);
            }
            try {
                imapConfig.setMaxMessageSize(Integer.parseInt(this.imapMaxMessageSizeEditField.getText()) * 1024);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                imapConfig.setMaxFolderDepth(Integer.parseInt(this.imapMaxFolderDepthEditField.getText()));
            }
            catch (Exception e) {}
        } else if (this.acctConfig instanceof PopConfig) {
            PopConfig popConfig = (PopConfig)this.acctConfig;
            try {
                popConfig.setMaxMessageLines(Integer.parseInt(this.popMaxLinesEditField.getText()));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.acctSaved = true;
    }

    public boolean acctSaved() {
        return this.acctSaved;
    }

    private class NullOutgoingConfig
    extends OutgoingConfig {
        private NullOutgoingConfig() {
        }

        public String toString() {
            return "None";
        }

        public long getUniqueId() {
            return -1L;
        }
    }
}

