/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.MenuItem;
import net.rim.device.api.ui.Screen;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.LabelField;
import net.rim.device.api.ui.component.Menu;
import net.rim.device.api.ui.component.Status;
import net.rim.device.api.ui.container.MainScreen;
import org.logicprobe.LogicMail.mail.MailConnectionListener;
import org.logicprobe.LogicMail.mail.MailConnectionLoginEvent;
import org.logicprobe.LogicMail.mail.MailConnectionManager;
import org.logicprobe.LogicMail.mail.MailConnectionStateEvent;
import org.logicprobe.LogicMail.mail.MailConnectionStatusEvent;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailManager;
import org.logicprobe.LogicMail.ui.AboutDialog;
import org.logicprobe.LogicMail.ui.ConfigScreen;
import org.logicprobe.LogicMail.ui.HeaderField;
import org.logicprobe.LogicMail.ui.LoginDialog;
import org.logicprobe.LogicMail.ui.NavigationController;
import org.logicprobe.LogicMail.ui.NotificationHandler;
import org.logicprobe.LogicMail.util.EventObjectRunnable;

public abstract class BaseScreen
extends MainScreen {
    protected static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private NavigationController navigationController;
    private HeaderField headerField;
    private LabelField statusLabel;
    private boolean isExposed = false;
    private static final int MENU_CONTEXT = 65536;
    private static final int MENU_MAIN = 0x40000000;
    private MailConnectionListener mailConnectionListener = new MailConnectionListener(){

        public void mailConnectionStateChanged(MailConnectionStateEvent e) {
        }

        public void mailConnectionStatus(MailConnectionStatusEvent e) {
            if (BaseScreen.this.isExposed) {
                BaseScreen.this.mailConnectionListener_MailConnectionStatus(e);
            }
        }

        public void mailConnectionError(MailConnectionStatusEvent e) {
            if (BaseScreen.this.isExposed) {
                BaseScreen.this.mailConnectionListener_MailConnectionError(e);
            }
        }

        public void mailConnectionLogin(MailConnectionLoginEvent e) {
            if (BaseScreen.this.isExposed) {
                BaseScreen.this.mailConnectionListener_MailConnectionLogin(e);
            }
        }
    };
    private MenuItem configItem = new MenuItem(resources, 1, 10020, 10){

        public void run() {
            BaseScreen.this.showConfigScreen();
        }
    };
    private MenuItem aboutItem = new MenuItem(resources, 2, 10050, 10){

        public void run() {
            AboutDialog dialog = new AboutDialog();
            dialog.doModal();
        }
    };
    private MenuItem closeItem = new MenuItem(resources, 3, 200000, 10){

        public void run() {
            BaseScreen.this.onClose();
        }
    };
    private MenuItem exitItem = new MenuItem(resources, 4, 200001, 10){

        public void run() {
            BaseScreen.this.tryShutdownApplication();
        }
    };

    public BaseScreen(NavigationController navigationController) {
        this.navigationController = navigationController;
        this.statusLabel = new LabelField();
        this.setStatus(null);
    }

    public BaseScreen(NavigationController navigationController, long style) {
        super(style);
        this.navigationController = navigationController;
        this.statusLabel = new LabelField();
        this.setStatus(null);
    }

    public BaseScreen(NavigationController navigationController, String title) {
        this.navigationController = navigationController;
        this.headerField = new HeaderField("LogicMail - " + title);
        this.setTitle(this.headerField);
        this.statusLabel = new LabelField();
        this.setStatus(null);
    }

    public BaseScreen(String title, long style) {
        super(style);
        this.headerField = new HeaderField("LogicMail - " + title);
        this.setTitle(this.headerField);
        this.statusLabel = new LabelField();
        this.setStatus(null);
    }

    protected NavigationController getNavigationController() {
        return this.navigationController;
    }

    protected void onDisplay() {
        super.onDisplay();
        this.isExposed = true;
        MailConnectionManager.getInstance().addMailConnectionListener(this.mailConnectionListener);
        NotificationHandler.getInstance().cancelNotification();
    }

    protected void onUndisplay() {
        this.isExposed = false;
        MailConnectionManager.getInstance().removeMailConnectionListener(this.mailConnectionListener);
        NotificationHandler.getInstance().cancelNotification();
        super.onUndisplay();
    }

    protected void onExposed() {
        super.onExposed();
        this.isExposed = true;
    }

    protected void onObscured() {
        super.onObscured();
        this.isExposed = false;
    }

    public boolean onMenu(int instance) {
        if (instance == 0x40000000) {
            return super.onMenu(instance);
        }
        if (instance == 65536) {
            if (!this.onClick()) {
                return super.onMenu(instance);
            }
            return false;
        }
        return super.onMenu(instance);
    }

    protected boolean onClick() {
        return false;
    }

    protected void tryShutdownApplication() {
        int i;
        AccountNode[] accounts = MailManager.getInstance().getMailRootNode().getAccounts();
        boolean openConnection = false;
        for (i = 0; i < accounts.length; ++i) {
            if (accounts[i].getStatus() != 2) continue;
            openConnection = true;
            break;
        }
        if (openConnection) {
            if (Dialog.ask((int)3, (String)resources.getString(5)) == 4) {
                for (i = 0; i < accounts.length; ++i) {
                    if (accounts[i].getStatus() != 2) continue;
                    accounts[i].requestDisconnect(true);
                }
                this.headerField.removeListeners();
                NotificationHandler.getInstance().shutdown();
                System.exit(0);
            }
        } else {
            this.headerField.removeListeners();
            NotificationHandler.getInstance().shutdown();
            System.exit(0);
        }
    }

    protected void showConfigScreen() {
        UiApplication.getUiApplication().pushModalScreen((Screen)new ConfigScreen());
    }

    protected void makeMenu(Menu menu, int instance) {
        menu.addSeparator();
        menu.add(this.configItem);
        menu.add(this.aboutItem);
        menu.add(this.closeItem);
        menu.add(this.exitItem);
    }

    protected boolean onSavePrompt() {
        return true;
    }

    protected void mailConnectionListener_MailConnectionStatus(MailConnectionStatusEvent e) {
        UiApplication.getUiApplication().invokeLater((Runnable)new EventObjectRunnable(e){

            public void run() {
                String message = ((MailConnectionStatusEvent)this.getEvent()).getMessage();
                if (message != null) {
                    BaseScreen.this.statusLabel.setText((Object)message);
                    BaseScreen.this.setStatus((Field)BaseScreen.this.statusLabel);
                } else {
                    BaseScreen.this.statusLabel.setText((Object)"");
                    BaseScreen.this.setStatus(null);
                }
            }
        });
    }

    protected void mailConnectionListener_MailConnectionError(MailConnectionStatusEvent e) {
        UiApplication.getUiApplication().invokeLater((Runnable)new EventObjectRunnable(e){

            public void run() {
                String message = ((MailConnectionStatusEvent)this.getEvent()).getMessage();
                if (message == null) {
                    message = resources.getString(6);
                }
                try {
                    Screen activeScreen = UiApplication.getUiApplication().getActiveScreen();
                    if (activeScreen instanceof Status) {
                        UiApplication.getUiApplication().popScreen(activeScreen);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Status.show((String)message, (int)5000);
            }
        });
    }

    protected void mailConnectionListener_MailConnectionLogin(MailConnectionLoginEvent e) {
        UiApplication.getUiApplication().invokeAndWait((Runnable)new EventObjectRunnable(e){

            public void run() {
                MailConnectionLoginEvent e = (MailConnectionLoginEvent)this.getEvent();
                LoginDialog dialog = new LoginDialog(e.getUsername(), e.getPassword());
                if (dialog.doModal() == 0) {
                    e.setUsername(dialog.getUsername());
                    e.setPassword(dialog.getPassword());
                } else {
                    e.setCanceled(true);
                }
            }
        });
    }
}

