/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Calendar;
import java.util.Date;
import net.rim.device.api.i18n.DateFormat;
import net.rim.device.api.system.Bitmap;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import org.logicprobe.LogicMail.message.MessagePart;
import org.logicprobe.LogicMail.model.Address;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.MessageNode;
import org.logicprobe.LogicMail.ui.NodeIcons;

public class MailboxMessageField
extends Field {
    private MailboxNode mailboxNode;
    private MessageNode messageNode;
    private int lineHeight;
    private int maxWidth;

    public MailboxMessageField(MailboxNode mailboxNode, MessageNode messageNode) {
        this.mailboxNode = mailboxNode;
        this.messageNode = messageNode;
    }

    public MailboxMessageField(MailboxNode mailboxNode, MessageNode messageNode, long style) {
        super(style);
        this.mailboxNode = mailboxNode;
        this.messageNode = messageNode;
    }

    public MessageNode getMessageNode() {
        return this.messageNode;
    }

    protected void layout(int width, int height) {
        this.maxWidth = width;
        this.lineHeight = this.getPreferredHeight() / 2;
        this.setExtent(width, this.getPreferredHeight());
    }

    public int getPreferredHeight() {
        return Font.getDefault().getHeight() * 2;
    }

    public void invalidate() {
        super.invalidate();
    }

    protected void onUnfocus() {
        super.invalidate();
        super.onUnfocus();
    }

    protected void paint(Graphics graphics) {
        String subject;
        String senderText = this.createSenderText();
        String dateString = this.createDisplayDate();
        Bitmap attachmentIcon = null;
        MessagePart[] attachments = this.messageNode.getAttachmentParts();
        if (attachments != null && attachments.length > 0) {
            attachmentIcon = Bitmap.getBitmapResource((String)"mail_attachment.png");
        }
        boolean isFocus = this.isFocus();
        int width = this.getWidth();
        int originalColor = graphics.getColor();
        int dateWidth = Font.getDefault().getAdvance(dateString);
        int senderWidth = this.maxWidth - dateWidth - 20;
        graphics.setColor(0xA9A9A9);
        graphics.drawLine(0, this.lineHeight * 2 - 1, width, this.lineHeight * 2 - 1);
        graphics.setColor(originalColor);
        Bitmap messageIcon = NodeIcons.getIcon(this.messageNode);
        graphics.drawBitmap(1, this.lineHeight / 2 - messageIcon.getHeight() / 2, 20, this.lineHeight * 2, messageIcon, 0, 0);
        if (attachmentIcon != null) {
            graphics.drawBitmap(1, this.lineHeight, 20, this.lineHeight * 2, attachmentIcon, 0, 0);
        }
        if (senderText != null) {
            graphics.drawText(senderText, 20, 0, 64, senderWidth);
        }
        if ((subject = this.messageNode.getSubject()) != null) {
            if (!isFocus) {
                graphics.setColor(0x7B7B7B);
            }
            graphics.drawText(subject, 20, this.lineHeight, 64, this.maxWidth - 20);
            if (!isFocus) {
                graphics.setColor(originalColor);
            }
        }
        if (dateString != null) {
            graphics.drawText(dateString, senderWidth + 20, 0, 64, dateWidth);
        }
    }

    private String createSenderText() {
        Address sender = null;
        if (this.mailboxNode.getType() == 4) {
            Address[] to = this.messageNode.getTo();
            if (to != null && to.length > 0) {
                sender = to[0];
            }
        } else {
            Address[] from = this.messageNode.getFrom();
            if (from != null && from.length > 0) {
                sender = from[0];
            }
        }
        if (sender != null) {
            String senderText = sender.getName();
            if (senderText == null || senderText.length() == 0) {
                senderText = sender.getAddress();
            }
            return senderText;
        }
        return null;
    }

    private String createDisplayDate() {
        Date date = this.messageNode.getDate();
        if (date == null) {
            return null;
        }
        Calendar nowCal = Calendar.getInstance();
        Calendar dispCal = Calendar.getInstance();
        dispCal.setTime(date);
        DateFormat dateFormat = nowCal.get(1) == dispCal.get(1) ? (nowCal.get(2) == dispCal.get(2) && nowCal.get(5) == dispCal.get(5) ? DateFormat.getInstance((int)6) : DateFormat.getInstance((int)56)) : DateFormat.getInstance((int)56);
        StringBuffer buffer = new StringBuffer();
        dateFormat.format(dispCal, buffer, null);
        return buffer.toString();
    }
}

