/*
 * Decompiled with CFR 0.152.
 */
package org.logicprobe.LogicMail.ui;

import java.util.Hashtable;
import net.rim.device.api.i18n.ResourceBundle;
import net.rim.device.api.ui.Field;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.Graphics;
import net.rim.device.api.ui.component.Dialog;
import net.rim.device.api.ui.component.TreeField;
import net.rim.device.api.ui.component.TreeFieldCallback;
import org.logicprobe.LogicMail.model.AccountNode;
import org.logicprobe.LogicMail.model.MailboxNode;
import org.logicprobe.LogicMail.model.Node;

public class MailboxSelectionDialog
extends Dialog {
    protected static ResourceBundle resources = ResourceBundle.getBundle((long)-3280279784971445078L, (String)"org.logicprobe.LogicMail.LogicMail");
    private AccountNode[] accounts;
    private Hashtable nodeIdMap;
    private MailboxNode selectedMailboxNode;
    private TreeField treeField;
    private Hashtable unselectableNodeSet;

    public MailboxSelectionDialog(String title, AccountNode[] accounts) {
        super(title, new Object[0], new int[0], 0, null, 0x100000000000L);
        this.setEscapeEnabled(true);
        this.accounts = accounts;
        this.initFields();
        this.nodeIdMap = new Hashtable();
        this.unselectableNodeSet = new Hashtable();
        this.populateTreeField();
    }

    private void initFields() {
        this.treeField = new TreeField(new TreeFieldCallback(){

            public void drawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
                MailboxSelectionDialog.this.treeField_DrawTreeItem(treeField, graphics, node, y, width, indent);
            }
        }, 0x40000000000000L);
        this.treeField.setDefaultExpanded(true);
        this.treeField.setIndentWidth(20);
        this.add((Field)this.treeField);
    }

    public void setSelectedMailboxNode(MailboxNode mailboxNode) {
        if (mailboxNode != null && this.nodeIdMap.containsKey(mailboxNode)) {
            int id = (Integer)this.nodeIdMap.get(mailboxNode);
            this.treeField.setCurrentNode(id);
        }
        this.selectedMailboxNode = mailboxNode;
    }

    public MailboxNode getSelectedMailboxNode() {
        return this.selectedMailboxNode;
    }

    public void addUnselectableNode(MailboxNode mailboxNode) {
        if (!this.unselectableNodeSet.containsKey(mailboxNode)) {
            this.unselectableNodeSet.put(mailboxNode, new Object());
        }
    }

    public void removeUnselectableNode(MailboxNode mailboxNode) {
        if (this.unselectableNodeSet.containsKey(mailboxNode)) {
            this.unselectableNodeSet.remove(mailboxNode);
        }
    }

    private void populateTreeField() {
        int firstNode = -1;
        for (int i = this.accounts.length - 1; i >= 0; --i) {
            int id = this.treeField.addChildNode(0, (Object)this.accounts[i]);
            if (i == 0) {
                firstNode = id;
            }
            this.nodeIdMap.put(this.accounts[i], new Integer(id));
            MailboxNode rootMailbox = this.accounts[i].getRootMailbox();
            if (rootMailbox == null) continue;
            MailboxNode[] mailboxNodes = rootMailbox.getMailboxes();
            for (int j = mailboxNodes.length - 1; j >= 0; --j) {
                this.populateTreeFieldMailbox(id, mailboxNodes[j]);
            }
        }
        if (firstNode != -1) {
            this.treeField.setCurrentNode(firstNode);
        }
    }

    private void populateTreeFieldMailbox(int parent, MailboxNode mailboxNode) {
        int id = this.treeField.addChildNode(parent, (Object)mailboxNode);
        this.nodeIdMap.put(mailboxNode, new Integer(id));
        MailboxNode[] mailboxes = mailboxNode.getMailboxes();
        for (int i = mailboxes.length - 1; i >= 0; --i) {
            this.populateTreeFieldMailbox(id, mailboxes[i]);
        }
    }

    private void treeField_DrawTreeItem(TreeField treeField, Graphics graphics, int node, int y, int width, int indent) {
        Node treeNode = (Node)treeField.getCookie(node);
        Font font = graphics.getFont();
        if (treeNode instanceof AccountNode) {
            graphics.setFont(font.derive(1));
        } else if (treeNode instanceof MailboxNode && !((MailboxNode)treeNode).hasAppend()) {
            graphics.setFont(font.derive(2));
        } else {
            graphics.setFont(font.derive(0));
        }
        graphics.drawText(treeNode.toString(), indent, y, 64, width);
    }

    private MailboxNode getCurrentMailboxNode() {
        MailboxNode result;
        int id = this.treeField.getCurrentNode();
        if (id != -1 && this.treeField.getCookie(id) instanceof MailboxNode) {
            result = (MailboxNode)this.treeField.getCookie(id);
            if (!result.hasAppend() || this.unselectableNodeSet.containsKey(result)) {
                return null;
            }
        } else {
            result = null;
        }
        return result;
    }

    protected boolean trackwheelUnclick(int status, int time) {
        MailboxNode currentMailboxNode = this.getCurrentMailboxNode();
        if (currentMailboxNode != null) {
            this.selectedMailboxNode = currentMailboxNode;
            this.close();
            return true;
        }
        return super.trackwheelClick(status, time);
    }

    protected boolean keyChar(char key, int status, int time) {
        boolean retval = false;
        switch (key) {
            case '\n': {
                MailboxNode currentMailboxNode = this.getCurrentMailboxNode();
                if (currentMailboxNode == null) break;
                this.selectedMailboxNode = currentMailboxNode;
                this.close();
                retval = true;
            }
        }
        if (!retval) {
            retval = super.keyChar(key, status, time);
        }
        return retval;
    }
}

